/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.network;

import com.afoxxvi.asteorbar.AsteorBar;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;

public class NetworkHandler {
    private static boolean initialized = false;
    private static final ResourceLocation CHANNEL = ResourceLocation.fromNamespaceAndPath((String)"asteorbar", (String)"network");
    private static final byte INDEX_EXHAUSTION = 0;
    private static final byte INDEX_SATURATION = 1;
    private static final byte INDEX_ABSORPTION = 2;
    private static final byte INDEX_ACTIVATE = 3;
    private static final byte INDEX_TOUGH_AS_NAILS = 64;
    private static final Map<UUID, Float> EXHAUSTION = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> SATURATION = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> TOUGH_AS_NAILS_HYDRATION = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> TOUGH_AS_NAILS_EXHAUSTION = new HashMap<UUID, Float>();

    public static void handle(NetworkPayload payload, IPayloadContext context) {
        byte index = payload.index;
        switch (index) {
            case 0: {
                float exhaustion = payload.f1;
                context.enqueueWork(() -> context.player().getFoodData().setExhaustion(exhaustion));
                break;
            }
            case 1: {
                float saturation = payload.f1;
                context.enqueueWork(() -> context.player().getFoodData().setSaturation(saturation));
                break;
            }
            case 2: {
                int entityId = payload.i1;
                float absorption = payload.f1;
                context.enqueueWork(() -> {
                    Entity entity = context.player().level().getEntity(entityId);
                    if (entity instanceof LivingEntity) {
                        LivingEntity livingEntity = (LivingEntity)entity;
                        livingEntity.setAbsorptionAmount(absorption);
                    }
                });
                break;
            }
            case 3: {
                boolean activate = payload.i1 != 0;
                context.enqueueWork(() -> PacketDistributor.sendToServer((CustomPacketPayload)new NetworkPayload(3, 0.0f, 0.0f, activate ? 1 : 0), (CustomPacketPayload[])new CustomPacketPayload[0]));
                break;
            }
            case 64: {
                float hydration = payload.f1;
                float exhaustion = payload.f2;
                context.enqueueWork(() -> {
                    IThirst thirst = ThirstHelper.getThirst((Player)context.player());
                    thirst.setHydration(hydration);
                    thirst.setExhaustion(exhaustion);
                });
                break;
            }
        }
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("asteorbar").optional();
        registrar.playToClient(NetworkPayload.ID, NetworkPayload.PAYLOAD_CODEC, NetworkHandler::handle);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            FoodData foodStats = player2.getFoodData();
            float exhaustionLevel = foodStats.getExhaustionLevel();
            Float oldExhaustion = EXHAUSTION.get(player2.getUUID());
            if (oldExhaustion == null || Math.abs(oldExhaustion.floatValue() - exhaustionLevel) >= 0.01f) {
                EXHAUSTION.put(player2.getUUID(), Float.valueOf(exhaustionLevel));
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new NetworkPayload(0, exhaustionLevel, 0.0f, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            float saturationLevel = foodStats.getSaturationLevel();
            Float oldSaturation = SATURATION.get(player2.getUUID());
            if (oldSaturation == null || Math.abs(oldSaturation.floatValue() - saturationLevel) >= 0.01f) {
                SATURATION.put(player2.getUUID(), Float.valueOf(saturationLevel));
                PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new NetworkPayload(1, saturationLevel, 0.0f, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (!initialized) {
                initialized = true;
                AsteorBar.compatibility.init();
            }
            if (AsteorBar.compatibility.toughAsNails) {
                IThirst thirst = ThirstHelper.getThirst((Player)player2);
                boolean send = false;
                float hydration = thirst.getHydration();
                Float oldHydration = TOUGH_AS_NAILS_HYDRATION.get(player2.getUUID());
                if (oldHydration == null || Math.abs(oldHydration.floatValue() - hydration) >= 0.01f) {
                    TOUGH_AS_NAILS_HYDRATION.put(player2.getUUID(), Float.valueOf(hydration));
                    send = true;
                }
                float exhaustion = thirst.getExhaustion();
                Float oldToughAsNailsExhaustion = TOUGH_AS_NAILS_EXHAUSTION.get(player2.getUUID());
                if (oldToughAsNailsExhaustion == null || Math.abs(oldToughAsNailsExhaustion.floatValue() - exhaustion) >= 0.01f) {
                    TOUGH_AS_NAILS_EXHAUSTION.put(player2.getUUID(), Float.valueOf(exhaustion));
                    send = true;
                }
                if (send) {
                    PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new NetworkPayload(64, hydration, exhaustion, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    public record NetworkPayload(byte index, float f1, float f2, int i1) implements CustomPacketPayload
    {
        public static final StreamCodec<FriendlyByteBuf, NetworkPayload> PAYLOAD_CODEC = CustomPacketPayload.codec(NetworkPayload::write, NetworkPayload::read);
        public static final CustomPacketPayload.Type<NetworkPayload> ID = new CustomPacketPayload.Type(CHANNEL);

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }

        public static NetworkPayload read(FriendlyByteBuf friendlyByteBuf) {
            return new NetworkPayload(friendlyByteBuf.readByte(), friendlyByteBuf.readFloat(), friendlyByteBuf.readFloat(), friendlyByteBuf.readInt());
        }

        public void write(FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeByte(this.index).writeFloat(this.f1).writeFloat(this.f2).writeInt(this.i1);
        }
    }
}

