/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.parts.AirLevelOverlay;
import com.afoxxvi.asteorbar.overlay.parts.ArmorLevelOverlay;
import com.afoxxvi.asteorbar.overlay.parts.BaseOverlay;
import com.afoxxvi.asteorbar.overlay.parts.ExperienceBarOverlay;
import com.afoxxvi.asteorbar.overlay.parts.FoodLevelOverlay;
import com.afoxxvi.asteorbar.overlay.parts.MainOverlay;
import com.afoxxvi.asteorbar.overlay.parts.MountHealthOverlay;
import com.afoxxvi.asteorbar.overlay.parts.PlayerHealthOverlay;
import com.afoxxvi.asteorbar.overlay.parts.StringOverlay;
import com.afoxxvi.asteorbar.utils.GuiHelper;
import com.afoxxvi.asteorbar.utils.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Overlays {
    public static final int STYLE_NONE = 0;
    public static final int STYLE_ABOVE_HOT_BAR_LONG = 1;
    public static final int STYLE_ABOVE_HOT_BAR_SHORT = 2;
    public static final int STYLE_TOP_BOTH_SIDES = 3;
    public static final int STYLE_BOTTOM_BOTH_SIDES = 4;
    public static final int STYLE_TOP_LEFT = 5;
    public static final int STYLE_TOP_RIGHT = 6;
    public static final int STYLE_BOTTOM_LEFT = 7;
    public static final int STYLE_BOTTOM_RIGHT = 8;
    public static final int NUM_STYLES = 9;
    public static final MainOverlay MAIN = new MainOverlay();
    public static final PlayerHealthOverlay PLAYER_HEALTH = new PlayerHealthOverlay();
    public static final FoodLevelOverlay FOOD_LEVEL = new FoodLevelOverlay();
    public static final AirLevelOverlay AIR_LEVEL = new AirLevelOverlay();
    public static final ExperienceBarOverlay EXPERIENCE_BAR = new ExperienceBarOverlay();
    public static final MountHealthOverlay MOUNT_HEALTH = new MountHealthOverlay();
    public static final ArmorLevelOverlay ARMOR_LEVEL = new ArmorLevelOverlay();
    public static final StringOverlay STRING = new StringOverlay();
    public static int style = 0;
    public static int cornerLeftHeight = 0;
    public static int cornerRightHeight = 0;
    public static int horizontalOffset = 0;
    public static int length = 10;
    public static int leftHeight = 39;
    public static int rightHeight = 39;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static List<Render> stringRenders = new ArrayList<Render>();
    private static boolean initialized = false;
    private static final List<Pair<BaseOverlay, Position>> NONE = List.of();
    private static final List<Pair<BaseOverlay, Position>> ORDER_ABOVE_HOT_BAR_LONG = Arrays.asList(new Pair<ExperienceBarOverlay, Position>(EXPERIENCE_BAR, Position.FULL_BOTTOM), new Pair<FoodLevelOverlay, Position>(FOOD_LEVEL, Position.FULL_BOTTOM), new Pair<PlayerHealthOverlay, Position>(PLAYER_HEALTH, Position.FULL_BOTTOM), new Pair<MountHealthOverlay, Position>(MOUNT_HEALTH, Position.HALF_BOTTOM_RIGHT), new Pair<ArmorLevelOverlay, Position>(ARMOR_LEVEL, Position.HALF_BOTTOM_LEFT), new Pair<AirLevelOverlay, Position>(AIR_LEVEL, Position.HALF_BOTTOM_RIGHT));
    private static final List<Pair<BaseOverlay, Position>> ORDER_ABOVE_HOT_BAR_SHORT = Arrays.asList(new Pair<ExperienceBarOverlay, Position>(EXPERIENCE_BAR, Position.FULL_BOTTOM), new Pair<PlayerHealthOverlay, Position>(PLAYER_HEALTH, Position.HALF_BOTTOM_LEFT), new Pair<FoodLevelOverlay, Position>(FOOD_LEVEL, Position.HALF_BOTTOM_RIGHT), new Pair<MountHealthOverlay, Position>(MOUNT_HEALTH, Position.HALF_BOTTOM_RIGHT), new Pair<ArmorLevelOverlay, Position>(ARMOR_LEVEL, Position.HALF_BOTTOM_LEFT), new Pair<AirLevelOverlay, Position>(AIR_LEVEL, Position.HALF_BOTTOM_RIGHT));
    private static final List<Pair<BaseOverlay, Position>> ORDER_TOP_BOTH_SIDES = Arrays.asList(new Pair<PlayerHealthOverlay, Position>(PLAYER_HEALTH, Position.TOP_LEFT), new Pair<MountHealthOverlay, Position>(MOUNT_HEALTH, Position.TOP_LEFT), new Pair<FoodLevelOverlay, Position>(FOOD_LEVEL, Position.TOP_RIGHT), new Pair<ExperienceBarOverlay, Position>(EXPERIENCE_BAR, Position.TOP_LEFT), new Pair<ArmorLevelOverlay, Position>(ARMOR_LEVEL, Position.TOP_LEFT), new Pair<AirLevelOverlay, Position>(AIR_LEVEL, Position.TOP_RIGHT));
    private static final List<Pair<BaseOverlay, Position>> ORDER_BOTTOM_BOTH_SIDES = Arrays.asList(new Pair<PlayerHealthOverlay, Position>(PLAYER_HEALTH, Position.BOTTOM_LEFT), new Pair<MountHealthOverlay, Position>(MOUNT_HEALTH, Position.BOTTOM_LEFT), new Pair<ExperienceBarOverlay, Position>(EXPERIENCE_BAR, Position.BOTTOM_LEFT), new Pair<FoodLevelOverlay, Position>(FOOD_LEVEL, Position.BOTTOM_RIGHT), new Pair<ArmorLevelOverlay, Position>(ARMOR_LEVEL, Position.BOTTOM_LEFT), new Pair<AirLevelOverlay, Position>(AIR_LEVEL, Position.BOTTOM_RIGHT));
    private static final List<Pair<BaseOverlay, Position>> ORDER_TOP_LEFT = Arrays.asList(new Pair<PlayerHealthOverlay, Position>(PLAYER_HEALTH, Position.TOP_LEFT), new Pair<MountHealthOverlay, Position>(MOUNT_HEALTH, Position.TOP_LEFT), new Pair<FoodLevelOverlay, Position>(FOOD_LEVEL, Position.TOP_LEFT), new Pair<ExperienceBarOverlay, Position>(EXPERIENCE_BAR, Position.TOP_LEFT), new Pair<ArmorLevelOverlay, Position>(ARMOR_LEVEL, Position.TOP_LEFT), new Pair<AirLevelOverlay, Position>(AIR_LEVEL, Position.TOP_LEFT));
    private static final List<Pair<BaseOverlay, Position>> ORDER_TOP_RIGHT = Arrays.asList(new Pair<PlayerHealthOverlay, Position>(PLAYER_HEALTH, Position.TOP_RIGHT), new Pair<MountHealthOverlay, Position>(MOUNT_HEALTH, Position.TOP_RIGHT), new Pair<FoodLevelOverlay, Position>(FOOD_LEVEL, Position.TOP_RIGHT), new Pair<ExperienceBarOverlay, Position>(EXPERIENCE_BAR, Position.TOP_RIGHT), new Pair<ArmorLevelOverlay, Position>(ARMOR_LEVEL, Position.TOP_RIGHT), new Pair<AirLevelOverlay, Position>(AIR_LEVEL, Position.TOP_RIGHT));
    private static final List<Pair<BaseOverlay, Position>> ORDER_BOTTOM_LEFT = Arrays.asList(new Pair<ExperienceBarOverlay, Position>(EXPERIENCE_BAR, Position.BOTTOM_LEFT), new Pair<FoodLevelOverlay, Position>(FOOD_LEVEL, Position.BOTTOM_LEFT), new Pair<PlayerHealthOverlay, Position>(PLAYER_HEALTH, Position.BOTTOM_LEFT), new Pair<MountHealthOverlay, Position>(MOUNT_HEALTH, Position.BOTTOM_LEFT), new Pair<ArmorLevelOverlay, Position>(ARMOR_LEVEL, Position.BOTTOM_LEFT), new Pair<AirLevelOverlay, Position>(AIR_LEVEL, Position.BOTTOM_LEFT));
    private static final List<Pair<BaseOverlay, Position>> ORDER_BOTTOM_RIGHT = Arrays.asList(new Pair<ExperienceBarOverlay, Position>(EXPERIENCE_BAR, Position.BOTTOM_RIGHT), new Pair<FoodLevelOverlay, Position>(FOOD_LEVEL, Position.BOTTOM_RIGHT), new Pair<PlayerHealthOverlay, Position>(PLAYER_HEALTH, Position.BOTTOM_RIGHT), new Pair<MountHealthOverlay, Position>(MOUNT_HEALTH, Position.BOTTOM_RIGHT), new Pair<ArmorLevelOverlay, Position>(ARMOR_LEVEL, Position.BOTTOM_RIGHT), new Pair<AirLevelOverlay, Position>(AIR_LEVEL, Position.BOTTOM_RIGHT));
    private static final List<List<Pair<BaseOverlay, Position>>> ORDER = Arrays.asList(new ArrayList<Pair<BaseOverlay, Position>>(NONE), new ArrayList<Pair<BaseOverlay, Position>>(ORDER_ABOVE_HOT_BAR_LONG), new ArrayList<Pair<BaseOverlay, Position>>(ORDER_ABOVE_HOT_BAR_SHORT), new ArrayList<Pair<BaseOverlay, Position>>(ORDER_TOP_BOTH_SIDES), new ArrayList<Pair<BaseOverlay, Position>>(ORDER_BOTTOM_BOTH_SIDES), new ArrayList<Pair<BaseOverlay, Position>>(ORDER_TOP_LEFT), new ArrayList<Pair<BaseOverlay, Position>>(ORDER_TOP_RIGHT), new ArrayList<Pair<BaseOverlay, Position>>(ORDER_BOTTOM_LEFT), new ArrayList<Pair<BaseOverlay, Position>>(ORDER_BOTTOM_RIGHT));

    public static void init() {
        initialized = true;
        AsteorBar.compatibility.init();
    }

    public static List<Pair<BaseOverlay, Position>> getCurrentOrder() {
        return ORDER.get(style);
    }

    public static void registerOverlayAtFirst(@NotNull BaseOverlay baseOverlay, @Nullable Position position) {
        Overlays.registerOverlay(baseOverlay, null, position, 0);
    }

    public static void registerOverlayAtLast(@NotNull BaseOverlay baseOverlay, @Nullable Position position) {
        Overlays.registerOverlay(baseOverlay, null, position, 1);
    }

    public static void registerOverlayAtRecommended(@NotNull BaseOverlay baseOverlay, @Nullable Position position) {
        Overlays.registerOverlay(baseOverlay, ARMOR_LEVEL, position, 0);
    }

    public static void registerOverlayBefore(@NotNull BaseOverlay baseOverlay, @NotNull BaseOverlay target, @Nullable Position position) {
        Overlays.registerOverlay(baseOverlay, target, position, 0);
    }

    public static void registerOverlayAfter(@NotNull BaseOverlay baseOverlay, @NotNull BaseOverlay target, @Nullable Position position) {
        Overlays.registerOverlay(baseOverlay, target, position, 1);
    }

    private static void registerOverlay(@NotNull BaseOverlay baseOverlay, @Nullable BaseOverlay target, @Nullable Position position, int shift) {
        if (position == null) {
            position = Position.UNSPECIFIED;
        }
        block0: for (int i = 1; i < ORDER.size(); ++i) {
            List<Pair<BaseOverlay, Position>> list = ORDER.get(i);
            list.removeIf(pair -> ((BaseOverlay)pair.getA()).getClass().equals(baseOverlay.getClass()));
            if (target == null) {
                list.add(shift * list.size(), new Pair<BaseOverlay, Position>(baseOverlay, position));
                continue;
            }
            for (int j = 0; j < list.size(); ++j) {
                if (!list.get(j).getA().getClass().equals(target.getClass())) continue;
                list.add(j + shift, new Pair<BaseOverlay, Position>(baseOverlay, position));
                continue block0;
            }
        }
    }

    public static void reset() {
        if (!initialized) {
            Overlays.init();
        }
        cornerLeftHeight = AsteorBar.config.cornerVerticalPadding();
        cornerRightHeight = AsteorBar.config.cornerVerticalPadding();
        horizontalOffset = AsteorBar.config.cornerHorizontalPadding();
        length = AsteorBar.config.cornerBarLength();
        style = AsteorBar.config.overlayLayoutStyle();
        stringRenders.clear();
        leftHeight = 39;
        rightHeight = 39;
    }

    public static void renderString(GuiGraphics guiGraphics) {
        if (stringRenders == null) {
            return;
        }
        guiGraphics.pose().pushPose();
        float scale = (float)AsteorBar.config.overlayTextScale();
        guiGraphics.pose().scale(scale, scale, 1.0f);
        Font font = Minecraft.getInstance().font;
        for (Render render : stringRenders) {
            int width = font.width(render.text);
            float x = (float)render.x / scale + (float)width / 2.0f * (1.0f / scale - 1.0f);
            float f = (float)render.y / scale;
            Objects.requireNonNull(font);
            float y = f + 9.0f / 2.0f * (1.0f / scale - 1.0f);
            if (render.bound) {
                GuiHelper.drawString(guiGraphics, render.text, (int)x + 1, (int)y, render.boundColor, render.shadow);
                GuiHelper.drawString(guiGraphics, render.text, (int)x - 1, (int)y, render.boundColor, render.shadow);
                GuiHelper.drawString(guiGraphics, render.text, (int)x, (int)y + 1, render.boundColor, render.shadow);
                GuiHelper.drawString(guiGraphics, render.text, (int)x, (int)y - 1, render.boundColor, render.shadow);
            }
            GuiHelper.drawString(guiGraphics, render.text, (int)x, (int)y, render.color, render.shadow);
        }
        guiGraphics.pose().popPose();
        stringRenders.clear();
    }

    public static void addStringRender(int x, int y, int color, String text, int align, boolean shadow) {
        Overlays.addStringRender(x, y, color, text, align, shadow, false, 0);
    }

    public static void addStringRender(int x, int y, int color, String text, int align, boolean shadow, boolean bound, int boundColor) {
        if (stringRenders == null) {
            stringRenders = new ArrayList<Render>();
        }
        Render render = new Render();
        render.x = x;
        render.y = y;
        render.color = color | 0xFF000000;
        render.text = text;
        render.align = align;
        render.shadow = shadow;
        switch (render.align) {
            case 1: {
                render.x -= Minecraft.getInstance().font.width(text) / 2;
                break;
            }
            case 2: {
                render.x -= Minecraft.getInstance().font.width(text);
            }
        }
        render.bound = bound;
        render.boundColor = boundColor | 0xFF000000;
        stringRenders.add(render);
    }

    public static enum Position {
        TOP_LEFT(false),
        TOP_RIGHT(true),
        BOTTOM_LEFT(false),
        BOTTOM_RIGHT(true),
        FULL_BOTTOM(false),
        HALF_BOTTOM_LEFT(false),
        HALF_BOTTOM_RIGHT(true),
        UNSPECIFIED(false);

        public final boolean flip;

        private Position(boolean flip) {
            this.flip = flip;
        }
    }

    private static class Render {
        int x;
        int y;
        int color;
        String text;
        int align;
        boolean shadow;
        boolean bound;
        int boundColor;

        private Render() {
        }
    }
}

