/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.Overlays;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.afoxxvi.asteorbar.utils.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.config.ClientConfigs;
import io.redspace.ironsspellbooks.gui.overlays.ManaBarOverlay;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class IronsSpellbooksOverlay
extends SimpleBarOverlay {
    @Override
    protected SimpleBarOverlay.Parameters getParameters(Player player) {
        int maxMana = (int)player.getAttributeValue((Holder)AttributeRegistry.MAX_MANA);
        int mana = ClientMagicData.getPlayerMana();
        SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
        parameters.fillColor = -16730132;
        parameters.boundColor = -16762294;
        parameters.emptyColor = -16762551;
        parameters.value = mana;
        parameters.capacity = maxMana;
        return parameters;
    }

    @Override
    protected void drawDecorations(GuiGraphics guiGraphics, int left, int top, int right, int bottom, SimpleBarOverlay.Parameters parameters, boolean flip) {
        super.drawDecorations(guiGraphics, left, top, right, bottom, parameters, flip);
        int innerWidth = right - left - 2;
        int textureWidth = Math.min(179, Math.max(0, (innerWidth + 5) / 10 - 1) * 10 + 9);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        this.drawTextureFillColor(guiGraphics, left + 1, top, innerWidth, 5, 10, 18, textureWidth, 5, parameters.fillColor);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LIGHTMAP_TEXTURE);
        if (((Boolean)ClientConfigs.MANA_BAR_TEXT_VISIBLE.get()).booleanValue()) {
            Overlays.addStringRender((left + right) / 2, top - 2, 0x55FFFF, Utils.formatNumber(parameters.value) + "/" + Utils.formatNumber(parameters.capacity), 1, true);
        }
    }

    @Override
    protected boolean shouldRender(Player player) {
        return AsteorBar.compatibility.ironsSpellbooks && AsteorBar.config.hookIronsSpellbooks() && ManaBarOverlay.shouldShowManaBar((Player)player);
    }
}

