/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.parts.FoodLevelOverlay;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.afoxxvi.asteorbar.utils.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ghen.thirst.foundation.common.capability.IThirst;
import dev.ghen.thirst.foundation.common.capability.ModAttachment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ThirstWasTakenOverlay
extends SimpleBarOverlay {
    private int thirstBlinkTime = 0;
    private float exhaustion;

    @Override
    protected SimpleBarOverlay.Parameters getParameters(Player player) {
        SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
        IThirst thirst = (IThirst)player.getData(ModAttachment.PLAYER_THIRST);
        int level = thirst.getThirst();
        float quenched = thirst.getQuenched();
        this.exhaustion = thirst.getExhaustion();
        int thirstColor = -13124924;
        if (AsteorBar.config.enableFoodBlink()) {
            if (quenched <= 0.0f && (long)this.tick % ((long)Math.max(4, level) * 3L + 1L) == 0L) {
                this.thirstBlinkTime = 2;
            }
            if (this.thirstBlinkTime > 0) {
                --this.thirstBlinkTime;
            }
        }
        boolean highlight = this.thirstBlinkTime > 0;
        parameters.boundColor = highlight ? Utils.mixColor(-1, thirstColor, 0.08) : Utils.mixColor(-16777216, thirstColor, 0.5);
        parameters.emptyColor = AsteorBar.config.foodEmptyColor();
        if (level <= 4) {
            parameters.verticalShift = FoodLevelOverlay.SHIFT[this.tick / (level + 1) % FoodLevelOverlay.SHIFT.length];
        }
        parameters.fillColor = thirstColor;
        parameters.capacity = 20.0;
        parameters.value = level;
        if (AsteorBar.config.displaySaturation()) {
            parameters.boundFillColor = -13802026;
            parameters.boundValue = quenched;
            parameters.boundCapacity = 10.0;
        }
        if (AsteorBar.config.displayFoodText()) {
            parameters.centerText = Utils.formatNumber(level) + "/" + Utils.formatNumber(20.0);
            parameters.centerColor = 0xFFFFFF;
        }
        return parameters;
    }

    @Override
    protected void drawDecorations(GuiGraphics guiGraphics, int left, int top, int right, int bottom, SimpleBarOverlay.Parameters parameters, boolean flip) {
        super.drawDecorations(guiGraphics, left, top, right, bottom, parameters, flip);
        int innerWidth = right - left - 2;
        if (AsteorBar.config.displayExhaustion()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            float cap = 4.0f;
            int exhaustionWidth = (int)((float)innerWidth * (Math.min(cap, this.exhaustion) / cap));
            this.drawTextureFillFlip(guiGraphics, left + 1, top, right - 1, exhaustionWidth, 5, 10, 9, 180, flip);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)LIGHTMAP_TEXTURE);
        }
    }

    @Override
    protected boolean shouldRender(Player player) {
        return AsteorBar.compatibility.thirst && AsteorBar.config.hookThirstWasTaken();
    }
}

