/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.mixin;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.entity.EntityRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityMixin {
    @Shadow
    public abstract <T extends Entity> net.minecraft.client.renderer.entity.EntityRenderer<? super T, ?> getRenderer(T var1);

    @Inject(method={"render(Lnet/minecraft/world/entity/Entity;DDDFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="TAIL")})
    private <E extends Entity> void render(E entity, double x, double y, double z, float p, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, CallbackInfo ci) {
        if (entity instanceof LivingEntity && AsteorBar.config.enableHealthBar()) {
            net.minecraft.client.renderer.entity.EntityRenderer<E, ?> renderer = this.getRenderer(entity);
            this.second(entity, x, y, z, p, poseStack, multiBufferSource, renderer);
        }
    }

    @Unique
    private <E extends Entity, S extends EntityRenderState> void second(E entity, double x, double y, double z, float p, PoseStack poseStack, MultiBufferSource multiBufferSource, net.minecraft.client.renderer.entity.EntityRenderer<? super E, S> renderer) {
        EntityRenderState state = renderer.createRenderState(entity, p);
        Vec3 vec3 = renderer.getRenderOffset(state);
        poseStack.pushPose();
        poseStack.translate(x + vec3.x(), y + vec3.y(), z + vec3.z());
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            EntityRenderer.render(livingEntity, poseStack, multiBufferSource);
        }
        poseStack.popPose();
    }
}

