/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.Overlays;
import com.afoxxvi.asteorbar.overlay.RenderGui;
import com.afoxxvi.asteorbar.overlay.parts.BaseOverlay;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_746;

public abstract class SimpleBarOverlay
extends BaseOverlay {
    protected long lastChangeMillis = 0L;
    private Parameters lastParameters = new Parameters();
    private Overlays.Position definedPosition = Overlays.Position.UNSPECIFIED;
    private final Map<String, BiConsumer<class_1657, Parameters>> postProcessors = new LinkedHashMap<String, BiConsumer<class_1657, Parameters>>();
    private final Map<String, Layer> layers = new LinkedHashMap<String, Layer>();
    private double lastValue = 0.0;
    private double lastFadeValue = 0.0;
    private double valueFadeFrom = 0.0;
    private double valueFadeTo = 0.0;
    private long valueFadeStartMillis = 0L;
    private long valueFadeDuration = 500L;
    private static final long VALUE_FADE_START_DELAY = 200L;
    private static final long VALUE_FADE_DURATION_MIN = 200L;
    private static final long VALUE_FADE_DURATION_MAX = 800L;
    public static final int[] SHIFT = new int[]{0, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1};

    public void applyShakeEffect(Parameters parameters, int level) {
        parameters.verticalShift = SHIFT[this.tick / (Math.max(0, level) + 1) % SHIFT.length];
    }

    protected void drawDecorations(class_332 guiGraphics, int left, int top, int right, int bottom, Parameters parameters, boolean flip) {
    }

    private void drawFadeEffect(class_332 guiGraphics, int left, int top, int right, int bottom, Parameters parameters, boolean flip) {
        long passed;
        if (!this.showFadeEffect()) {
            return;
        }
        if (parameters.value < this.lastValue) {
            this.valueFadeFrom = this.lastFadeValue;
            this.valueFadeTo = parameters.value;
            this.valueFadeStartMillis = System.currentTimeMillis();
            double valueFadeRate = Math.clamp((this.valueFadeFrom - this.valueFadeTo) / parameters.capacity, 0.0, 1.0);
            this.valueFadeDuration = (long)(200.0 + 600.0 * valueFadeRate);
        }
        this.lastValue = parameters.value;
        if (this.valueFadeTo < parameters.value) {
            this.valueFadeTo = parameters.value;
        }
        this.lastFadeValue = (passed = System.currentTimeMillis() - this.valueFadeStartMillis) < 200L ? this.valueFadeFrom : (passed < 200L + this.valueFadeDuration ? this.valueFadeFrom + (this.valueFadeTo - this.valueFadeFrom) * (double)(passed - 200L) / (double)this.valueFadeDuration : this.valueFadeTo);
        if (this.lastFadeValue <= parameters.value) {
            this.lastFadeValue = parameters.value;
            return;
        }
        int innerWidth = right - left - 2;
        int fillWidth = (int)((double)innerWidth * this.lastFadeValue / parameters.capacity);
        this.drawFillFlip(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, fillWidth, -1073741825, flip);
    }

    public void draw(class_332 guiGraphics, int left, int top, int right, int bottom, Parameters parameters, boolean flip) {
        int incrementWidth;
        if (parameters == null) {
            return;
        }
        RenderSystem.setShaderTexture((int)0, (class_2960)LIGHTMAP_TEXTURE);
        guiGraphics.method_51452();
        top += parameters.verticalShift;
        bottom += parameters.verticalShift;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)parameters.boundAlpha);
        if (parameters.boundColor2 == 0) {
            this.drawBound(guiGraphics, left, top, right, bottom, parameters.boundColor);
        } else {
            this.drawBound(guiGraphics, left, top, right, bottom, parameters.boundColor, parameters.boundColor2);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawEmptyFill(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, parameters.emptyColor);
        this.drawFadeEffect(guiGraphics, left, top, right, bottom, parameters, flip);
        int innerWidth = right - left - 2;
        int fillWidth = (int)((double)innerWidth * parameters.value / parameters.capacity);
        if (parameters.fillColor2 != 0) {
            this.drawFillFlip(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, fillWidth, parameters.fillColor, parameters.fillColor2, flip);
        } else {
            this.drawFillFlip(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, fillWidth, parameters.fillColor, flip);
        }
        int secondFillWidth = (int)((double)innerWidth * parameters.secondValue / parameters.capacity);
        int secondFillOffset = (int)((double)innerWidth * parameters.secondValueOffset);
        if (parameters.secondFillColor != 0) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)parameters.secondFillAlpha);
            this.drawFillFlip(guiGraphics, left + 1 + secondFillOffset, top + 1, right - 1, bottom - 1, secondFillWidth, parameters.secondFillColor, flip);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        int boundFillWidth = (int)((double)(right - left) * parameters.boundValue / parameters.boundCapacity);
        if (parameters.boundFillColor != 0) {
            this.drawBoundFlip(guiGraphics, left, top, right, bottom, boundFillWidth, parameters.boundFillColor, flip);
        }
        float alpha = (float)Math.cos((double)this.tick / 32.0 * 2.0 * Math.PI) * 0.5f + 0.5f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        if (parameters.valueIncrement > 0.0) {
            incrementWidth = (int)Math.round((double)innerWidth * parameters.valueIncrement);
            this.drawFillFlipConcat(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, fillWidth, incrementWidth, parameters.fillColor, flip);
        }
        if (parameters.secondValueIncrement > 0.0) {
            incrementWidth = (int)Math.round((double)innerWidth * parameters.secondValueIncrement);
            this.drawFillFlipConcat(guiGraphics, left + 1 + secondFillOffset, top + 1, right - 1, bottom - 1, secondFillWidth, incrementWidth, parameters.secondFillColor, flip);
        }
        if (parameters.boundValueIncrement > 0.0) {
            incrementWidth = (int)Math.round((double)(right - left) * parameters.boundValueIncrement);
            this.drawBoundFlipConcat(guiGraphics, left, top, right, bottom, boundFillWidth, incrementWidth, parameters.boundFillColor, flip);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int stringOffsetY = AsteorBar.config.overlayBarTextOffsetY();
        if (parameters.centerText != null) {
            Overlays.addStringRender((left + right) / 2, top + stringOffsetY, parameters.centerColor, parameters.centerText, 1, true);
        }
        if (parameters.leftText != null) {
            if (flip) {
                Overlays.addStringRender(right - 2, top + stringOffsetY, parameters.leftColor, parameters.leftText, 2, true);
            } else {
                Overlays.addStringRender(left + 2, top + stringOffsetY, parameters.leftColor, parameters.leftText, 0, true);
            }
        }
        if (parameters.rightText != null) {
            if (flip) {
                Overlays.addStringRender(left + 2, top + stringOffsetY, parameters.rightColor, parameters.rightText, 0, true);
            } else {
                Overlays.addStringRender(right - 2, top + stringOffsetY, parameters.rightColor, parameters.rightText, 2, true);
            }
        }
        if (parameters.leftOuterText != null) {
            if (flip) {
                Overlays.addStringRender(right + 2, top + stringOffsetY, parameters.leftOuterColor, parameters.leftOuterText, 0, true);
            } else {
                Overlays.addStringRender(left - 2, top + stringOffsetY, parameters.leftOuterColor, parameters.leftOuterText, 2, true);
            }
        }
        if (parameters.rightOuterText != null) {
            if (flip) {
                Overlays.addStringRender(left - 2, top + stringOffsetY, parameters.rightOuterColor, parameters.rightOuterText, 2, true);
            } else {
                Overlays.addStringRender(right + 2, top + stringOffsetY, parameters.rightOuterColor, parameters.rightOuterText, 0, true);
            }
        }
        this.drawDecorations(guiGraphics, left, top, right, bottom, parameters, flip);
    }

    protected abstract Parameters getParameters(class_1657 var1);

    protected abstract boolean shouldRender(class_1657 var1);

    protected boolean showFadeEffect() {
        return false;
    }

    public void setDefinedPosition(Overlays.Position position) {
        this.definedPosition = position;
    }

    public void addParametersProcessor(String key, BiConsumer<class_1657, Parameters> processor) {
        this.postProcessors.put(key, processor);
    }

    public void removeParametersProcessor(String key) {
        this.postProcessors.remove(key);
    }

    public void getAllParametersProcessors(Map<String, BiConsumer<class_1657, Parameters>> map) {
        map.putAll(this.postProcessors);
    }

    public void addLayer(String key, Layer layer) {
        this.layers.put(key, layer);
    }

    public void removeLayer(String key) {
        this.layers.remove(key);
    }

    public void getAllLayers(Map<String, Layer> map) {
        map.putAll(this.layers);
    }

    protected boolean isLeftSide() {
        return false;
    }

    @Deprecated
    protected boolean alwaysLow() {
        return false;
    }

    protected boolean canHide() {
        return true;
    }

    @Override
    public void renderOverlay(RenderGui gui, class_332 guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Overlays.Position position = this.definedPosition;
        if (position == null) {
            position = Overlays.Position.UNSPECIFIED;
        }
        this.renderAtPosition(gui, guiGraphics, partialTick, screenWidth, screenHeight, position);
    }

    public void renderAtPosition(RenderGui gui, class_332 guiGraphics, float partialTick, int screenWidth, int screenHeight, Overlays.Position position) {
        int top;
        int right;
        int left;
        this.tick = gui.gui().method_1738();
        if (this.overrideOverlay != null && this.overrideOverlay.shouldOverride()) {
            BaseOverlay baseOverlay = this.overrideOverlay;
            if (baseOverlay instanceof SimpleBarOverlay) {
                SimpleBarOverlay simpleBarOverlay = (SimpleBarOverlay)baseOverlay;
                simpleBarOverlay.renderAtPosition(gui, guiGraphics, partialTick, screenWidth, screenHeight, position);
            } else {
                this.overrideOverlay.render(gui, guiGraphics, partialTick, screenWidth, screenHeight);
            }
            return;
        }
        class_746 player = gui.mc().field_1724;
        if (player == null) {
            return;
        }
        if (!this.shouldRender((class_1657)player)) {
            return;
        }
        Parameters parameters = this.getParameters((class_1657)player);
        if (parameters == null) {
            return;
        }
        this.postProcessors.forEach((key, processor) -> processor.accept(player, parameters));
        boolean recoverShaderColor = false;
        if (this.canHide()) {
            int wait;
            if (!parameters.valueEquals(this.lastParameters)) {
                this.lastChangeMillis = System.currentTimeMillis();
            }
            if ((wait = AsteorBar.config.hideUnchangingBarAfterSeconds() * 1000) > 0) {
                if (System.currentTimeMillis() - this.lastChangeMillis > (long)(wait + 1000)) {
                    return;
                }
                if (System.currentTimeMillis() - this.lastChangeMillis > (long)wait) {
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - (float)(System.currentTimeMillis() - this.lastChangeMillis - (long)wait) / 1000.0f));
                    recoverShaderColor = true;
                }
            }
        }
        if (position == Overlays.Position.UNSPECIFIED) {
            switch (Overlays.style) {
                case 1: 
                case 2: {
                    position = this.isLeftSide() ? Overlays.Position.HALF_BOTTOM_LEFT : Overlays.Position.HALF_BOTTOM_RIGHT;
                    break;
                }
                case 3: {
                    position = this.isLeftSide() ? Overlays.Position.TOP_LEFT : Overlays.Position.TOP_RIGHT;
                    break;
                }
                case 4: {
                    position = this.isLeftSide() ? Overlays.Position.BOTTOM_LEFT : Overlays.Position.BOTTOM_RIGHT;
                    break;
                }
                case 5: {
                    position = Overlays.Position.TOP_LEFT;
                    break;
                }
                case 6: {
                    position = Overlays.Position.TOP_RIGHT;
                    break;
                }
                case 7: {
                    position = Overlays.Position.BOTTOM_LEFT;
                    break;
                }
                case 8: {
                    position = Overlays.Position.BOTTOM_RIGHT;
                }
            }
        }
        boolean flip = position.flip;
        int barFullHeight = AsteorBar.config.overlayBarInnerHeight() + 2;
        int shiftAfterDraw = barFullHeight + AsteorBar.config.overlayBarVerticalMargin();
        switch (position) {
            case FULL_BOTTOM: {
                left = screenWidth / 2 - 91;
                right = left + 182;
                int higher = Math.max(gui.leftHeight(), gui.rightHeight());
                top = screenHeight - higher + 9 - barFullHeight;
                gui.leftHeight((higher += shiftAfterDraw) - gui.leftHeight());
                gui.rightHeight(higher - gui.rightHeight());
                break;
            }
            case HALF_BOTTOM_LEFT: {
                left = screenWidth / 2 - 91;
                right = left + 81;
                top = screenHeight - gui.leftHeight() + 9 - barFullHeight;
                gui.leftHeight(shiftAfterDraw);
                break;
            }
            case HALF_BOTTOM_RIGHT: {
                left = screenWidth / 2 + 10;
                right = left + 81;
                top = screenHeight - gui.rightHeight() + 9 - barFullHeight;
                gui.rightHeight(shiftAfterDraw);
                break;
            }
            case TOP_LEFT: {
                top = Overlays.cornerLeftHeight;
                left = Overlays.horizontalOffset;
                right = left + Overlays.length;
                Overlays.cornerLeftHeight += shiftAfterDraw;
                break;
            }
            case TOP_RIGHT: {
                top = Overlays.cornerRightHeight;
                left = screenWidth - Overlays.length - Overlays.horizontalOffset;
                right = left + Overlays.length;
                Overlays.cornerRightHeight += shiftAfterDraw;
                break;
            }
            case BOTTOM_LEFT: {
                top = screenHeight - Overlays.cornerLeftHeight;
                left = Overlays.horizontalOffset;
                right = left + Overlays.length;
                Overlays.cornerLeftHeight += shiftAfterDraw;
                break;
            }
            case BOTTOM_RIGHT: {
                top = screenHeight - Overlays.cornerRightHeight;
                left = screenWidth - Overlays.length - Overlays.horizontalOffset;
                right = left + Overlays.length;
                Overlays.cornerRightHeight += shiftAfterDraw;
                break;
            }
            default: {
                return;
            }
        }
        this.draw(guiGraphics, left, top, right, top + barFullHeight, parameters, flip);
        this.layers.forEach((key, layer) -> layer.drawLayer((class_1657)player, guiGraphics, left, top, right, top + barFullHeight, parameters, flip));
        this.lastParameters = parameters;
        if (recoverShaderColor) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static class Parameters {
        public int fillColor = 0;
        public int fillColor2 = 0;
        public int secondFillColor = 0;
        public float secondFillAlpha = 1.0f;
        public int boundColor = 0;
        public float boundAlpha = 1.0f;
        public int boundColor2 = 0;
        public int emptyColor = 0;
        public double value = 0.0;
        public double valueIncrement = 0.0;
        public double secondValueOffset = 0.0;
        public double secondValue = 0.0;
        public double secondValueIncrement = 0.0;
        public double capacity = 1.0;
        public int boundFillColor = 0;
        public double boundValue = 0.0;
        public double boundValueIncrement = 0.0;
        public double boundCapacity = 1.0;
        public String centerText = null;
        public String leftText = null;
        public String rightText = null;
        public String leftOuterText = null;
        public String rightOuterText = null;
        public int centerColor = 0;
        public int leftColor = 0;
        public int rightColor = 0;
        public int leftOuterColor = 0;
        public int rightOuterColor = 0;
        public int verticalShift = 0;

        public boolean valueEquals(Parameters other) {
            return this.value == other.value && this.capacity == other.capacity && this.boundValue == other.boundValue && this.boundCapacity == other.boundCapacity && Objects.equals(this.centerText, other.centerText) && Objects.equals(this.leftText, other.leftText) && Objects.equals(this.rightText, other.rightText);
        }
    }

    public static interface Layer {
        public void drawLayer(class_1657 var1, class_332 var2, int var3, int var4, int var5, int var6, Parameters var7, boolean var8);
    }
}

