/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.RenderGui;
import com.afoxxvi.asteorbar.overlay.parts.FoodLevelOverlay;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.afoxxvi.asteorbar.utils.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import toughasnails.api.potion.TANEffects;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;
import toughasnails.init.ModConfig;
import toughasnails.temperature.TemperatureOverlayRenderer;

public class ToughAsNailsOverlay
extends SimpleBarOverlay {
    private int thirstBlinkTime = 0;
    private float exhaustion;

    @Override
    protected SimpleBarOverlay.Parameters getParameters(class_1657 player) {
        SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
        IThirst thirst = ThirstHelper.getThirst((class_1657)player);
        int level = thirst.getThirst();
        float hydration = thirst.getHydration();
        this.exhaustion = thirst.getExhaustion();
        int thirstColor = -14917916;
        if (player.method_6059(TANEffects.THIRST)) {
            thirstColor = -8987828;
        }
        if (level <= 4) {
            parameters.verticalShift = FoodLevelOverlay.SHIFT[this.tick / (level + 1) % FoodLevelOverlay.SHIFT.length];
        }
        if (AsteorBar.config.enableFoodBlink()) {
            if (hydration <= 0.0f && (long)this.tick % ((long)Math.max(4, level) * 3L + 1L) == 0L) {
                this.thirstBlinkTime = 2;
            }
            if (this.thirstBlinkTime > 0) {
                --this.thirstBlinkTime;
            }
        }
        boolean highlight = this.thirstBlinkTime > 0;
        parameters.boundColor = highlight ? Utils.mixColor(-1, thirstColor, 0.2) : Utils.mixColor(-16777216, thirstColor, 0.5);
        parameters.emptyColor = AsteorBar.config.foodEmptyColor();
        parameters.fillColor = thirstColor;
        parameters.capacity = 20.0;
        parameters.value = level;
        if (AsteorBar.config.displaySaturation()) {
            parameters.boundFillColor = -13802026;
            parameters.boundValue = hydration;
            parameters.boundCapacity = 10.0;
        }
        if (AsteorBar.config.displayFoodText()) {
            parameters.centerText = Utils.formatNumber(level) + "/" + Utils.formatNumber(20.0);
            parameters.centerColor = 0xFFFFFF;
        }
        return parameters;
    }

    @Override
    protected boolean shouldRender(class_1657 player) {
        return AsteorBar.compatibility.toughAsNails && AsteorBar.config.hookToughAsNails() && ThirstHelper.isThirstEnabled();
    }

    @Override
    protected void drawDecorations(class_332 guiGraphics, int left, int top, int right, int bottom, SimpleBarOverlay.Parameters parameters, boolean flip) {
        super.drawDecorations(guiGraphics, left, top, right, bottom, parameters, flip);
        int innerWidth = right - left - 2;
        if (AsteorBar.config.displayExhaustion()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            double cap = ModConfig.thirst.thirstExhaustionThreshold;
            int exhaustionWidth = (int)((double)innerWidth * (Math.min(cap, (double)this.exhaustion) / cap));
            this.drawTextureFillFlip(guiGraphics, left + 1, top, right - 1, exhaustionWidth, 5, 10, 9, 180, flip);
            RenderSystem.setShaderTexture((int)0, (class_2960)LIGHTMAP_TEXTURE);
        }
    }

    @Override
    public void renderOverlay(RenderGui gui, class_332 guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        if (!AsteorBar.compatibility.toughAsNails || !AsteorBar.config.hookToughAsNails()) {
            return;
        }
        TemperatureOverlayRenderer.renderTemperature((class_332)guiGraphics, (float)partialTick, (int)screenWidth, (int)screenHeight);
        super.renderOverlay(gui, guiGraphics, partialTick, screenWidth, screenHeight);
    }
}

