/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class GuiHelper {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"asteorbar", (String)"textures/gui/overlay.png");
    public static final ResourceLocation LIGHTMAP_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"asteorbar", (String)"textures/ui/lightmap.png");
    public static final int LIGHT = 0xFF00FF;
    private static float globalAlpha = 1.0f;

    public static void setGlobalAlpha(float alpha) {
        globalAlpha = Math.clamp(alpha, 0.0f, 1.0f);
    }

    private static int applyAlpha(int color) {
        if (globalAlpha >= 0.999f) {
            return color;
        }
        int alpha = color >>> 24 & 0xFF;
        alpha = (int)((float)alpha * globalAlpha);
        return color & 0xFFFFFF | alpha << 24;
    }

    public static void drawTexturedRect(GuiGraphics guiGraphics, int left, int top, int textureX, int textureY, int width, int height) {
        GuiHelper.drawTexturedRect(guiGraphics, left, top, left + width, top + height, textureX, textureY, (float)textureX + (float)width, (float)textureY + (float)height, 256, 256);
    }

    public static void drawTexturedRectColor(GuiGraphics guiGraphics, int left, int top, int textureX, int textureY, int width, int height, int color) {
        GuiHelper.drawTexturedRectColor(guiGraphics, left, top, left + width, top + height, textureX, textureY, (float)textureX + (float)width, (float)textureY + (float)height, 256, 256, color);
    }

    public static void drawTexturedRect(GuiGraphics guiGraphics, int left, int top, int right, int bottom, float uvLeft, float uvTop, float uvRight, float uvBottom, int textureWidth, int textureHeight) {
        GuiHelper.drawTexturedRectColor(guiGraphics, left, top, right, bottom, uvLeft, uvTop, uvRight, uvBottom, textureWidth, textureHeight, -1);
    }

    public static void drawTexturedRectColor(GuiGraphics guiGraphics, int left, int top, int right, int bottom, float uvLeft, float uvTop, float uvRight, float uvBottom, int textureWidth, int textureHeight, int color) {
        color = GuiHelper.applyAlpha(color);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, left, top, uvLeft, uvTop, right - left, bottom - top, (int)(uvRight - uvLeft), (int)(uvBottom - uvTop), textureWidth, textureHeight, color);
    }

    public static void drawLightmapRectColor(GuiGraphics guiGraphics, int left, int top, int right, int bottom, float uvLeft, float uvTop, float uvRight, float uvBottom, int color) {
        color = GuiHelper.applyAlpha(color);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, LIGHTMAP_TEXTURE, left, top, uvLeft, uvTop, right - left, bottom - top, (int)(uvRight - uvLeft), (int)(uvBottom - uvTop), 32, 32, color);
    }

    public static void drawSolidColor(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int color) {
        color = GuiHelper.applyAlpha(color);
        guiGraphics.fill(left, top, right, bottom, color);
    }

    public static void drawString(GuiGraphics guiGraphics, String string, int left, int top, int color) {
        color = GuiHelper.applyAlpha(color);
        GuiHelper.drawString(guiGraphics, string, left, top, color, true);
    }

    public static void drawString(GuiGraphics guiGraphics, String string, int left, int top, int color, boolean shadow) {
        color = GuiHelper.applyAlpha(color);
        guiGraphics.drawString(Minecraft.getInstance().font, string, left, top, color, shadow);
    }

    public static void drawSolidGradient(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int color) {
        GuiHelper.drawLightmapRectColor(guiGraphics, left, top, right, bottom, 0.0f, 20.0f, 32.0f, 32.0f, color);
    }

    public static void drawSolidGradientUpDown(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int color) {
        GuiHelper.drawLightmapRectColor(guiGraphics, left, top, right, bottom, 0.0f, 0.0f, 32.0f, 12.0f, color);
    }

    public static void renderBound(VertexConsumer vertexConsumer, PoseStack poseStack, int left, int top, int right, int bottom, int width, int boundWidth, int colorFill, int colorEmpty, boolean vertex, float z) {
        int part;
        int expand;
        colorFill = GuiHelper.applyAlpha(colorFill);
        colorEmpty = GuiHelper.applyAlpha(colorEmpty);
        int cut = 0;
        int n = expand = vertex ? boundWidth : 0;
        if (width > 0) {
            part = Math.min(width, boundWidth);
            cut += part;
            GuiHelper.renderSolid(vertexConsumer, poseStack, left - boundWidth, top - expand, left - boundWidth + part, bottom + expand, colorFill, z);
            if (part < boundWidth) {
                GuiHelper.renderSolid(vertexConsumer, poseStack, left - boundWidth + part, top - expand, left, bottom + expand, colorEmpty, z);
            }
        } else {
            GuiHelper.renderSolid(vertexConsumer, poseStack, left - boundWidth, top - expand, left, bottom + expand, colorEmpty, z);
        }
        if (width > right - left + boundWidth) {
            part = Math.min(width, boundWidth);
            cut += part;
            GuiHelper.renderSolid(vertexConsumer, poseStack, right, top - expand, right + part, bottom + expand, colorFill, z);
            if (part < boundWidth) {
                GuiHelper.renderSolid(vertexConsumer, poseStack, right + part, top - expand, right + boundWidth, bottom + expand, colorEmpty, z);
            }
        } else {
            GuiHelper.renderSolid(vertexConsumer, poseStack, right, top - expand, right + boundWidth, bottom + expand, colorEmpty, z);
        }
        if ((width -= cut) > 0) {
            GuiHelper.renderSolid(vertexConsumer, poseStack, left, top - boundWidth, left + width, top, colorFill, z);
            GuiHelper.renderSolid(vertexConsumer, poseStack, left, bottom, left + width, bottom + boundWidth, colorFill, z);
        }
        if (width < right - left) {
            GuiHelper.renderSolid(vertexConsumer, poseStack, left + width, top - boundWidth, right, top, colorEmpty, z);
            GuiHelper.renderSolid(vertexConsumer, poseStack, left + width, bottom, right, bottom + boundWidth, colorEmpty, z);
        }
    }

    public static void renderSolid(VertexConsumer vertexConsumer, PoseStack poseStack, int left, int top, int right, int bottom, int color, float z) {
        color = GuiHelper.applyAlpha(color);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)left, (float)top, z).setColor(color).setUv(0.0f, 0.0f).setLight(0xFF00FF).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)left, (float)bottom, z).setColor(color).setUv(0.0f, 0.125f).setLight(0xFF00FF).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)right, (float)bottom, z).setColor(color).setUv(1.0f, 0.125f).setLight(0xFF00FF).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)right, (float)top, z).setColor(color).setUv(1.0f, 0.0f).setLight(0xFF00FF).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
    }

    public static void renderSolidGradient(VertexConsumer vertexConsumer, PoseStack poseStack, int left, int top, int right, int bottom, int color, float z) {
        color = GuiHelper.applyAlpha(color);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)left, (float)top, z).setColor(color).setUv(0.0f, 0.625f).setLight(0xFF00FF).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)left, (float)bottom, z).setColor(color).setUv(0.0f, 1.0f).setLight(0xFF00FF).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)right, (float)bottom, z).setColor(color).setUv(1.0f, 1.0f).setLight(0xFF00FF).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)right, (float)top, z).setColor(color).setUv(1.0f, 0.625f).setLight(0xFF00FF).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
    }

    public static void renderSolidGradientUpDown(VertexConsumer vertexConsumer, PoseStack poseStack, int left, int top, int right, int bottom, int color, float z) {
        color = GuiHelper.applyAlpha(color);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)left, (float)top, z).setColor(color).setUv(0.0f, 0.0f).setLight(0xFF00FF).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)left, (float)bottom, z).setColor(color).setUv(0.0f, 0.375f).setLight(0xFF00FF).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)right, (float)bottom, z).setColor(color).setUv(1.0f, 0.375f).setLight(0xFF00FF).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
        vertexConsumer.addVertex(poseStack.last().pose(), (float)right, (float)top, z).setColor(color).setUv(1.0f, 0.0f).setLight(0xFF00FF).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(poseStack.last(), 0.0f, 0.0f, 0.0f);
    }

    public static void renderString(PoseStack poseStack, MultiBufferSource buffer, String string, float left, float top, int color, boolean shadow) {
        color = GuiHelper.applyAlpha(color);
        Minecraft.getInstance().font.drawInBatch(string, left, top, color, shadow, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void renderString(PoseStack poseStack, MultiBufferSource buffer, String string, int left, int top, int color) {
        GuiHelper.renderString(poseStack, buffer, string, left, top, color, false);
    }

    public static void renderCenteredString(PoseStack poseStack, MultiBufferSource buffer, String string, int left, int top, int color) {
        GuiHelper.renderString(poseStack, buffer, string, (float)left - (float)Minecraft.getInstance().font.width(string) / 2.0f, top, color, false);
    }

    public static void renderStringShadow(PoseStack poseStack, MultiBufferSource buffer, String string, int left, int top, int color) {
        GuiHelper.renderString(poseStack, buffer, string, left, top, color, true);
    }

    public static void renderCenteredStringShadow(PoseStack poseStack, MultiBufferSource buffer, String string, int left, int top, int color) {
        GuiHelper.renderString(poseStack, buffer, string, (float)left - (float)Minecraft.getInstance().font.width(string) / 2.0f, top, color, true);
    }
}

