/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.network;

import com.afoxxvi.asteorbar.AsteorBar;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.dehydration.access.ThirstManagerAccess;
import net.dehydration.thirst.ThirstManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1702;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class NetworkHandler {
    private static final class_2960 CHANNEL = new class_2960("asteorbar", "network");
    private static final int INDEX_EXHAUSTION = 0;
    private static final int INDEX_SATURATION = 1;
    private static final int INDEX_ABSORPTION = 2;
    private static final int INDEX_ACTIVATE = 3;
    private static final int INDEX_DEHYDRATION = 65;
    private static final Map<UUID, Float> EXHAUSTION = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> SATURATION = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> DEHYDRATION = new HashMap<UUID, Float>();

    @Environment(value=EnvType.CLIENT)
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)CHANNEL, (client, handler, buf, responseSender) -> {
            byte index = buf.readByte();
            switch (index) {
                case 0: {
                    float exhaustion = buf.readFloat();
                    client.execute(() -> {
                        if (client.field_1724 != null) {
                            client.field_1724.method_7344().method_35218(exhaustion);
                        }
                    });
                    break;
                }
                case 1: {
                    float saturation = buf.readFloat();
                    client.execute(() -> {
                        if (client.field_1724 != null) {
                            client.field_1724.method_7344().method_7581(saturation);
                        }
                    });
                    break;
                }
                case 2: {
                    int entityId = buf.readInt();
                    float absorption = buf.readFloat();
                    client.execute(() -> {
                        class_1297 entity;
                        if (client.field_1687 != null && (entity = client.field_1687.method_8469(entityId)) instanceof class_1309) {
                            class_1309 livingEntity = (class_1309)entity;
                            livingEntity.method_6073(absorption);
                        }
                    });
                    break;
                }
                case 3: {
                    boolean activate = buf.readBoolean();
                    client.execute(() -> {
                        ByteBuf buffer = Unpooled.buffer((int)1).writeBoolean(activate);
                        ClientPlayNetworking.send((class_2960)CHANNEL, (class_2540)new class_2540(buffer));
                    });
                    break;
                }
                case 65: {
                    float dehydration = buf.readFloat();
                    client.execute(() -> {
                        ThirstManager thirstManager;
                        if (client.field_1724 != null && AsteorBar.compatibility.dehydration && (thirstManager = ((ThirstManagerAccess)client.field_1724).getThirstManager()) != null) {
                            thirstManager.dehydration = dehydration;
                        }
                    });
                }
            }
        });
    }

    public static void onPlayerTick(class_3222 player) {
        ThirstManager thirstManager;
        class_1702 foodStats = player.method_7344();
        float exhaustionLevel = foodStats.method_35219();
        Float oldExhaustion = EXHAUSTION.get(player.method_5667());
        if (oldExhaustion == null || Math.abs(oldExhaustion.floatValue() - exhaustionLevel) >= 0.01f) {
            EXHAUSTION.put(player.method_5667(), Float.valueOf(exhaustionLevel));
            ByteBuf buf = PacketByteBufs.create().writeByte(0).writeFloat(exhaustionLevel);
            class_2596 packet = ServerPlayNetworking.createS2CPacket((class_2960)CHANNEL, (class_2540)PacketByteBufs.duplicate((ByteBuf)buf));
            player.field_13987.method_14364(packet);
        }
        float saturationLevel = foodStats.method_7589();
        Float oldSaturation = SATURATION.get(player.method_5667());
        if (oldSaturation == null || Math.abs(oldSaturation.floatValue() - saturationLevel) >= 0.01f) {
            SATURATION.put(player.method_5667(), Float.valueOf(saturationLevel));
            ByteBuf buf = PacketByteBufs.create().writeByte(1).writeFloat(saturationLevel);
            class_2596 packet = ServerPlayNetworking.createS2CPacket((class_2960)CHANNEL, (class_2540)PacketByteBufs.duplicate((ByteBuf)buf));
            player.field_13987.method_14364(packet);
        }
        if (AsteorBar.compatibility.dehydration && (thirstManager = ((ThirstManagerAccess)player).getThirstManager()) != null && thirstManager.hasThirst()) {
            float dehydration = thirstManager.dehydration;
            Float oldDehydration = DEHYDRATION.get(player.method_5667());
            if (oldDehydration == null || Math.abs(oldDehydration.floatValue() - dehydration) >= 0.01f) {
                DEHYDRATION.put(player.method_5667(), Float.valueOf(dehydration));
                ByteBuf buf = PacketByteBufs.create().writeByte(65).writeFloat(dehydration);
                class_2596 packet = ServerPlayNetworking.createS2CPacket((class_2960)CHANNEL, (class_2540)PacketByteBufs.duplicate((ByteBuf)buf));
                player.field_13987.method_14364(packet);
            }
        }
    }

    public static class_2596<class_2602> createAbsorptionPacket(int entityId, float absorption) {
        ByteBuf buf = PacketByteBufs.create().writeByte(2).writeInt(entityId).writeFloat(absorption);
        return ServerPlayNetworking.createS2CPacket((class_2960)CHANNEL, (class_2540)PacketByteBufs.duplicate((ByteBuf)buf));
    }
}

