/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.afoxxvi.asteorbar.utils.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class FoodLevelOverlay
extends SimpleBarOverlay {
    private int foodBlinkTime = 0;
    float saturation;
    float exhaustion;

    @Override
    protected SimpleBarOverlay.Parameters getParameters(class_1657 player) {
        class_1702 stats = player.method_7344();
        int level = stats.method_7586();
        this.saturation = stats.method_7589();
        this.exhaustion = stats.method_35219();
        int foodType = AsteorBar.config.foodColorNormal();
        if (player.method_6059(class_1294.field_5903)) {
            foodType = AsteorBar.config.foodColorHunger();
        }
        if (AsteorBar.config.enableFoodBlink()) {
            if (player.method_7344().method_7589() <= 0.0f && (long)this.tick % ((long)Math.max(4, level) * 3L + 1L) == 0L) {
                this.foodBlinkTime = 2;
            }
            if (this.foodBlinkTime > 0) {
                --this.foodBlinkTime;
            }
        }
        SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
        if (level <= 4) {
            this.applyShakeEffect(parameters, level);
        }
        parameters.boundColor = this.foodBlinkTime > 0 ? AsteorBar.config.foodBoundColorBlink() : AsteorBar.config.foodBoundColor();
        parameters.emptyColor = AsteorBar.config.foodEmptyColor();
        if (AsteorBar.config.displayFoodText()) {
            parameters.centerText = Utils.formatNumber(level) + "/" + Utils.formatNumber(AsteorBar.config.fullFoodLevelValue());
            parameters.centerColor = 0xFFFFFF;
        }
        parameters.value = (double)level / (double)AsteorBar.config.fullFoodLevelValue();
        parameters.fillColor = foodType;
        if (AsteorBar.config.displaySaturation()) {
            parameters.boundValue = (double)this.saturation / AsteorBar.config.fullSaturationValue();
            parameters.boundFillColor = AsteorBar.config.saturationColor();
        }
        return parameters;
    }

    @Override
    protected void drawDecorations(class_332 guiGraphics, int left, int top, int right, int bottom, SimpleBarOverlay.Parameters parameters, boolean flip) {
        super.drawDecorations(guiGraphics, left, top, right, bottom, parameters, flip);
        int innerWidth = right - left - 2;
        if (AsteorBar.config.displayExhaustion()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
            int exhaustionWidth = (int)((double)innerWidth * (Math.min(AsteorBar.config.fullExhaustionValue(), (double)this.exhaustion) / AsteorBar.config.fullExhaustionValue()));
            this.drawTextureFillFlip(guiGraphics, left + 1, top, right - 1, exhaustionWidth, 5, 10, 9, 180, flip);
            RenderSystem.setShaderTexture((int)0, (class_2960)LIGHTMAP_TEXTURE);
        }
    }

    @Override
    protected boolean shouldRender(class_1657 player) {
        return true;
    }
}

