/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import io.github.foundationgames.mealapi.MealAPI;
import io.github.foundationgames.mealapi.config.MealAPIConfig;
import io.github.foundationgames.mealapi.impl.MealItemRegistryImpl;
import io.github.foundationgames.mealapi.impl.PlayerFullnessUtilImpl;
import io.github.foundationgames.mealapi.util.MAUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_332;

public class MealAPIOverlay
implements SimpleBarOverlay.Layer {
    private static final Bar BAR = new Bar();

    @Override
    public void drawLayer(class_1657 player, class_332 guiGraphics, int left, int top, int right, int bottom, SimpleBarOverlay.Parameters parameters, boolean flip) {
        SimpleBarOverlay.Parameters params = BAR.getParameters(player);
        BAR.draw(guiGraphics, left, top, right, bottom, params, flip);
    }

    private static class Bar
    extends SimpleBarOverlay {
        private Bar() {
        }

        @Override
        protected SimpleBarOverlay.Parameters getParameters(class_1657 player) {
            boolean border;
            SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
            MealAPIConfig cfg = MealAPI.getConfig();
            float opacity = (float)cfg.getValues().fullnessBarOpacityPct / 100.0f;
            int fullness = PlayerFullnessUtilImpl.INSTANCE.getClientFullness();
            int maxFullness = PlayerFullnessUtilImpl.INSTANCE.getMaxFullness();
            parameters.value = fullness;
            parameters.capacity = maxFullness;
            boolean poisoned = player.method_6059(class_1294.field_5903);
            parameters.fillColor = poisoned ? -7034032 : -591726;
            parameters.fillColor = (int)(opacity * 255.0f) << 24 | parameters.fillColor & 0xFFFFFF;
            boolean bl = border = cfg.getValues().fullnessIconBorders == MealAPIConfig.DefaultedYesNo.YES || cfg.getValues().fullnessIconBorders == MealAPIConfig.DefaultedYesNo.DEFAULT && !MAUtil.appleSkin();
            if (cfg.getValues().showFlashingFullnessPreview == MealAPIConfig.DefaultedYesNo.YES || cfg.getValues().showFlashingFullnessPreview == MealAPIConfig.DefaultedYesNo.DEFAULT && MAUtil.appleSkin()) {
                class_1799 previewStack = player.method_5998(class_1268.field_5808);
                if (MealItemRegistryImpl.INSTANCE.getFullness(player, player.method_5998(class_1268.field_5808)) <= 0) {
                    previewStack = player.method_5998(class_1268.field_5810);
                }
                if (MealItemRegistryImpl.INSTANCE.getFullness(player, previewStack) > 0) {
                    int potentialFull = Math.min(fullness + PlayerFullnessUtilImpl.INSTANCE.getHealedFullness(player, previewStack), PlayerFullnessUtilImpl.INSTANCE.getMaxFullness());
                    parameters.valueIncrement = potentialFull - fullness;
                }
            }
            if (border) {
                parameters.boundFillColor = poisoned ? -12044017 : -5086191;
                parameters.boundFillColor = (int)(opacity * 255.0f) << 24 | parameters.boundFillColor & 0xFFFFFF;
                parameters.boundValue = fullness;
                parameters.boundCapacity = maxFullness;
                parameters.boundValueIncrement = parameters.valueIncrement;
            }
            return parameters;
        }

        @Override
        protected boolean shouldRender(class_1657 player) {
            return AsteorBar.compatibility.mealApi && AsteorBar.config.hookMealApi();
        }
    }
}

