/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.network;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.AsteorBarNeoForge;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import org.jetbrains.annotations.NotNull;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;

public class NetworkHandler {
    private static boolean initialized = false;
    private static final Map<UUID, Float> EXHAUSTION = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> SATURATION = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> TOUGH_AS_NAILS_HYDRATION = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> TOUGH_AS_NAILS_EXHAUSTION = new HashMap<UUID, Float>();

    @SubscribeEvent
    public static void register(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("asteorbar").optional();
        registrar.play(ActivatePacket.ID, ActivatePacket::new, ActivatePacket::handle);
        registrar.play(SaturationPacket.ID, SaturationPacket::new, SaturationPacket::handle);
        registrar.play(ExhaustionPacket.ID, ExhaustionPacket::new, ExhaustionPacket::handle);
        registrar.play(EntityAbsorptionPacket.ID, EntityAbsorptionPacket::new, EntityAbsorptionPacket::handle);
        registrar.play(ToughAsNailsPacket.ID, ToughAsNailsPacket::new, ToughAsNailsPacket::handle);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            FoodData foodStats = player2.getFoodData();
            float exhaustionLevel = foodStats.getExhaustionLevel();
            Float oldExhaustion = EXHAUSTION.get(player2.getUUID());
            if (oldExhaustion == null || Math.abs(oldExhaustion.floatValue() - exhaustionLevel) >= 0.01f) {
                EXHAUSTION.put(player2.getUUID(), Float.valueOf(exhaustionLevel));
                PacketDistributor.PLAYER.with((Object)player2).send(new CustomPacketPayload[]{new ExhaustionPacket(exhaustionLevel)});
            }
            float saturationLevel = foodStats.getSaturationLevel();
            Float oldSaturation = SATURATION.get(player2.getUUID());
            if (oldSaturation == null || Math.abs(oldSaturation.floatValue() - saturationLevel) >= 0.01f) {
                SATURATION.put(player2.getUUID(), Float.valueOf(saturationLevel));
                PacketDistributor.PLAYER.with((Object)player2).send(new CustomPacketPayload[]{new SaturationPacket(saturationLevel)});
            }
            if (!initialized) {
                initialized = true;
                AsteorBar.compatibility.init();
            }
            if (AsteorBar.compatibility.toughAsNails) {
                IThirst thirst = ThirstHelper.getThirst((Player)player2);
                boolean send = false;
                float hydration = thirst.getHydration();
                Float oldHydration = TOUGH_AS_NAILS_HYDRATION.get(player2.getUUID());
                if (oldHydration == null || Math.abs(oldHydration.floatValue() - hydration) >= 0.01f) {
                    TOUGH_AS_NAILS_HYDRATION.put(player2.getUUID(), Float.valueOf(hydration));
                    send = true;
                }
                float exhaustion = thirst.getExhaustion();
                Float oldToughAsNailsExhaustion = TOUGH_AS_NAILS_EXHAUSTION.get(player2.getUUID());
                if (oldToughAsNailsExhaustion == null || Math.abs(oldToughAsNailsExhaustion.floatValue() - exhaustion) >= 0.01f) {
                    TOUGH_AS_NAILS_EXHAUSTION.put(player2.getUUID(), Float.valueOf(exhaustion));
                    send = true;
                }
                if (send) {
                    PacketDistributor.PLAYER.with((Object)player2).send(new CustomPacketPayload[]{new ToughAsNailsPacket(hydration, exhaustion)});
                }
            }
        }
    }

    private static Player getPlayer(PlayPayloadContext context) {
        return (Player)context.player().orElse(Minecraft.getInstance().player);
    }

    public static class ActivatePacket
    implements CustomPacketPayload {
        public static final ResourceLocation ID = new ResourceLocation("asteorbar", "activate");
        public boolean activate;

        public ActivatePacket(boolean activate) {
            this.activate = activate;
        }

        public ActivatePacket(FriendlyByteBuf buffer) {
            this.activate = buffer.readBoolean();
        }

        public static void handle(ActivatePacket packet, PlayPayloadContext context) {
            context.workHandler().submitAsync(() -> {
                AsteorBarNeoForge.LOGGER.info("Received activate packet. Sending back to server.");
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new ActivatePacket(true)});
            });
        }

        public void write(FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeBoolean(this.activate);
        }

        @NotNull
        public ResourceLocation id() {
            return ID;
        }
    }

    public static class SaturationPacket
    implements CustomPacketPayload {
        public static final ResourceLocation ID = new ResourceLocation("asteorbar", "saturation");
        public float saturation;

        public SaturationPacket(float saturation) {
            this.saturation = saturation;
        }

        public SaturationPacket(FriendlyByteBuf buffer) {
            this.saturation = buffer.readFloat();
        }

        public static void handle(SaturationPacket packet, PlayPayloadContext context) {
            context.workHandler().submitAsync(() -> {
                Player player = NetworkHandler.getPlayer(context);
                if (player != null) {
                    FoodData foodStats = player.getFoodData();
                    foodStats.setSaturation(packet.saturation);
                }
            });
        }

        public void write(FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeFloat(this.saturation);
        }

        @NotNull
        public ResourceLocation id() {
            return ID;
        }
    }

    public static class ExhaustionPacket
    implements CustomPacketPayload {
        public static final ResourceLocation ID = new ResourceLocation("asteorbar", "exhaustion");
        public float exhaustion;

        public ExhaustionPacket(float exhaustion) {
            this.exhaustion = exhaustion;
        }

        public ExhaustionPacket(FriendlyByteBuf buffer) {
            this.exhaustion = buffer.readFloat();
        }

        public static void handle(ExhaustionPacket packet, PlayPayloadContext context) {
            context.workHandler().submitAsync(() -> {
                Player player = NetworkHandler.getPlayer(context);
                if (player != null) {
                    FoodData foodStats = player.getFoodData();
                    foodStats.setExhaustion(packet.exhaustion);
                }
            });
        }

        public void write(FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeFloat(this.exhaustion);
        }

        @NotNull
        public ResourceLocation id() {
            return ID;
        }
    }

    public static class EntityAbsorptionPacket
    implements CustomPacketPayload {
        public static final ResourceLocation ID = new ResourceLocation("asteorbar", "entity_absorption");
        public int entityId;
        public float absorption;

        public EntityAbsorptionPacket(int entityId, float absorption) {
            this.entityId = entityId;
            this.absorption = absorption;
        }

        public EntityAbsorptionPacket(FriendlyByteBuf buffer) {
            this.entityId = buffer.readInt();
            this.absorption = buffer.readFloat();
        }

        public static void handle(EntityAbsorptionPacket packet, PlayPayloadContext context) {
            context.workHandler().submitAsync(() -> {
                Entity entity;
                Player player = NetworkHandler.getPlayer(context);
                if (player != null && (entity = player.level().getEntity(packet.entityId)) instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.setAbsorptionAmount(packet.absorption);
                }
            });
        }

        public void write(FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeInt(this.entityId);
            friendlyByteBuf.writeFloat(this.absorption);
        }

        @NotNull
        public ResourceLocation id() {
            return ID;
        }
    }

    public static class ToughAsNailsPacket
    implements CustomPacketPayload {
        public static final ResourceLocation ID = new ResourceLocation("asteorbar", "tough_as_nails");
        public float hydration;
        public float exhaustion;

        public ToughAsNailsPacket(float hydration, float exhaustion) {
            this.hydration = hydration;
            this.exhaustion = exhaustion;
        }

        public ToughAsNailsPacket(FriendlyByteBuf buffer) {
            this.hydration = buffer.readFloat();
            this.exhaustion = buffer.readFloat();
        }

        public static void handle(ToughAsNailsPacket packet, PlayPayloadContext context) {
            context.workHandler().submitAsync(() -> {
                Player player = NetworkHandler.getPlayer(context);
                if (player != null) {
                    IThirst thirst = ThirstHelper.getThirst((Player)player);
                    thirst.setHydration(packet.hydration);
                    thirst.setExhaustion(packet.exhaustion);
                }
            });
        }

        public void write(FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeFloat(this.hydration);
            friendlyByteBuf.writeFloat(this.exhaustion);
        }

        @NotNull
        public ResourceLocation id() {
            return ID;
        }
    }
}

