/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.utils;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.AsteorBarNeoForge;
import com.afoxxvi.asteorbar.entity.AsteorBarRenderType;
import com.afoxxvi.asteorbar.mixin.FoodDataMixin;
import com.afoxxvi.asteorbar.utils.AppleSkinAdapter;
import com.afoxxvi.asteorbar.utils.PlatformAdapter;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidType;
import org.slf4j.Logger;

public class NeoForgePlatformAdapter
implements PlatformAdapter {
    @Override
    public Logger getLogger() {
        return AsteorBarNeoForge.LOGGER;
    }

    @Override
    public boolean isBoss(LivingEntity livingEntity) {
        return livingEntity.getType().is(Tags.EntityTypes.BOSSES);
    }

    @Override
    public boolean isEyeInFluid(Player player) {
        return player.isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value());
    }

    @Override
    public RenderType getRenderType() {
        return AsteorBarRenderType.RENDER_TYPE;
    }

    @Override
    public boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Override
    public PlatformAdapter.AppleSkinFoodValues getAppleSkinFoodValues(Player player) {
        if (!AsteorBar.compatibility.appleskin) {
            return null;
        }
        return AppleSkinAdapter.getInstance().getAppleSkinFoodValues(player);
    }

    @Override
    public float getExhaustion(Player player) {
        return ((FoodDataMixin)player.getFoodData()).getExhaustionLevel();
    }

    @Override
    public void setExhaustion(Player player, float exhaustion) {
        ((FoodDataMixin)player.getFoodData()).setExhaustionLevel(exhaustion);
    }
}

