/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.entity;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.utils.GuiHelper;
import com.afoxxvi.asteorbar.utils.Utils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class EntityRenderer {
    public static final List<ExtraRenderer> EXTRA_RENDERERS = new ArrayList<ExtraRenderer>();
    public static final List<ExtraTextRenderer> EXTRA_TEXT_RENDERERS = new ArrayList<ExtraTextRenderer>();

    public static void extraRender(LivingEntity entity, PoseStack poseStack, MultiBufferSource multiBufferSource, float halfWidth, float halfHeight, float boundWidth) {
        EXTRA_RENDERERS.forEach(extraRenderer -> extraRenderer.render(entity, poseStack, multiBufferSource, halfWidth, halfHeight, boundWidth));
    }

    public static void extraTextRender(LivingEntity entity, PoseStack poseStack, MultiBufferSource multiBufferSource, float halfWidth, float halfHeight, float boundWidth, float textScale) {
        EXTRA_TEXT_RENDERERS.forEach(extraTextRenderer -> extraTextRenderer.render(entity, poseStack, multiBufferSource, halfWidth, halfHeight, boundWidth, textScale));
    }

    private static int check(LivingEntity entity, Player player) {
        if (entity.isInvisible()) {
            return 1;
        }
        if ((double)entity.distanceTo((Entity)player) > AsteorBar.config.maxDistance()) {
            return 2;
        }
        if (entity.isInvisibleTo(player)) {
            return 3;
        }
        if (entity.isSpectator()) {
            return 4;
        }
        if (!AsteorBar.config.showOnSelf() && entity == player) {
            return 5;
        }
        if (!AsteorBar.config.showOnPlayers() && entity instanceof Player) {
            return 6;
        }
        if (!AsteorBar.config.showOnBosses() && AsteorBar.platformAdapter.isBoss(entity)) {
            return 7;
        }
        if (!AsteorBar.config.showOnArmorStands() && entity instanceof ArmorStand) {
            return 11;
        }
        if (entity.getMaxHealth() == entity.getHealth()) {
            if (!AsteorBar.config.showOnFullHealthWithAbsorption() && entity.getAbsorptionAmount() > 0.0f) {
                return 8;
            }
            if (!AsteorBar.config.showOnFullHealthWithoutAbsorption() && entity.getAbsorptionAmount() == 0.0f) {
                return 9;
            }
        }
        if (!entity.hasLineOfSight((Entity)player)) {
            return 10;
        }
        return 0;
    }

    private static int modifyAlpha(int color, int alpha) {
        if (alpha == 0) {
            return color;
        }
        int newAlpha = (color >> 24) * alpha / 255;
        return color & 0xFFFFFF | newAlpha << 24;
    }

    public static void render(LivingEntity entity, PoseStack poseStack, MultiBufferSource multiBufferSource) {
        Object absStr;
        double absorptionNum;
        int absorptionWidth;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        int check = EntityRenderer.check(entity, (Player)player);
        if (check > 0) {
            return;
        }
        float dist = entity.distanceTo((Entity)player);
        float layerDist = Math.max(0.002f, dist * 0.002f);
        int alpha = AsteorBar.config.healthBarAlpha();
        poseStack.pushPose();
        poseStack.translate(0.0, (double)entity.getBbHeight() + AsteorBar.config.healthBarOffsetY(), 0.0);
        Vector3f cameraEuler = Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation().getEulerAnglesXYZ(new Vector3f());
        poseStack.mulPose(new Quaternionf().rotationXYZ(0.0f, (float)Math.PI, 0.0f));
        poseStack.mulPose(new Quaternionf().rotationXYZ(-cameraEuler.x, cameraEuler.y, -cameraEuler.z));
        poseStack.pushPose();
        float scale = (float)AsteorBar.config.healthBarScale();
        int halfWidth = AsteorBar.config.healthBarHalfWidth();
        int halfHeight = AsteorBar.config.healthBarHalfHeight();
        poseStack.scale(-scale, -scale, scale);
        VertexConsumer bufferBuilder = multiBufferSource.getBuffer(AsteorBar.platformAdapter.getRenderType());
        double healthRate = Math.min((double)(entity.getHealth() / entity.getMaxHealth()), 1.0);
        int healthWidth = (int)((double)(halfWidth * 2) * healthRate);
        int colorHealth = AsteorBar.config.healthBarHealthColorDynamic() ? Utils.mixColor(AsteorBar.config.healthBarHealthColorFull(), AsteorBar.config.healthBarHealthColorEmpty(), healthRate) : AsteorBar.config.healthBarHealthColor();
        colorHealth = EntityRenderer.modifyAlpha(colorHealth, alpha);
        int colorEmpty = EntityRenderer.modifyAlpha(AsteorBar.config.healthBarEmptyColor(), alpha);
        if (healthWidth > 0) {
            GuiHelper.renderSolidGradient(bufferBuilder, poseStack, -halfWidth, -halfHeight, -halfWidth + healthWidth, halfHeight, colorHealth, layerDist);
        }
        if (healthWidth < 2 * halfWidth) {
            GuiHelper.renderSolidGradientUpDown(bufferBuilder, poseStack, -halfWidth + healthWidth, -halfHeight, halfWidth, halfHeight, colorEmpty, layerDist);
        }
        int renderAbsorptionMultiplier = -1;
        int boundWidth = AsteorBar.config.healthBarBoundWidth();
        int colorAbsorption = EntityRenderer.modifyAlpha(AsteorBar.config.healthBarAbsorptionColor(), alpha);
        int colorBound = EntityRenderer.modifyAlpha(AsteorBar.config.healthBarBoundColor(), alpha);
        boolean includeVertex = AsteorBar.config.healthBarBoundVertex();
        float absorptionRate = entity.getAbsorptionAmount() / entity.getMaxHealth();
        if ((absorptionWidth = Math.round((float)(halfWidth * 2 + boundWidth * 2) * (absorptionRate -= (float)(absorptionNum = Math.floor(absorptionRate))))) == 0 && absorptionNum > 0.0) {
            absorptionWidth = 2 * halfWidth + boundWidth * 2;
            absorptionNum -= 1.0;
        }
        GuiHelper.renderBound(bufferBuilder, poseStack, -halfWidth, -halfHeight, halfWidth, halfHeight, absorptionWidth, boundWidth, colorAbsorption, colorBound, includeVertex, layerDist);
        if (absorptionNum * 2.0 * (double)boundWidth > (double)halfWidth) {
            renderAbsorptionMultiplier = (int)absorptionNum;
        } else {
            int expand = includeVertex ? boundWidth : 0;
            int i = 0;
            while ((double)i < absorptionNum) {
                GuiHelper.renderSolid(bufferBuilder, poseStack, -halfWidth - expand + i * boundWidth * 2, halfHeight + boundWidth * 2, -halfWidth - expand + i * boundWidth * 2 + boundWidth, halfHeight + boundWidth * 3, colorAbsorption, layerDist);
                ++i;
            }
        }
        EntityRenderer.extraRender(entity, poseStack, multiBufferSource, halfWidth, halfHeight, boundWidth);
        float textScale = (float)AsteorBar.config.healthBarTextScale();
        double textOffset = AsteorBar.config.healthBarTextOffsetY();
        poseStack.pushPose();
        poseStack.translate(0.0, textOffset, 0.0);
        poseStack.scale(textScale, textScale, textScale);
        Font font = Minecraft.getInstance().font;
        String healthStr = Utils.formatNumber(entity.getHealth()) + "/" + Utils.formatNumber(entity.getMaxHealth());
        GuiHelper.renderCenteredString(poseStack, multiBufferSource, healthStr, 0, 0, 0xFFFFFF);
        if (entity.getAbsorptionAmount() > 0.0f) {
            absStr = Utils.formatNumber(entity.getAbsorptionAmount());
            GuiHelper.renderString(poseStack, multiBufferSource, (String)absStr, (int)((float)(-halfWidth + 1) / textScale), 0, 0xFFFF00);
        }
        if (renderAbsorptionMultiplier > 0) {
            absStr = renderAbsorptionMultiplier + "\u00d7";
            GuiHelper.renderString(poseStack, multiBufferSource, (String)absStr, (int)((float)(-halfWidth - 1 - font.width((String)absStr)) / textScale), 0, 0xFFFF00);
        }
        EntityRenderer.extraTextRender(entity, poseStack, multiBufferSource, halfWidth, halfHeight, boundWidth, textScale);
        poseStack.popPose();
        poseStack.popPose();
        poseStack.popPose();
    }

    public static interface ExtraTextRenderer {
        public void render(LivingEntity var1, PoseStack var2, MultiBufferSource var3, float var4, float var5, float var6, float var7);
    }

    public static interface ExtraRenderer {
        public void render(LivingEntity var1, PoseStack var2, MultiBufferSource var3, float var4, float var5, float var6);
    }
}

