/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.network;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.AsteorBarForge;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;

public class NetworkHandler {
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("asteorbar", "network"), () -> "1.0", s -> true, s -> true);
    private static final Map<UUID, Float> EXHAUSTION = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> SATURATION = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> TOUGH_AS_NAILS_HYDRATION = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> TOUGH_AS_NAILS_EXHAUSTION = new HashMap<UUID, Float>();

    public static void init() {
        CHANNEL.registerMessage(0, ExhaustionPacket.class, ExhaustionPacket::encode, ExhaustionPacket::decode, ExhaustionPacket::handle);
        CHANNEL.registerMessage(1, SaturationPacket.class, SaturationPacket::encode, SaturationPacket::decode, SaturationPacket::handle);
        CHANNEL.registerMessage(2, EntityAbsorptionPacket.class, EntityAbsorptionPacket::encode, EntityAbsorptionPacket::decode, EntityAbsorptionPacket::handle);
        CHANNEL.registerMessage(3, ActivatePacket.class, ActivatePacket::encode, ActivatePacket::decode, ActivatePacket::handle);
        CHANNEL.registerMessage(64, ToughAsNailsPacket.class, ToughAsNailsPacket::encode, ToughAsNailsPacket::decode, ToughAsNailsPacket::handle);
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            FoodData foodStats = player2.m_36324_();
            float exhaustionLevel = foodStats.m_150380_();
            Float oldExhaustion = EXHAUSTION.get(player2.m_20148_());
            if (oldExhaustion == null || Math.abs(oldExhaustion.floatValue() - exhaustionLevel) >= 0.01f) {
                EXHAUSTION.put(player2.m_20148_(), Float.valueOf(exhaustionLevel));
                CHANNEL.sendTo((Object)new ExhaustionPacket(exhaustionLevel), player2.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
            float saturationLevel = foodStats.m_38722_();
            Float oldSaturation = SATURATION.get(player2.m_20148_());
            if (oldSaturation == null || Math.abs(oldSaturation.floatValue() - saturationLevel) >= 0.01f) {
                SATURATION.put(player2.m_20148_(), Float.valueOf(saturationLevel));
                CHANNEL.sendTo((Object)new SaturationPacket(saturationLevel), player2.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
            if (AsteorBar.compatibility.toughAsNails) {
                IThirst thirst = ThirstHelper.getThirst((Player)player2);
                boolean send = false;
                float hydration = thirst.getHydration();
                Float oldHydration = TOUGH_AS_NAILS_HYDRATION.get(player2.m_20148_());
                if (oldHydration == null || Math.abs(oldHydration.floatValue() - hydration) >= 0.01f) {
                    TOUGH_AS_NAILS_HYDRATION.put(player2.m_20148_(), Float.valueOf(hydration));
                    send = true;
                }
                float exhaustion = thirst.getExhaustion();
                Float oldToughAsNailsExhaustion = TOUGH_AS_NAILS_EXHAUSTION.get(player2.m_20148_());
                if (oldToughAsNailsExhaustion == null || Math.abs(oldToughAsNailsExhaustion.floatValue() - exhaustion) >= 0.01f) {
                    TOUGH_AS_NAILS_EXHAUSTION.put(player2.m_20148_(), Float.valueOf(exhaustion));
                    send = true;
                }
                if (send) {
                    CHANNEL.sendTo((Object)new ToughAsNailsPacket(hydration, exhaustion), player2.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
            }
        }
    }

    private static Player getPlayer(NetworkEvent.Context context) {
        return context.getDirection() == NetworkDirection.PLAY_TO_SERVER ? context.getSender() : Minecraft.m_91087_().f_91074_;
    }

    public static class ExhaustionPacket {
        public float exhaustion;

        public ExhaustionPacket(float exhaustion) {
            this.exhaustion = exhaustion;
        }

        public static void encode(ExhaustionPacket packet, FriendlyByteBuf buffer) {
            buffer.writeFloat(packet.exhaustion);
        }

        public static ExhaustionPacket decode(FriendlyByteBuf buffer) {
            return new ExhaustionPacket(buffer.readFloat());
        }

        public static void handle(ExhaustionPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                Player player = NetworkHandler.getPlayer((NetworkEvent.Context)context.get());
                if (player != null) {
                    FoodData foodStats = player.m_36324_();
                    foodStats.m_150378_(packet.exhaustion);
                }
            });
            context.get().setPacketHandled(true);
        }
    }

    public static class SaturationPacket {
        public float saturation;

        public SaturationPacket(float saturation) {
            this.saturation = saturation;
        }

        public static void encode(SaturationPacket packet, FriendlyByteBuf buffer) {
            buffer.writeFloat(packet.saturation);
        }

        public static SaturationPacket decode(FriendlyByteBuf buffer) {
            return new SaturationPacket(buffer.readFloat());
        }

        public static void handle(SaturationPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                Player player = NetworkHandler.getPlayer((NetworkEvent.Context)context.get());
                if (player != null) {
                    FoodData foodStats = player.m_36324_();
                    foodStats.m_38717_(packet.saturation);
                }
            });
            context.get().setPacketHandled(true);
        }
    }

    public static class EntityAbsorptionPacket {
        public int entityId;
        public float absorption;

        public EntityAbsorptionPacket(int entityId, float absorption) {
            this.entityId = entityId;
            this.absorption = absorption;
        }

        public static void encode(EntityAbsorptionPacket packet, FriendlyByteBuf buffer) {
            buffer.writeInt(packet.entityId);
            buffer.writeFloat(packet.absorption);
        }

        public static EntityAbsorptionPacket decode(FriendlyByteBuf buffer) {
            return new EntityAbsorptionPacket(buffer.readInt(), buffer.readFloat());
        }

        public static void handle(EntityAbsorptionPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                Entity entity;
                Player player = NetworkHandler.getPlayer((NetworkEvent.Context)context.get());
                if (player != null && (entity = player.m_9236_().m_6815_(packet.entityId)) instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    livingEntity.m_7911_(packet.absorption);
                }
            });
            context.get().setPacketHandled(true);
        }
    }

    public static class ActivatePacket {
        public boolean activate;

        public ActivatePacket(boolean activate) {
            this.activate = activate;
        }

        public static void encode(ActivatePacket packet, FriendlyByteBuf buffer) {
            buffer.writeBoolean(packet.activate);
        }

        public static ActivatePacket decode(FriendlyByteBuf buffer) {
            return new ActivatePacket(buffer.readBoolean());
        }

        public static void handle(ActivatePacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                AsteorBarForge.LOGGER.info("Received activate packet. Sending back to server.");
                CHANNEL.sendToServer((Object)new ActivatePacket(true));
            });
            context.get().setPacketHandled(true);
        }
    }

    public static class ToughAsNailsPacket {
        float hydration;
        float exhaustion;

        public ToughAsNailsPacket(float hydration, float exhaustion) {
            this.hydration = hydration;
            this.exhaustion = exhaustion;
        }

        public static void encode(ToughAsNailsPacket packet, FriendlyByteBuf buffer) {
            buffer.writeFloat(packet.hydration);
            buffer.writeFloat(packet.exhaustion);
        }

        public static ToughAsNailsPacket decode(FriendlyByteBuf buffer) {
            return new ToughAsNailsPacket(buffer.readFloat(), buffer.readFloat());
        }

        public static void handle(ToughAsNailsPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                Player player = NetworkHandler.getPlayer((NetworkEvent.Context)context.get());
                if (player != null && AsteorBar.compatibility.toughAsNails) {
                    IThirst thirst = ThirstHelper.getThirst((Player)player);
                    thirst.setHydration(packet.hydration);
                    thirst.setExhaustion(packet.exhaustion);
                }
            });
            context.get().setPacketHandled(true);
        }
    }
}

