/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.client.ClientInfo;
import com.hollingsworth.arsnouveau.client.gui.GuiManaHUD;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ArsNouveauOverlay
extends SimpleBarOverlay {
    private int maxMana = 0;

    @Override
    protected SimpleBarOverlay.Parameters getParameters(Player player) {
        IManaCap mana = (IManaCap)CapabilityRegistry.getMana((LivingEntity)player).orElse(null);
        if (mana == null || mana.getMaxMana() <= 0) {
            return null;
        }
        this.maxMana = mana.getMaxMana();
        SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
        parameters.value = mana.getCurrentMana();
        parameters.capacity = (double)mana.getMaxMana() * (1.0 + (double)ClientInfo.reservedOverlayMana);
        parameters.emptyColor = -12707757;
        parameters.fillColor = -6476292;
        parameters.fillColor2 = -8247599;
        parameters.boundColor = -338358;
        parameters.boundColor2 = -5086191;
        if (ArsNouveauAPI.ENABLE_DEBUG_NUMBERS) {
            parameters.centerText = mana.getCurrentMana() + "  /  " + this.maxMana;
            parameters.centerColor = 0xFFFFFF;
        }
        return parameters;
    }

    @Override
    protected void drawDecorations(GuiGraphics guiGraphics, int left, int top, int right, int bottom, SimpleBarOverlay.Parameters parameters, boolean flip) {
        int innerWidth = right - left - 2;
        if (ClientInfo.reservedOverlayMana > 0.0f) {
            int reserveManaLength = (int)((float)innerWidth * ClientInfo.reservedOverlayMana);
            int offset = innerWidth - reserveManaLength;
            this.drawFillFlipConcat(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, offset, reserveManaLength, -13433503, flip);
        }
        if (ClientInfo.redTicks()) {
            int redManaLength = (int)((float)innerWidth * Mth.m_14036_((float)0.0f, (float)(ClientInfo.redOverlayMana / (float)this.maxMana), (float)1.0f));
            int color = 0xFF0000 + (int)((float)ClientInfo.redOverlayTicks / 35.0f * 255.0f) << 24;
            this.drawFillFlip(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, 0, redManaLength, color, flip);
        }
    }

    @Override
    protected boolean shouldRender(Player player) {
        return AsteorBar.compatibility.arsNouveau && AsteorBar.config.hookArsNouveau() && GuiManaHUD.shouldDisplayBar();
    }
}

