/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.Overlays;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ExperienceBarOverlay
extends SimpleBarOverlay {
    int level;
    int need;
    int has;

    @Override
    protected SimpleBarOverlay.Parameters getParameters(Player player) {
        this.level = player.f_36078_;
        this.need = player.m_36323_();
        this.has = (int)(player.f_36080_ * (float)player.m_36323_());
        SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
        parameters.fillColor = AsteorBar.config.experienceColor();
        parameters.boundColor = AsteorBar.config.experienceBoundColor();
        parameters.emptyColor = AsteorBar.config.experienceEmptyColor();
        parameters.value = player.f_36080_;
        return parameters;
    }

    @Override
    protected void drawDecorations(GuiGraphics guiGraphics, int left, int top, int right, int bottom, SimpleBarOverlay.Parameters parameters, boolean flip) {
        int y;
        int x;
        super.drawDecorations(guiGraphics, left, top, right, bottom, parameters, flip);
        int innerWidth = right - left - 2;
        int textureWidth = Math.min(179, Math.max(0, (innerWidth + 5) / 10 - 1) * 10 + 9);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        this.drawTextureFillColor(guiGraphics, left + 1, top, innerWidth, 5, 10, 18, textureWidth, 5, AsteorBar.config.experienceColor());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LIGHTMAP_TEXTURE);
        if (AsteorBar.config.displayExperienceLevel()) {
            x = (right + left) / 2;
            y = top - 2;
            Overlays.addStringRender(x, y, 8453920, String.valueOf(this.level), 1, false, true, 0);
        }
        if (AsteorBar.config.displayExperienceProgress()) {
            boolean inside;
            int len = (right - left) / 2;
            x = left + len;
            y = top - 2;
            boolean bl = inside = len < 180;
            if (x >= 0 && y >= 0) {
                if (inside) {
                    Overlays.addStringRender(x - len + 2, y, 0xFFFFFF, String.valueOf(this.has), 0, true);
                    Overlays.addStringRender(x + len - 2, y, 0xFFFFFF, String.valueOf(this.need), 2, true);
                } else {
                    Overlays.addStringRender(x - len, y, 0xFFFFFF, String.valueOf(this.has), 2, true);
                    Overlays.addStringRender(x + len, y, 0xFFFFFF, String.valueOf(this.need), 0, true);
                }
            }
        }
    }

    @Override
    protected boolean shouldRender(Player player) {
        return true;
    }
}

