/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.Overlays;
import com.afoxxvi.asteorbar.overlay.RenderGui;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.elenai.feathers.client.ClientFeathersData;
import com.elenai.feathers.effect.FeathersEffects;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;

public class FeathersOverlay
extends SimpleBarOverlay {
    int times = 0;
    int regenerationOffset = -1;
    int tickCount = 0;

    @Override
    public void renderOverlay(RenderGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        this.tickCount = gui.gui().m_93079_();
        super.renderOverlay(gui, guiGraphics, partialTick, screenWidth, screenHeight);
    }

    @Override
    protected SimpleBarOverlay.Parameters getParameters(Player player) {
        SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
        parameters.boundColor = ClientFeathersData.isCold() ? -14924206 : -14671840;
        parameters.fillColor = ClientFeathersData.isCold() ? -5703681 : -14506512;
        parameters.emptyColor = ClientFeathersData.isCold() ? -14262932 : -16237222;
        parameters.value = ClientFeathersData.getFeathers();
        parameters.capacity = ClientFeathersData.getMaxFeathers();
        if (ClientFeathersData.getEnduranceFeathers() > 0) {
            int value;
            parameters.boundFillColor = -2838729;
            int capacity = ClientFeathersData.getMaxFeathers();
            if (capacity < (value = ClientFeathersData.getEnduranceFeathers())) {
                if (value % capacity == 0) {
                    this.times = value / capacity - 1;
                    value = capacity;
                } else {
                    this.times = value / capacity;
                    value %= capacity;
                }
            }
            parameters.boundCapacity = capacity;
            parameters.boundValue = value;
        } else {
            this.times = 0;
        }
        this.regenerationOffset = player.m_21023_((MobEffect)FeathersEffects.ENERGIZED.get()) ? this.tickCount % 30 * 6 : -1;
        return parameters;
    }

    @Override
    protected void drawDecorations(GuiGraphics guiGraphics, int left, int top, int right, int bottom, SimpleBarOverlay.Parameters parameters, boolean flip) {
        super.drawDecorations(guiGraphics, left, top, right, bottom, parameters, flip);
        int innerWidth = right - left - 2;
        int fillWidth = innerWidth * ClientFeathersData.getWeight() / ClientFeathersData.getMaxFeathers();
        this.drawFillFlip(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, fillWidth, -4671036, flip);
        if (this.times > 0) {
            if (flip) {
                Overlays.addStringRender(right, top - 2, 13938487, "\u00d7" + this.times, 0, true);
            } else {
                Overlays.addStringRender(left, top - 2, 13938487, this.times + "\u00d7", 2, true);
            }
        }
        if (this.regenerationOffset >= 0) {
            int textureLeft = flip ? this.regenerationOffset - 180 : -this.regenerationOffset;
            int textureRight = textureLeft + right - left - 2;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            if (textureRight > 0) {
                this.drawTextureFillColor(guiGraphics, left + 1, top, -textureLeft, 5, 190 + textureLeft, 0, -textureLeft, 5, -4268806);
                this.drawTextureFillColor(guiGraphics, left + 1 - textureLeft, top, textureRight, 5, 10, 0, textureRight, 5, -4268806);
            } else {
                this.drawTextureFillColor(guiGraphics, left + 1, top, right - left - 2, 5, 190 + textureLeft, 0, right - left - 2, 5, -4268806);
            }
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)LIGHTMAP_TEXTURE);
        }
    }

    @Override
    protected boolean shouldRender(Player player) {
        return AsteorBar.compatibility.feathers && AsteorBar.config.hookFeathers() && !(ClientFeathersData.getMaxFeathers() <= 0 & ClientFeathersData.getEnduranceFeathers() == 0);
    }
}

