/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.mojang.blaze3d.systems.RenderSystem;
import homeostatic.common.Hydration;
import homeostatic.common.capabilities.CapabilityRegistry;
import homeostatic.common.capabilities.Water;
import homeostatic.common.effect.HomeostaticEffects;
import homeostatic.util.WaterHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;

public class HomeostaticOverlay
extends SimpleBarOverlay {
    private int hydrationLevel;
    private float hydrationSaturationLevel;

    @Override
    protected SimpleBarOverlay.Parameters getParameters(Player player) {
        LazyOptional dataOpt = player.getCapability(CapabilityRegistry.WATER_CAPABILITY);
        if (!dataOpt.isPresent()) {
            return null;
        }
        MobEffectInstance effectInstance = player.m_21124_(HomeostaticEffects.THIRST);
        ItemStack heldItem = player.m_21205_();
        Hydration hydration = WaterHelper.getItemHydration((ItemStack)heldItem);
        Water data = (Water)dataOpt.orElse((Object)new Water());
        int waterLevel = data.getWaterLevel();
        float waterSaturationLevel = data.getWaterSaturationLevel();
        if (hydration != null) {
            this.hydrationLevel = hydration.amount();
            this.hydrationSaturationLevel = hydration.saturation();
        } else {
            this.hydrationLevel = 0;
            this.hydrationSaturationLevel = 0.0f;
        }
        SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
        parameters.value = waterLevel;
        parameters.capacity = 20.0;
        parameters.boundValue = waterSaturationLevel;
        parameters.boundCapacity = 20.0;
        if (effectInstance != null) {
            parameters.emptyColor = -13751780;
            parameters.fillColor = -6123432;
            parameters.boundColor = -10721773;
            parameters.boundFillColor = -2438463;
        } else {
            parameters.emptyColor = -14079703;
            parameters.fillColor = -16754001;
            parameters.boundColor = -16767092;
            parameters.boundFillColor = -8201475;
        }
        return parameters;
    }

    @Override
    protected void drawDecorations(GuiGraphics guiGraphics, int left, int top, int right, int bottom, SimpleBarOverlay.Parameters parameters, boolean flip) {
        super.drawDecorations(guiGraphics, left, top, right, bottom, parameters, flip);
        if (this.hydrationLevel == 0 && this.hydrationSaturationLevel == 0.0f) {
            return;
        }
        float alpha = (float)Math.cos((double)(this.tick % 40) / 40.0 * Math.PI * 2.0) * 0.5f + 0.5f;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        double fillWidth = (double)(right - left - 2) * parameters.value / parameters.capacity;
        this.drawFillFlipConcat(guiGraphics, left + 1, top + 1, right - 1, bottom - 1, (int)fillWidth, (int)((double)((right - left - 2) * this.hydrationLevel) / parameters.capacity), parameters.fillColor, flip);
        double boundWidth = (double)(right - left) * parameters.boundValue / parameters.boundCapacity;
        this.drawBoundFlipConcat(guiGraphics, left, top, right, bottom, (int)boundWidth, (int)((double)((float)(right - left) * this.hydrationSaturationLevel) / parameters.boundCapacity), parameters.boundFillColor, flip);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    protected boolean shouldRender(Player player) {
        return AsteorBar.compatibility.homeostatic && AsteorBar.config.hookHomeostatic();
    }
}

