/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.Overlays;
import com.afoxxvi.asteorbar.overlay.RenderGui;
import com.afoxxvi.asteorbar.overlay.parts.BaseOverlay;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.afoxxvi.asteorbar.utils.Utils;
import luoyu.lightshield.Api;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.entity.player.Player;

public class LightShieldOverlay
extends BaseOverlay
implements SimpleBarOverlay.Layer {
    @Override
    public void drawLayer(Player player, GuiGraphics guiGraphics, int left, int top, int right, int bottom, SimpleBarOverlay.Parameters parameters, boolean flip) {
        float shield = Api.getShieldAmount((Player)player);
        float maxShield = AsteorBar.config.displayAbsorptionDivMaxHealth() ? player.m_21233_() : Api.getMaxShieldAmount((Player)player);
        int innerWidth = right - left - 2;
        float displayShield = shield % maxShield;
        if (displayShield == 0.0f && shield > 0.0f) {
            displayShield = maxShield;
        }
        int shieldWidth = (int)(displayShield * (float)innerWidth / maxShield);
        this.drawFillFlip(guiGraphics, left + 1, top + 3, right - 1, bottom - 1, shieldWidth, -7556150, flip);
        this.drawFillFlip(guiGraphics, left + 1, bottom - 1, right - 1, bottom, shieldWidth, -9398354, flip);
        String text = Utils.formatNumber(shield);
        if (AsteorBar.config.displayHealthText()) {
            if (flip) {
                Overlays.addStringRender(left + 2, top - 2, 11978945, text, 0, true);
            } else {
                Overlays.addStringRender(right - 2, top - 2, 11978945, text, 2, true);
            }
        }
        if (shield > maxShield) {
            int absorbTimes = (int)(shield / maxShield);
            if (shield % maxShield == 0.0f) {
                --absorbTimes;
            }
            if (flip) {
                Overlays.addStringRender(left, top - 2, 11978945, "\u00d7" + absorbTimes, 2, true);
            } else {
                Overlays.addStringRender(right, top - 2, 11978945, absorbTimes + "\u00d7", 0, true);
            }
        }
    }

    @Override
    public void renderOverlay(RenderGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
    }
}

