/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.afoxxvi.asteorbar.utils.Utils;
import com.alrex.parcool.common.capability.IStamina;
import com.alrex.parcool.common.capability.Parkourability;
import com.alrex.parcool.config.ParCoolConfig;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ParcoolOverlay
extends SimpleBarOverlay {
    @Override
    protected SimpleBarOverlay.Parameters getParameters(Player player) {
        IStamina iStamina = IStamina.get((Player)player);
        Parkourability parkourability = Parkourability.get((Player)player);
        if (iStamina == null || parkourability == null) {
            return null;
        }
        if (!ParCoolConfig.Client.Booleans.HideStaminaHUDWhenStaminaIsInfinite.get().booleanValue() || !parkourability.getActionInfo().isStaminaInfinite(player.m_7500_() || player.m_5833_())) {
            SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
            if (iStamina.isExhausted()) {
                parameters.fillColor = -43948;
                parameters.boundColor = -10485760;
                parameters.emptyColor = -14680064;
            } else {
                parameters.fillColor = -228;
                parameters.boundColor = -10461184;
                parameters.emptyColor = -14671872;
            }
            parameters.value = iStamina.get();
            parameters.capacity = iStamina.getActualMaxStamina();
            return parameters;
        }
        return null;
    }

    @Override
    protected void drawDecorations(GuiGraphics guiGraphics, int left, int top, int right, int bottom, SimpleBarOverlay.Parameters parameters, boolean flip) {
        super.drawDecorations(guiGraphics, left, top, right, bottom, parameters, flip);
        int innerWidth = right - left - 2;
        int fillWidth = (int)((double)innerWidth * parameters.value / parameters.capacity);
        int color = Utils.mixColor(-1, parameters.fillColor, 0.5);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        if (flip) {
            this.drawTextureFillColor(guiGraphics, right - 1 - fillWidth, top, fillWidth, 5, 190 - fillWidth, 27, fillWidth, 5, color);
        } else {
            this.drawTextureFillColor(guiGraphics, left + 1, top, fillWidth, 5, 10, 36, fillWidth, 5, color);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)LIGHTMAP_TEXTURE);
    }

    @Override
    protected boolean shouldRender(Player player) {
        return AsteorBar.compatibility.parcool && AsteorBar.config.hookParcool();
    }
}

