/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.afoxxvi.asteorbar.utils.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;

public class PlayerHealthOverlay
extends SimpleBarOverlay {
    public static final int ABSORPTION_MODE_TOGETHER = 0;
    public static final int ABSORPTION_MODE_STACK = 1;
    public static final int ABSORPTION_MODE_BOUND = 2;
    public static final int ABSORPTION_MODES = 3;
    public static final int ABSORPTION_TEXT_MODE_TOGETHER = 0;
    public static final int ABSORPTION_TEXT_MODE_SEPARATE = 1;
    public static final int ABSORPTION_TEXT_MODES = 2;
    private long healthBlinkTime = 0L;
    private long lastHealthTime;
    private float lastHealth;
    private boolean highlight;
    private int regenerationOffset;
    private boolean fullHealth;
    private float flashAlpha;
    private final int[] shift = new int[]{0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1, 0, 0, 1, 0, 1, 0, 1};

    private int[] getStackColor(int low, int num) {
        String[] colors = AsteorBar.config.stackHealthBarColors().split(",");
        String color1 = low == 0 ? "#00000000" : colors[(low - 1) % colors.length];
        String color2 = colors[low % colors.length];
        if (num == 2) {
            return new int[]{Utils.parseHexColor(color1), Utils.parseHexColor(color2)};
        }
        return new int[]{Utils.parseHexColor(color1), Utils.parseHexColor(color2), Utils.parseHexColor(colors[(low + 1) % colors.length])};
    }

    @Override
    protected SimpleBarOverlay.Parameters getParameters(Player player) {
        float maxHealth;
        float health = player.m_21223_();
        this.highlight = false;
        if (AsteorBar.config.enableHealthBlink()) {
            boolean bl = this.highlight = this.healthBlinkTime > (long)this.tick && (this.healthBlinkTime - (long)this.tick) / 3L % 2L == 1L;
            if (health < this.lastHealth && player.f_19802_ > 0) {
                this.lastHealthTime = Util.m_137550_();
                this.healthBlinkTime = (long)this.tick + 20L;
            } else if (health > this.lastHealth && player.f_19802_ > 0) {
                this.lastHealthTime = Util.m_137550_();
                this.healthBlinkTime = (long)this.tick + 10L;
            }
            if (Util.m_137550_() - this.lastHealthTime > 1000L) {
                this.lastHealth = health;
                this.lastHealthTime = Util.m_137550_();
            }
            this.lastHealth = health;
        }
        this.regenerationOffset = -1;
        if (player.m_21023_(MobEffects.f_19605_)) {
            this.regenerationOffset = this.tick % 30 * 6;
        }
        this.fullHealth = health >= (maxHealth = player.m_21233_());
        float absorb = player.m_6103_();
        this.flashAlpha = -1.0f;
        if ((double)health < (double)maxHealth * AsteorBar.config.lowHealthRate() && !this.highlight) {
            int margin = Math.abs(this.tick % 20 - 10);
            this.flashAlpha = 0.08f * (float)margin;
        }
        SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
        if ((double)health < (double)maxHealth * AsteorBar.config.lowHealthRate()) {
            parameters.verticalShift = this.shift[this.tick % this.shift.length];
        }
        parameters.boundColor = AsteorBar.config.healthBoundColor();
        parameters.emptyColor = AsteorBar.config.healthEmptyColor();
        int healthColor = AsteorBar.config.healthColorNormal();
        if (player.m_21023_(MobEffects.f_19614_)) {
            healthColor = AsteorBar.config.healthColorPoison();
        } else if (player.m_21023_(MobEffects.f_19615_)) {
            healthColor = AsteorBar.config.healthColorWither();
        } else if (player.m_146890_()) {
            healthColor = AsteorBar.config.healthColorFrozen();
        }
        parameters.fillColor = healthColor;
        parameters.boundFillColor = AsteorBar.config.absorptionColor();
        parameters.secondFillColor = AsteorBar.config.absorptionColor();
        int i = AsteorBar.config.displayAbsorptionMethod();
        if (AsteorBar.config.enableStackHealthBar()) {
            i = 2;
        }
        if (i == 0) {
            double full = maxHealth + absorb;
            parameters.value = 1.0 - (double)(maxHealth - health) / full - parameters.secondValue;
            parameters.secondValue = (double)absorb / full;
            parameters.secondValueOffset = parameters.value;
            parameters.secondFillColor = AsteorBar.config.absorptionColor();
            parameters.secondFillAlpha = 0.66f;
        } else {
            parameters.value = health / maxHealth;
            if (AsteorBar.config.enableStackHealthBar()) {
                int unit = AsteorBar.config.fullHealthValue();
                parameters.value = health % (float)unit / (float)unit;
                parameters.secondValue = 0.0;
                int[] colors = this.getStackColor((int)(health / (float)unit), 3);
                if (health >= (float)unit) {
                    parameters.emptyColor = colors[0];
                }
                parameters.fillColor = colors[1];
                parameters.secondFillColor = colors[2];
                if (healthColor != AsteorBar.config.healthColorNormal()) {
                    parameters.emptyColor = Utils.mixColor(parameters.emptyColor, healthColor, 0.33f);
                    parameters.fillColor = Utils.mixColor(parameters.fillColor, healthColor, 0.33f);
                    parameters.secondFillColor = Utils.mixColor(parameters.secondFillColor, healthColor, 0.33f);
                }
            } else {
                parameters.value = health / maxHealth;
            }
            float fullAbsorb = AsteorBar.config.enableStackHealthBar() ? (float)AsteorBar.config.fullHealthValue() : maxHealth;
            float displayAbsorb = absorb % fullAbsorb;
            if (displayAbsorb == 0.0f && absorb > 0.0f) {
                displayAbsorb = fullAbsorb;
            }
            if (i == 1) {
                parameters.secondValue = displayAbsorb / fullAbsorb;
                parameters.secondFillColor = AsteorBar.config.absorptionColor();
                parameters.secondFillAlpha = 0.66f;
            } else if (i == 2) {
                parameters.boundFillColor = AsteorBar.config.absorptionColor();
                parameters.boundValue = displayAbsorb / fullAbsorb;
                parameters.boundAlpha = 0.9f;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (absorb > fullAbsorb && (AsteorBar.config.enableStackHealthBar() || AsteorBar.config.displayAbsorptionDivMaxHealth())) {
                int absorbTimes = (int)(absorb / fullAbsorb);
                if (absorb % fullAbsorb == 0.0f) {
                    --absorbTimes;
                }
                parameters.leftOuterText = "\u00d7" + absorbTimes;
                parameters.leftOuterColor = 0xFFFF00;
            }
        }
        if (AsteorBar.config.displayHealthText()) {
            String hp = AsteorBar.config.displayAbsorptionTextMethod() == 0 && absorb > 0.0f ? Utils.formatNumber(health) + "(+" + Utils.formatNumber(absorb) + ")/" + Utils.formatNumber(maxHealth) : Utils.formatNumber(health) + "/" + Utils.formatNumber(maxHealth);
            parameters.centerText = hp;
            parameters.centerColor = 0xFFFFFF;
            if (AsteorBar.config.displayAbsorptionTextMethod() == 1 && absorb > 0.0f) {
                parameters.leftText = Utils.formatNumber(absorb);
                parameters.leftColor = 0xFFFF00;
            }
        }
        return parameters;
    }

    @Override
    protected void drawDecorations(GuiGraphics guiGraphics, int left, int top, int right, int bottom, SimpleBarOverlay.Parameters parameters, boolean flip) {
        super.drawDecorations(guiGraphics, left, top, right, bottom, parameters, flip);
        if (this.regenerationOffset >= 0) {
            float alpha = (float)AsteorBar.config.healthRegenerationOpacity();
            if (this.fullHealth) {
                alpha = (float)AsteorBar.config.healthRegenerationOpacityOnFull();
            }
            int textureLeft = flip ? this.regenerationOffset - 180 : -this.regenerationOffset;
            int textureRight = textureLeft + right - left - 2;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            alpha = Math.min(1.0f, Math.max(0.0f, alpha));
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            if (textureRight > 0) {
                this.drawTextureFill(guiGraphics, left + 1, top, -textureLeft, 5, 190 + textureLeft, 0);
                this.drawTextureFill(guiGraphics, left + 1 - textureLeft, top, textureRight, 5, 10, 0);
            } else {
                this.drawTextureFill(guiGraphics, left + 1, top, right - left - 2, 5, 190 + textureLeft, 0);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)LIGHTMAP_TEXTURE);
        }
        if (this.highlight) {
            this.drawBound(guiGraphics, left, top, right, bottom, AsteorBar.config.healthBoundColorBlink());
        } else if (this.flashAlpha > 0.0f) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)this.flashAlpha);
            this.drawBound(guiGraphics, left, top, right, bottom, AsteorBar.config.healthBoundColorLow());
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    protected boolean shouldRender(Player player) {
        return true;
    }

    @Override
    protected boolean showFadeEffect() {
        return true;
    }
}

