/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.afoxxvi.asteorbar.utils.Utils;
import dev.epicsquid.superiorshields.registry.CapabilityRegistry;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SuperiorShieldsOverlay
extends SimpleBarOverlay {
    @Override
    protected SimpleBarOverlay.Parameters getParameters(Player player) {
        int shieldHp = CapabilityRegistry.INSTANCE.getShield((LivingEntity)player).getHp();
        int shieldCapacity = CapabilityRegistry.INSTANCE.getShield((LivingEntity)player).getCapacity();
        if (shieldCapacity <= 0) {
            return null;
        }
        SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
        parameters.value = shieldHp;
        parameters.capacity = shieldCapacity;
        parameters.fillColor = -9895943;
        parameters.emptyColor = 2137587705;
        parameters.boundColor = -13469065;
        if (AsteorBar.config.displayHealthText()) {
            parameters.centerText = Utils.formatNumber(shieldHp) + "/" + Utils.formatNumber(shieldCapacity);
            parameters.centerColor = -1310722;
        }
        return parameters;
    }

    @Override
    protected boolean isLeftSide() {
        return true;
    }

    @Override
    protected boolean shouldRender(Player player) {
        return AsteorBar.compatibility.superiorshields && AsteorBar.config.hookSuperiorShields();
    }
}

