/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.afoxxvi.asteorbar.utils.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.ghen.thirst.content.thirst.PlayerThirst;
import dev.ghen.thirst.foundation.common.capability.IThirst;
import dev.ghen.thirst.foundation.common.capability.ModCapabilities;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;

public class ThirstOverlay
extends SimpleBarOverlay {
    private int thirstBlinkTime = 0;
    private float exhaustion = 0.0f;

    @Override
    protected SimpleBarOverlay.Parameters getParameters(Player player) {
        LazyOptional thirstLazyOptional = player.getCapability(ModCapabilities.PLAYER_THIRST);
        if (!thirstLazyOptional.isPresent()) {
            return null;
        }
        IThirst thirst = (IThirst)thirstLazyOptional.orElse((Object)new PlayerThirst());
        int level = thirst.getThirst();
        float quenched = thirst.getQuenched();
        this.exhaustion = thirst.getExhaustion();
        SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
        parameters.value = level;
        parameters.capacity = 20.0;
        parameters.fillColor = -13124924;
        parameters.emptyColor = AsteorBar.config.foodEmptyColor();
        parameters.boundColor = Utils.mixColor(-16777216, parameters.fillColor, 0.5);
        if (this.thirstBlinkTime > 0) {
            parameters.boundColor = Utils.mixColor(-1, parameters.fillColor, 0.08);
        }
        if (AsteorBar.config.displaySaturation()) {
            parameters.boundFillColor = -13802026;
            parameters.boundCapacity = 10.0;
            parameters.boundValue = quenched;
        }
        if (AsteorBar.config.enableFoodBlink()) {
            if (quenched <= 0.0f && (long)this.tick % ((long)Math.max(4, level) * 3L + 1L) == 0L) {
                this.thirstBlinkTime = 2;
            }
            if (this.thirstBlinkTime > 0) {
                --this.thirstBlinkTime;
            }
        }
        return parameters;
    }

    @Override
    protected void drawDecorations(GuiGraphics guiGraphics, int left, int top, int right, int bottom, SimpleBarOverlay.Parameters parameters, boolean flip) {
        super.drawDecorations(guiGraphics, left, top, right, bottom, parameters, flip);
        if (AsteorBar.config.displayExhaustion()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            float cap = 4.0f;
            int exhaustionWidth = (int)((float)(right - left - 2) * (Math.min(cap, this.exhaustion) / cap));
            this.drawTextureFillFlip(guiGraphics, left + 1, top, right - 1, exhaustionWidth, 5, 10, 9, 180, flip);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)LIGHTMAP_TEXTURE);
        }
    }

    @Override
    protected boolean shouldRender(Player player) {
        return AsteorBar.compatibility.thirst && AsteorBar.config.hookThirstWasTaken();
    }
}

