/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts.lso;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import sfiomn.legendarysurvivaloverhaul.api.data.json.JsonThirstConsumable;
import sfiomn.legendarysurvivaloverhaul.api.data.manager.ThirstDataManager;
import sfiomn.legendarysurvivaloverhaul.api.thirst.ThirstUtil;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.thirst.ThirstCapability;
import sfiomn.legendarysurvivaloverhaul.config.Config;
import sfiomn.legendarysurvivaloverhaul.registry.MobEffectRegistry;
import sfiomn.legendarysurvivaloverhaul.util.CapabilityUtil;

public class LegendarySurvivalOverhaulThirstOverlay
extends SimpleBarOverlay {
    private ThirstCapability thirstCap = null;
    @Nullable
    private Item heldItemOnPreview;
    private int heldItemHydration;
    private float heldItemSaturation;
    private boolean heldItemThirst;
    private int blinkTime = 0;

    @Override
    protected SimpleBarOverlay.Parameters getParameters(Player player) {
        if (!ThirstUtil.isThirstActive((Player)player)) {
            return null;
        }
        if (this.thirstCap == null || player.f_19797_ % 20 == 0) {
            this.thirstCap = CapabilityUtil.getThirstCapability((Player)player);
        }
        ItemStack currentHeldItemStack = player.m_21205_();
        if (Config.Baked.showDrinkPreview) {
            if (player.f_19797_ % 10 == 0) {
                JsonThirstConsumable jsonThirstConsumable = ThirstDataManager.getConsumable((ItemStack)currentHeldItemStack);
                this.heldItemHydration = jsonThirstConsumable != null ? jsonThirstConsumable.hydration : 0;
                this.heldItemSaturation = jsonThirstConsumable != null ? jsonThirstConsumable.saturation : 0.0f;
                boolean bl = this.heldItemThirst = jsonThirstConsumable != null && jsonThirstConsumable.effects.stream().anyMatch(jsonEffectParameter -> jsonEffectParameter.name.equals("legendarysurvivaloverhaul:thirst"));
            }
            if (this.heldItemOnPreview == null || currentHeldItemStack.m_41614_() != this.heldItemOnPreview.m_41472_()) {
                this.heldItemOnPreview = currentHeldItemStack.m_41720_();
            }
        }
        int hydration = this.thirstCap.getHydrationLevel();
        float saturation = this.thirstCap.getSaturationLevel();
        boolean hasThirstEffect = player.m_21023_((MobEffect)MobEffectRegistry.THIRST.get());
        boolean hasHeatThirstEffect = player.m_21023_((MobEffect)MobEffectRegistry.HEAT_THIRST.get());
        if (Config.Baked.showVanillaBarAnimationOverlay && saturation <= 0.0f && player.f_19797_ % (hydration * 3 + 1) == 0) {
            this.blinkTime = 2;
        }
        if (this.blinkTime > 0) {
            --this.blinkTime;
        }
        SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
        parameters.capacity = 20.0;
        parameters.value = hydration;
        parameters.fillColor = -12731929;
        parameters.boundColor = -16177870;
        parameters.emptyColor = -16107952;
        parameters.valueIncrement = (double)Math.max(0.0f, (float)this.heldItemHydration) / parameters.capacity;
        if (hasThirstEffect) {
            parameters.fillColor = -7340490;
            parameters.boundColor = -15651060;
            parameters.emptyColor = -14598119;
        }
        if (hasHeatThirstEffect) {
            parameters.fillColor2 = hasThirstEffect ? -3481590 : -1405931;
        }
        if (Config.Baked.thirstSaturationDisplayed) {
            parameters.boundValue = saturation;
            parameters.boundCapacity = 20.0;
            parameters.boundFillColor = -9896194;
            parameters.boundValueIncrement = Math.max(0.0, (double)this.heldItemSaturation / parameters.boundCapacity);
            if (this.heldItemThirst) {
                parameters.boundColor2 = hasHeatThirstEffect ? -43990 : -983705;
            }
        }
        return parameters;
    }

    @Override
    protected boolean shouldRender(Player player) {
        return AsteorBar.config.hookLegendarySurvivalOverhaul() && Config.Baked.thirstEnabled;
    }
}

