/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Matrix4f;

public class GuiHelper {
    public static void drawTexturedRect(GuiGraphics guiGraphics, int left, int top, int textureX, int textureY, int width, int height) {
        GuiHelper.drawTexturedRect(guiGraphics, left, top, left + width, top + height, textureX, textureY, textureX + width, textureY + height, 256, 256);
    }

    public static void drawTexturedRectColor(GuiGraphics guiGraphics, int left, int top, int textureX, int textureY, int width, int height, int color) {
        GuiHelper.drawTexturedRectColor(guiGraphics, left, top, left + width, top + height, textureX, textureY, textureX + width, textureY + height, 256, 256, color);
    }

    public static void drawTexturedRect(GuiGraphics guiGraphics, int left, int top, int right, int bottom, float uvLeft, float uvTop, float uvRight, float uvBottom, int textureWidth, int textureHeight) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        boolean z = false;
        float uv_left = uvLeft / (float)textureWidth;
        float uv_top = uvTop / (float)textureHeight;
        float uv_right = uvRight / (float)textureWidth;
        float uv_bottom = uvBottom / (float)textureHeight;
        builder.m_252986_(matrix, (float)left, (float)top, (float)z).m_7421_(uv_left, uv_top).m_5752_();
        builder.m_252986_(matrix, (float)left, (float)bottom, (float)z).m_7421_(uv_left, uv_bottom).m_5752_();
        builder.m_252986_(matrix, (float)right, (float)bottom, (float)z).m_7421_(uv_right, uv_bottom).m_5752_();
        builder.m_252986_(matrix, (float)right, (float)top, (float)z).m_7421_(uv_right, uv_top).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void drawTexturedRectColor(GuiGraphics guiGraphics, int left, int top, int right, int bottom, float uvLeft, float uvTop, float uvRight, float uvBottom, int textureWidth, int textureHeight, int color) {
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.enableBlend();
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        float uv_left = uvLeft / (float)textureWidth;
        float uv_top = uvTop / (float)textureHeight;
        float uv_right = uvRight / (float)textureWidth;
        float uv_bottom = uvBottom / (float)textureHeight;
        builder.m_252986_(matrix, (float)left, (float)top, 0.0f).m_193479_(color).m_7421_(uv_left, uv_top).m_5752_();
        builder.m_252986_(matrix, (float)left, (float)bottom, 0.0f).m_193479_(color).m_7421_(uv_left, uv_bottom).m_5752_();
        builder.m_252986_(matrix, (float)right, (float)bottom, 0.0f).m_193479_(color).m_7421_(uv_right, uv_bottom).m_5752_();
        builder.m_252986_(matrix, (float)right, (float)top, 0.0f).m_193479_(color).m_7421_(uv_right, uv_top).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void drawSolidColor(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int color) {
        guiGraphics.m_280509_(left, top, right, bottom, color);
    }

    public static void drawString(GuiGraphics guiGraphics, String string, int left, int top, int color) {
        GuiHelper.drawString(guiGraphics, string, left, top, color, true);
    }

    public static void drawString(GuiGraphics guiGraphics, String string, int left, int top, int color, boolean shadow) {
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, string, left, top, color, shadow);
    }

    public static void drawSolidGradient(PoseStack poseStack, int left, int top, int right, int bottom, int color) {
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.enableBlend();
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        GuiHelper.renderSolidGradient((VertexConsumer)builder, poseStack, left, top, right, bottom, color, 0.0f);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void drawSolidGradientUpDown(PoseStack poseStack, int left, int top, int right, int bottom, int color) {
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.enableBlend();
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        GuiHelper.renderSolidGradientUpDown((VertexConsumer)builder, poseStack, left, top, right, bottom, color, 0.0f);
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
        RenderSystem.disableBlend();
    }

    public static void renderBound(VertexConsumer vertexConsumer, PoseStack poseStack, int left, int top, int right, int bottom, int width, int boundWidth, int colorFill, int colorEmpty, boolean vertex, float z) {
        int part;
        int expand;
        int cut = 0;
        int n = expand = vertex ? boundWidth : 0;
        if (width > 0) {
            part = Math.min(width, boundWidth);
            cut += part;
            GuiHelper.renderSolid(vertexConsumer, poseStack, left - boundWidth, top - expand, left - boundWidth + part, bottom + expand, colorFill, z);
            if (part < boundWidth) {
                GuiHelper.renderSolid(vertexConsumer, poseStack, left - boundWidth + part, top - expand, left, bottom + expand, colorEmpty, z);
            }
        } else {
            GuiHelper.renderSolid(vertexConsumer, poseStack, left - boundWidth, top - expand, left, bottom + expand, colorEmpty, z);
        }
        if (width > right - left + boundWidth) {
            part = Math.min(width, boundWidth);
            cut += part;
            GuiHelper.renderSolid(vertexConsumer, poseStack, right, top - expand, right + part, bottom + expand, colorFill, z);
            if (part < boundWidth) {
                GuiHelper.renderSolid(vertexConsumer, poseStack, right + part, top - expand, right + boundWidth, bottom + expand, colorEmpty, z);
            }
        } else {
            GuiHelper.renderSolid(vertexConsumer, poseStack, right, top - expand, right + boundWidth, bottom + expand, colorEmpty, z);
        }
        if ((width -= cut) > 0) {
            GuiHelper.renderSolid(vertexConsumer, poseStack, left, top - boundWidth, left + width, top, colorFill, z);
            GuiHelper.renderSolid(vertexConsumer, poseStack, left, bottom, left + width, bottom + boundWidth, colorFill, z);
        }
        if (width < right - left) {
            GuiHelper.renderSolid(vertexConsumer, poseStack, left + width, top - boundWidth, right, top, colorEmpty, z);
            GuiHelper.renderSolid(vertexConsumer, poseStack, left + width, bottom, right, bottom + boundWidth, colorEmpty, z);
        }
    }

    public static void renderSolid(VertexConsumer vertexConsumer, PoseStack poseStack, int left, int top, int right, int bottom, int color, float z) {
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)left, (float)top, z).m_193479_(color).m_7421_(0.0f, 0.0f).m_85969_(0xFF00FF).m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)left, (float)bottom, z).m_193479_(color).m_7421_(0.0f, 0.125f).m_85969_(0xFF00FF).m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)right, (float)bottom, z).m_193479_(color).m_7421_(1.0f, 0.125f).m_85969_(0xFF00FF).m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)right, (float)top, z).m_193479_(color).m_7421_(1.0f, 0.0f).m_85969_(0xFF00FF).m_5752_();
    }

    public static void renderSolidGradient(VertexConsumer vertexConsumer, PoseStack poseStack, int left, int top, int right, int bottom, int color, float z) {
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)left, (float)top, z).m_193479_(color).m_7421_(0.0f, 0.625f).m_85969_(0xFF00FF).m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)left, (float)bottom, z).m_193479_(color).m_7421_(0.0f, 1.0f).m_85969_(0xFF00FF).m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)right, (float)bottom, z).m_193479_(color).m_7421_(1.0f, 1.0f).m_85969_(0xFF00FF).m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)right, (float)top, z).m_193479_(color).m_7421_(1.0f, 0.625f).m_85969_(0xFF00FF).m_5752_();
    }

    public static void renderSolidGradientUpDown(VertexConsumer vertexConsumer, PoseStack poseStack, int left, int top, int right, int bottom, int color, float z) {
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)left, (float)top, z).m_193479_(color).m_7421_(0.0f, 0.0f).m_85969_(0xFF00FF).m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)left, (float)bottom, z).m_193479_(color).m_7421_(0.0f, 0.375f).m_85969_(0xFF00FF).m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)right, (float)bottom, z).m_193479_(color).m_7421_(1.0f, 0.375f).m_85969_(0xFF00FF).m_5752_();
        vertexConsumer.m_252986_(poseStack.m_85850_().m_252922_(), (float)right, (float)top, z).m_193479_(color).m_7421_(1.0f, 0.0f).m_85969_(0xFF00FF).m_5752_();
    }

    public static void renderString(PoseStack poseStack, MultiBufferSource buffer, String string, float left, float top, int color, boolean shadow) {
        Minecraft.m_91087_().f_91062_.m_271703_(string, left, top, color, shadow, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void renderString(PoseStack poseStack, MultiBufferSource buffer, String string, int left, int top, int color) {
        GuiHelper.renderString(poseStack, buffer, string, left, top, color, false);
    }

    public static void renderCenteredString(PoseStack poseStack, MultiBufferSource buffer, String string, int left, int top, int color) {
        GuiHelper.renderString(poseStack, buffer, string, (float)left - (float)Minecraft.m_91087_().f_91062_.m_92895_(string) / 2.0f, top, color, false);
    }

    public static void renderStringShadow(PoseStack poseStack, MultiBufferSource buffer, String string, int left, int top, int color) {
        GuiHelper.renderString(poseStack, buffer, string, left, top, color, true);
    }

    public static void renderCenteredStringShadow(PoseStack poseStack, MultiBufferSource buffer, String string, int left, int top, int color) {
        GuiHelper.renderString(poseStack, buffer, string, (float)left - (float)Minecraft.m_91087_().f_91062_.m_92895_(string) / 2.0f, top, color, true);
    }
}

