/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Matrix4f;

public class GuiHelper {
    public static void drawTexturedRect(GuiGraphics guiGraphics, int left, int top, int textureX, int textureY, int width, int height) {
        GuiHelper.drawTexturedRect(guiGraphics, left, top, left + width, top + height, textureX, textureY, textureX + width, textureY + height, 256, 256);
    }

    public static void drawTexturedRectColor(GuiGraphics guiGraphics, int left, int top, int textureX, int textureY, int width, int height, int color) {
        GuiHelper.drawTexturedRectColor(guiGraphics, left, top, left + width, top + height, textureX, textureY, textureX + width, textureY + height, 256, 256, color);
    }

    public static void drawTexturedRect(GuiGraphics guiGraphics, int left, int top, int right, int bottom, float uvLeft, float uvTop, float uvRight, float uvBottom, int textureWidth, int textureHeight) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.enableBlend();
        BufferBuilder builder = Tesselator.getInstance().getBuilder();
        builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        Matrix4f matrix = guiGraphics.pose().last().pose();
        boolean z = false;
        float uv_left = uvLeft / (float)textureWidth;
        float uv_top = uvTop / (float)textureHeight;
        float uv_right = uvRight / (float)textureWidth;
        float uv_bottom = uvBottom / (float)textureHeight;
        builder.vertex(matrix, (float)left, (float)top, (float)z).uv(uv_left, uv_top).endVertex();
        builder.vertex(matrix, (float)left, (float)bottom, (float)z).uv(uv_left, uv_bottom).endVertex();
        builder.vertex(matrix, (float)right, (float)bottom, (float)z).uv(uv_right, uv_bottom).endVertex();
        builder.vertex(matrix, (float)right, (float)top, (float)z).uv(uv_right, uv_top).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)builder.end());
        RenderSystem.disableBlend();
    }

    public static void drawTexturedRectColor(GuiGraphics guiGraphics, int left, int top, int right, int bottom, float uvLeft, float uvTop, float uvRight, float uvBottom, int textureWidth, int textureHeight, int color) {
        RenderSystem.setShader(GameRenderer::getPositionColorTexShader);
        RenderSystem.enableBlend();
        BufferBuilder builder = Tesselator.getInstance().getBuilder();
        builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX);
        Matrix4f matrix = guiGraphics.pose().last().pose();
        float uv_left = uvLeft / (float)textureWidth;
        float uv_top = uvTop / (float)textureHeight;
        float uv_right = uvRight / (float)textureWidth;
        float uv_bottom = uvBottom / (float)textureHeight;
        builder.vertex(matrix, (float)left, (float)top, 0.0f).color(color).uv(uv_left, uv_top).endVertex();
        builder.vertex(matrix, (float)left, (float)bottom, 0.0f).color(color).uv(uv_left, uv_bottom).endVertex();
        builder.vertex(matrix, (float)right, (float)bottom, 0.0f).color(color).uv(uv_right, uv_bottom).endVertex();
        builder.vertex(matrix, (float)right, (float)top, 0.0f).color(color).uv(uv_right, uv_top).endVertex();
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)builder.end());
        RenderSystem.disableBlend();
    }

    public static void drawSolidColor(GuiGraphics guiGraphics, int left, int top, int right, int bottom, int color) {
        guiGraphics.fill(left, top, right, bottom, color);
    }

    public static void drawString(GuiGraphics guiGraphics, String string, int left, int top, int color) {
        GuiHelper.drawString(guiGraphics, string, left, top, color, true);
    }

    public static void drawString(GuiGraphics guiGraphics, String string, int left, int top, int color, boolean shadow) {
        guiGraphics.drawString(Minecraft.getInstance().font, string, left, top, color, shadow);
    }

    public static void drawSolidGradient(PoseStack poseStack, int left, int top, int right, int bottom, int color) {
        RenderSystem.setShader(GameRenderer::getPositionColorTexShader);
        RenderSystem.enableBlend();
        BufferBuilder builder = Tesselator.getInstance().getBuilder();
        builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX);
        GuiHelper.renderSolidGradient((VertexConsumer)builder, poseStack, left, top, right, bottom, color, 0.0f);
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)builder.end());
        RenderSystem.disableBlend();
    }

    public static void drawSolidGradientUpDown(PoseStack poseStack, int left, int top, int right, int bottom, int color) {
        RenderSystem.setShader(GameRenderer::getPositionColorTexShader);
        RenderSystem.enableBlend();
        BufferBuilder builder = Tesselator.getInstance().getBuilder();
        builder.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR_TEX);
        GuiHelper.renderSolidGradientUpDown((VertexConsumer)builder, poseStack, left, top, right, bottom, color, 0.0f);
        BufferUploader.drawWithShader((BufferBuilder.RenderedBuffer)builder.end());
        RenderSystem.disableBlend();
    }

    public static void renderBound(VertexConsumer vertexConsumer, PoseStack poseStack, int left, int top, int right, int bottom, int width, int boundWidth, int colorFill, int colorEmpty, boolean vertex, float z) {
        int part;
        int expand;
        int cut = 0;
        int n = expand = vertex ? boundWidth : 0;
        if (width > 0) {
            part = Math.min(width, boundWidth);
            cut += part;
            GuiHelper.renderSolid(vertexConsumer, poseStack, left - boundWidth, top - expand, left - boundWidth + part, bottom + expand, colorFill, z);
            if (part < boundWidth) {
                GuiHelper.renderSolid(vertexConsumer, poseStack, left - boundWidth + part, top - expand, left, bottom + expand, colorEmpty, z);
            }
        } else {
            GuiHelper.renderSolid(vertexConsumer, poseStack, left - boundWidth, top - expand, left, bottom + expand, colorEmpty, z);
        }
        if (width > right - left + boundWidth) {
            part = Math.min(width, boundWidth);
            cut += part;
            GuiHelper.renderSolid(vertexConsumer, poseStack, right, top - expand, right + part, bottom + expand, colorFill, z);
            if (part < boundWidth) {
                GuiHelper.renderSolid(vertexConsumer, poseStack, right + part, top - expand, right + boundWidth, bottom + expand, colorEmpty, z);
            }
        } else {
            GuiHelper.renderSolid(vertexConsumer, poseStack, right, top - expand, right + boundWidth, bottom + expand, colorEmpty, z);
        }
        if ((width -= cut) > 0) {
            GuiHelper.renderSolid(vertexConsumer, poseStack, left, top - boundWidth, left + width, top, colorFill, z);
            GuiHelper.renderSolid(vertexConsumer, poseStack, left, bottom, left + width, bottom + boundWidth, colorFill, z);
        }
        if (width < right - left) {
            GuiHelper.renderSolid(vertexConsumer, poseStack, left + width, top - boundWidth, right, top, colorEmpty, z);
            GuiHelper.renderSolid(vertexConsumer, poseStack, left + width, bottom, right, bottom + boundWidth, colorEmpty, z);
        }
    }

    public static void renderSolid(VertexConsumer vertexConsumer, PoseStack poseStack, int left, int top, int right, int bottom, int color, float z) {
        vertexConsumer.vertex(poseStack.last().pose(), (float)left, (float)top, z).color(color).uv(0.0f, 0.0f).uv2(0xFF00FF).endVertex();
        vertexConsumer.vertex(poseStack.last().pose(), (float)left, (float)bottom, z).color(color).uv(0.0f, 0.125f).uv2(0xFF00FF).endVertex();
        vertexConsumer.vertex(poseStack.last().pose(), (float)right, (float)bottom, z).color(color).uv(1.0f, 0.125f).uv2(0xFF00FF).endVertex();
        vertexConsumer.vertex(poseStack.last().pose(), (float)right, (float)top, z).color(color).uv(1.0f, 0.0f).uv2(0xFF00FF).endVertex();
    }

    public static void renderSolidGradient(VertexConsumer vertexConsumer, PoseStack poseStack, int left, int top, int right, int bottom, int color, float z) {
        vertexConsumer.vertex(poseStack.last().pose(), (float)left, (float)top, z).color(color).uv(0.0f, 0.625f).uv2(0xFF00FF).endVertex();
        vertexConsumer.vertex(poseStack.last().pose(), (float)left, (float)bottom, z).color(color).uv(0.0f, 1.0f).uv2(0xFF00FF).endVertex();
        vertexConsumer.vertex(poseStack.last().pose(), (float)right, (float)bottom, z).color(color).uv(1.0f, 1.0f).uv2(0xFF00FF).endVertex();
        vertexConsumer.vertex(poseStack.last().pose(), (float)right, (float)top, z).color(color).uv(1.0f, 0.625f).uv2(0xFF00FF).endVertex();
    }

    public static void renderSolidGradientUpDown(VertexConsumer vertexConsumer, PoseStack poseStack, int left, int top, int right, int bottom, int color, float z) {
        vertexConsumer.vertex(poseStack.last().pose(), (float)left, (float)top, z).color(color).uv(0.0f, 0.0f).uv2(0xFF00FF).endVertex();
        vertexConsumer.vertex(poseStack.last().pose(), (float)left, (float)bottom, z).color(color).uv(0.0f, 0.375f).uv2(0xFF00FF).endVertex();
        vertexConsumer.vertex(poseStack.last().pose(), (float)right, (float)bottom, z).color(color).uv(1.0f, 0.375f).uv2(0xFF00FF).endVertex();
        vertexConsumer.vertex(poseStack.last().pose(), (float)right, (float)top, z).color(color).uv(1.0f, 0.0f).uv2(0xFF00FF).endVertex();
    }

    public static void renderString(PoseStack poseStack, MultiBufferSource buffer, String string, float left, float top, int color, boolean shadow) {
        Minecraft.getInstance().font.drawInBatch(string, left, top, color, shadow, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public static void renderString(PoseStack poseStack, MultiBufferSource buffer, String string, int left, int top, int color) {
        GuiHelper.renderString(poseStack, buffer, string, left, top, color, false);
    }

    public static void renderCenteredString(PoseStack poseStack, MultiBufferSource buffer, String string, int left, int top, int color) {
        GuiHelper.renderString(poseStack, buffer, string, (float)left - (float)Minecraft.getInstance().font.width(string) / 2.0f, top, color, false);
    }

    public static void renderStringShadow(PoseStack poseStack, MultiBufferSource buffer, String string, int left, int top, int color) {
        GuiHelper.renderString(poseStack, buffer, string, left, top, color, true);
    }

    public static void renderCenteredStringShadow(PoseStack poseStack, MultiBufferSource buffer, String string, int left, int top, int color) {
        GuiHelper.renderString(poseStack, buffer, string, (float)left - (float)Minecraft.getInstance().font.width(string) / 2.0f, top, color, true);
    }
}

