/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.RenderGui;
import com.afoxxvi.asteorbar.overlay.parts.BaseOverlay;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.afoxxvi.asteorbar.utils.GuiHelper;
import com.afoxxvi.asteorbar.utils.Utils;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.apoli.component.PowerHolderComponent;
import io.github.apace100.apoli.power.HudRendered;
import io.github.apace100.apoli.util.HudRender;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_746;

public class OriginsOverlay
extends BaseOverlay {
    private SimpleBarOverlay subOverlay = null;
    private static final int BAR_WIDTH = 71;
    private static final int BAR_HEIGHT = 8;
    private static final int ICON_SIZE = 8;
    private static final int BAR_INDEX_OFFSET = 10;
    private static final int ICON_INDEX_OFFSET = 9;

    @Override
    public void renderOverlay(RenderGui gui, class_332 guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        if (!AsteorBar.compatibility.apoli || !AsteorBar.config.hookApoli()) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        List<HudRendered> hudPowers = ((PowerHolderComponent)PowerHolderComponent.KEY.get((Object)player)).getPowers().stream().filter(p -> p instanceof HudRendered).map(p -> (HudRendered)p).sorted(Comparator.comparing(hudRenderedA -> hudRenderedA.getRenderSettings().getSpriteLocation())).toList();
        for (HudRendered hudRendered : hudPowers) {
            HudRender hudRender = hudRendered.getRenderSettings();
            if (!hudRender.shouldRender((class_1657)player) || !hudRendered.shouldRender()) continue;
            if (this.subOverlay == null) {
                this.subOverlay = new OriginSimpleBar();
            }
            OriginSimpleBar originSimpleBar = (OriginSimpleBar)this.subOverlay;
            originSimpleBar.hudRender = hudRender;
            originSimpleBar.hudRendered = hudRendered;
            this.subOverlay.render(gui, guiGraphics, partialTick, screenWidth, screenHeight);
        }
    }

    private static class OriginSimpleBar
    extends SimpleBarOverlay {
        protected HudRender hudRender;
        protected HudRendered hudRendered;

        private OriginSimpleBar() {
        }

        private static int getFillColor(int index) {
            switch (index) {
                case 0: {
                    return -3699591;
                }
                case 1: {
                    return -13082625;
                }
                case 2: {
                    return -327883;
                }
                case 3: {
                    return -52246;
                }
                case 4: 
                case 5: {
                    return -1;
                }
                case 6: {
                    return -10449553;
                }
                case 7: {
                    return -14768;
                }
                case 8: {
                    return -13397721;
                }
            }
            return -2039584;
        }

        @Override
        protected SimpleBarOverlay.Parameters getParameters(class_1657 player) {
            if (this.hudRendered == null || this.hudRender == null || (double)this.hudRendered.getFill() == 0.0) {
                return null;
            }
            SimpleBarOverlay.Parameters parameters = new SimpleBarOverlay.Parameters();
            parameters.value = this.hudRendered.getFill();
            parameters.capacity = 1.0;
            parameters.fillColor = OriginSimpleBar.getFillColor(this.hudRender.getBarIndex());
            parameters.boundColor = Utils.mixColor(-16777216, parameters.fillColor, 0.5);
            parameters.emptyColor = -14668763;
            return parameters;
        }

        @Override
        protected void drawDecorations(class_332 guiGraphics, int left, int top, int right, int bottom, SimpleBarOverlay.Parameters parameters, boolean flip) {
            int barV = 8 + this.hudRender.getBarIndex() * 10;
            RenderSystem.setShaderTexture((int)0, (class_2960)this.hudRender.getSpriteLocation());
            GuiHelper.drawTexturedRect(guiGraphics, (right + left) / 2 - 4, (top + bottom) / 2 - 4, 73, barV, 8, 8);
            RenderSystem.setShaderTexture((int)0, (class_2960)LIGHTMAP_TEXTURE);
        }

        @Override
        protected boolean shouldRender(class_1657 player) {
            return true;
        }
    }
}

