/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.overlay.parts.compat;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.overlay.Overlays;
import com.afoxxvi.asteorbar.overlay.parts.SimpleBarOverlay;
import com.afoxxvi.asteorbar.utils.PlatformAdapter;
import java.util.function.BiConsumer;
import net.minecraft.class_1657;
import net.minecraft.class_1702;

public class AppleSkinCompat {
    private static final BiConsumer<class_1657, SimpleBarOverlay.Parameters> APPLE_SKIN_HEALTH_POST_PROCESSOR = (player, parameters) -> {
        float maxHealth = player.method_6063();
        float health = player.method_6032();
        float absorb = player.method_6067();
        double healthIncrement = 0.0;
        if (AsteorBar.compatibility.appleskin) {
            PlatformAdapter.AppleSkinFoodValues foodValues = AsteorBar.platformAdapter.getAppleSkinFoodValues((class_1657)player);
            if (foodValues != null) {
                healthIncrement = foodValues.healthIncrement();
            }
            healthIncrement = Math.min(healthIncrement, (double)(maxHealth - health));
        }
        int i = AsteorBar.config.displayAbsorptionMethod();
        if (AsteorBar.config.enableStackHealthBar()) {
            i = 2;
        }
        if (i == 0) {
            double full = maxHealth + absorb;
            parameters.valueIncrement = healthIncrement / full;
        } else if (AsteorBar.config.enableStackHealthBar()) {
            int unit = AsteorBar.config.fullHealthValue();
            if (healthIncrement > 0.0 && health < maxHealth) {
                if ((double)(health % (float)unit) + healthIncrement >= (double)unit) {
                    parameters.valueIncrement = 1.0 - parameters.value;
                    parameters.secondValueIncrement = (parameters.value + healthIncrement / (double)unit) % 1.0;
                } else {
                    healthIncrement = Math.min(healthIncrement, (double)(maxHealth - health));
                    parameters.valueIncrement = healthIncrement / (double)unit;
                }
            }
        } else if (healthIncrement > 0.0 && health < maxHealth) {
            parameters.valueIncrement = Math.min((double)(maxHealth - health), healthIncrement) / (double)maxHealth;
        }
    };
    private static final BiConsumer<class_1657, SimpleBarOverlay.Parameters> APPLE_SKIN_FOOD_POST_PROCESSOR = (player, parameters) -> {
        PlatformAdapter.AppleSkinFoodValues foodValues;
        class_1702 stats = player.method_7344();
        int level = stats.method_7586();
        float saturation = stats.method_7589();
        int foodIncrement = 0;
        float saturationIncrement = 0.0f;
        if (AsteorBar.compatibility.appleskin && (foodValues = AsteorBar.platformAdapter.getAppleSkinFoodValues((class_1657)player)) != null) {
            foodIncrement = foodValues.hungerIncrement();
            saturationIncrement = foodValues.saturationIncrement();
        }
        if (foodIncrement > 0 && level < AsteorBar.config.fullFoodLevelValue()) {
            int fullFood = AsteorBar.config.fullFoodLevelValue();
            parameters.valueIncrement = Math.min((double)(fullFood - level), (double)foodIncrement) / (double)fullFood;
        }
        if (AsteorBar.config.displaySaturation() && foodIncrement > 0 && saturationIncrement > 0.0f && (double)saturation < AsteorBar.config.fullSaturationValue()) {
            double fullSaturation = AsteorBar.config.fullSaturationValue();
            parameters.boundValueIncrement = Math.min(fullSaturation - (double)saturation, (double)saturationIncrement) / fullSaturation;
        }
    };
    private static boolean initialized = false;

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (!AsteorBar.compatibility.appleskin) {
            return;
        }
        Overlays.PLAYER_HEALTH.addParametersProcessor("afoxxvi:apple_skin", APPLE_SKIN_HEALTH_POST_PROCESSOR);
        Overlays.FOOD_LEVEL.addParametersProcessor("afoxxvi:apple_skin", APPLE_SKIN_FOOD_POST_PROCESSOR);
    }
}

