/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.entity;

import com.afoxxvi.asteorbar.AsteorBar;
import com.afoxxvi.asteorbar.utils.GuiHelper;
import com.afoxxvi.asteorbar.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_746;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class EntityRenderer {
    public static final List<ExtraRenderer> EXTRA_RENDERERS = new ArrayList<ExtraRenderer>();
    public static final List<ExtraTextRenderer> EXTRA_TEXT_RENDERERS = new ArrayList<ExtraTextRenderer>();

    public static void extraRender(class_1309 entity, class_4587 poseStack, class_4597 multiBufferSource, float halfWidth, float halfHeight, float boundWidth) {
        EXTRA_RENDERERS.forEach(extraRenderer -> extraRenderer.render(entity, poseStack, multiBufferSource, halfWidth, halfHeight, boundWidth));
    }

    public static void extraTextRender(class_1309 entity, class_4587 poseStack, class_4597 multiBufferSource, float halfWidth, float halfHeight, float boundWidth, float textScale) {
        EXTRA_TEXT_RENDERERS.forEach(extraTextRenderer -> extraTextRenderer.render(entity, poseStack, multiBufferSource, halfWidth, halfHeight, boundWidth, textScale));
    }

    private static int check(class_1309 entity, class_1657 player) {
        if (entity.method_5767()) {
            return 1;
        }
        if ((double)entity.method_5739((class_1297)player) > AsteorBar.config.maxDistance()) {
            return 2;
        }
        if (entity.method_5756(player)) {
            return 3;
        }
        if (entity.method_7325()) {
            return 4;
        }
        if (!AsteorBar.config.showOnSelf() && entity == player) {
            return 5;
        }
        if (!AsteorBar.config.showOnPlayers() && entity instanceof class_1657) {
            return 6;
        }
        if (!AsteorBar.config.showOnBosses() && AsteorBar.platformAdapter.isBoss(entity)) {
            return 7;
        }
        if (!AsteorBar.config.showOnArmorStands() && entity instanceof class_1531) {
            return 11;
        }
        if (entity.method_6063() == entity.method_6032()) {
            if (!AsteorBar.config.showOnFullHealthWithAbsorption() && entity.method_6067() > 0.0f) {
                return 8;
            }
            if (!AsteorBar.config.showOnFullHealthWithoutAbsorption() && entity.method_6067() == 0.0f) {
                return 9;
            }
        }
        if (!entity.method_6057((class_1297)player)) {
            return 10;
        }
        return 0;
    }

    private static int modifyAlpha(int color, int alpha) {
        if (alpha == 0) {
            return color;
        }
        int newAlpha = (color >> 24) * alpha / 255;
        return color & 0xFFFFFF | newAlpha << 24;
    }

    public static void render(class_1309 entity, class_4587 poseStack, class_4597 multiBufferSource) {
        Object absStr;
        double absorptionNum;
        int absorptionWidth;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        int check = EntityRenderer.check(entity, (class_1657)player);
        if (check > 0) {
            return;
        }
        float dist = entity.method_5739((class_1297)player);
        float layerDist = Math.max(0.002f, dist * 0.002f);
        int alpha = AsteorBar.config.healthBarAlpha();
        poseStack.method_22903();
        poseStack.method_22904(0.0, (double)entity.method_17682() + AsteorBar.config.healthBarOffsetY(), 0.0);
        Vector3f cameraEuler = class_310.method_1551().method_1561().method_24197().getEulerAnglesXYZ(new Vector3f());
        poseStack.method_22907(new Quaternionf().rotationXYZ(0.0f, (float)Math.PI, 0.0f));
        poseStack.method_22907(new Quaternionf().rotationXYZ(-cameraEuler.x, cameraEuler.y, -cameraEuler.z));
        poseStack.method_22903();
        float scale = (float)AsteorBar.config.healthBarScale();
        int halfWidth = AsteorBar.config.healthBarHalfWidth();
        int halfHeight = AsteorBar.config.healthBarHalfHeight();
        poseStack.method_22905(-scale, -scale, scale);
        class_4588 bufferBuilder = multiBufferSource.getBuffer(AsteorBar.platformAdapter.getRenderType());
        double healthRate = Math.min((double)(entity.method_6032() / entity.method_6063()), 1.0);
        int healthWidth = (int)((double)(halfWidth * 2) * healthRate);
        int colorHealth = AsteorBar.config.healthBarHealthColorDynamic() ? Utils.mixColor(AsteorBar.config.healthBarHealthColorFull(), AsteorBar.config.healthBarHealthColorEmpty(), healthRate) : AsteorBar.config.healthBarHealthColor();
        colorHealth = EntityRenderer.modifyAlpha(colorHealth, alpha);
        int colorEmpty = EntityRenderer.modifyAlpha(AsteorBar.config.healthBarEmptyColor(), alpha);
        if (healthWidth > 0) {
            GuiHelper.renderSolidGradient(bufferBuilder, poseStack, -halfWidth, -halfHeight, -halfWidth + healthWidth, halfHeight, colorHealth, layerDist);
        }
        if (healthWidth < 2 * halfWidth) {
            GuiHelper.renderSolidGradientUpDown(bufferBuilder, poseStack, -halfWidth + healthWidth, -halfHeight, halfWidth, halfHeight, colorEmpty, layerDist);
        }
        int renderAbsorptionMultiplier = -1;
        int boundWidth = AsteorBar.config.healthBarBoundWidth();
        int colorAbsorption = EntityRenderer.modifyAlpha(AsteorBar.config.healthBarAbsorptionColor(), alpha);
        int colorBound = EntityRenderer.modifyAlpha(AsteorBar.config.healthBarBoundColor(), alpha);
        boolean includeVertex = AsteorBar.config.healthBarBoundVertex();
        float absorptionRate = entity.method_6067() / entity.method_6063();
        if ((absorptionWidth = Math.round((float)(halfWidth * 2 + boundWidth * 2) * (absorptionRate -= (float)(absorptionNum = Math.floor(absorptionRate))))) == 0 && absorptionNum > 0.0) {
            absorptionWidth = 2 * halfWidth + boundWidth * 2;
            absorptionNum -= 1.0;
        }
        GuiHelper.renderBound(bufferBuilder, poseStack, -halfWidth, -halfHeight, halfWidth, halfHeight, absorptionWidth, boundWidth, colorAbsorption, colorBound, includeVertex, layerDist);
        if (absorptionNum * 2.0 * (double)boundWidth > (double)halfWidth) {
            renderAbsorptionMultiplier = (int)absorptionNum;
        } else {
            int expand = includeVertex ? boundWidth : 0;
            int i = 0;
            while ((double)i < absorptionNum) {
                GuiHelper.renderSolid(bufferBuilder, poseStack, -halfWidth - expand + i * boundWidth * 2, halfHeight + boundWidth * 2, -halfWidth - expand + i * boundWidth * 2 + boundWidth, halfHeight + boundWidth * 3, colorAbsorption, layerDist);
                ++i;
            }
        }
        EntityRenderer.extraRender(entity, poseStack, multiBufferSource, halfWidth, halfHeight, boundWidth);
        float textScale = (float)AsteorBar.config.healthBarTextScale();
        double textOffset = AsteorBar.config.healthBarTextOffsetY();
        poseStack.method_22903();
        poseStack.method_22904(0.0, textOffset, 0.0);
        poseStack.method_22905(textScale, textScale, textScale);
        class_327 font = class_310.method_1551().field_1772;
        String healthStr = Utils.formatNumber(entity.method_6032()) + "/" + Utils.formatNumber(entity.method_6063());
        GuiHelper.renderCenteredString(poseStack, multiBufferSource, healthStr, 0, 0, 0xFFFFFF);
        if (entity.method_6067() > 0.0f) {
            absStr = Utils.formatNumber(entity.method_6067());
            GuiHelper.renderString(poseStack, multiBufferSource, (String)absStr, (int)((float)(-halfWidth + 1) / textScale), 0, 0xFFFF00);
        }
        if (renderAbsorptionMultiplier > 0) {
            absStr = renderAbsorptionMultiplier + "\u00d7";
            GuiHelper.renderString(poseStack, multiBufferSource, (String)absStr, (int)((float)(-halfWidth - 1 - font.method_1727((String)absStr)) / textScale), 0, 0xFFFF00);
        }
        EntityRenderer.extraTextRender(entity, poseStack, multiBufferSource, halfWidth, halfHeight, boundWidth, textScale);
        poseStack.method_22909();
        poseStack.method_22909();
        poseStack.method_22909();
    }

    public static interface ExtraTextRenderer {
        public void render(class_1309 var1, class_4587 var2, class_4597 var3, float var4, float var5, float var6, float var7);
    }

    public static interface ExtraRenderer {
        public void render(class_1309 var1, class_4587 var2, class_4597 var3, float var4, float var5, float var6);
    }
}

