/*
 * Decompiled with CFR 0.152.
 */
package com.afoxxvi.asteorbar.network;

import com.afoxxvi.asteorbar.AsteorBar;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8705;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import toughasnails.api.thirst.IThirst;
import toughasnails.api.thirst.ThirstHelper;

public class NetworkHandler {
    private static boolean initialized = false;
    private static final class_2960 CHANNEL = class_2960.method_60655((String)"asteorbar", (String)"network");
    private static final int INDEX_EXHAUSTION = 0;
    private static final int INDEX_SATURATION = 1;
    private static final int INDEX_ABSORPTION = 2;
    private static final int INDEX_ACTIVATE = 3;
    private static final int INDEX_TOUGH_AS_NAILS = 64;
    private static final Map<UUID, Float> EXHAUSTION = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> SATURATION = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> TOUGH_AS_NAILS_HYDRATION = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> TOUGH_AS_NAILS_EXHAUSTION = new HashMap<UUID, Float>();

    @Environment(value=EnvType.CLIENT)
    public static void init() {
        PayloadTypeRegistry.playS2C().register(NetworkPayload.ID, NetworkPayload.PAYLOAD_CODEC);
        ClientPlayNetworking.registerGlobalReceiver(NetworkPayload.ID, (payload, context) -> {
            class_2540 buf = payload.buf;
            byte index = buf.readByte();
            class_310 client = context.client();
            switch (index) {
                case 0: {
                    float exhaustion = payload.buf().readFloat();
                    client.execute(() -> {
                        if (client.field_1724 != null) {
                            AsteorBar.platformAdapter.setExhaustion((class_1657)client.field_1724, exhaustion);
                        }
                    });
                    break;
                }
                case 1: {
                    float saturation = payload.buf().readFloat();
                    client.execute(() -> {
                        if (client.field_1724 != null) {
                            client.field_1724.method_7344().method_7581(saturation);
                        }
                    });
                    break;
                }
                case 2: {
                    int entityId = buf.readInt();
                    float absorption = buf.readFloat();
                    client.execute(() -> {
                        class_1297 entity;
                        if (client.field_1687 != null && (entity = client.field_1687.method_8469(entityId)) instanceof class_1309) {
                            class_1309 livingEntity = (class_1309)entity;
                            livingEntity.method_6073(absorption);
                        }
                    });
                    break;
                }
                case 3: {
                    boolean activate = buf.readBoolean();
                    client.execute(() -> {
                        ByteBuf buffer = Unpooled.buffer((int)1).writeBoolean(activate);
                        ClientPlayNetworking.send((class_8710)new NetworkPayload(new class_2540(buffer)));
                    });
                    break;
                }
                case 64: {
                    float hydration = buf.readFloat();
                    float exhaustion = buf.readFloat();
                    client.execute(() -> {
                        if (client.field_1724 != null) {
                            IThirst thirst = ThirstHelper.getThirst((class_1657)client.field_1724);
                            thirst.setHydration(hydration);
                            thirst.setExhaustion(exhaustion);
                        }
                    });
                    break;
                }
            }
        });
    }

    public static void onPlayerTick(class_3222 player) {
        class_1702 foodStats = player.method_7344();
        float exhaustionLevel = AsteorBar.platformAdapter.getExhaustion((class_1657)player);
        Float oldExhaustion = EXHAUSTION.get(player.method_5667());
        if (oldExhaustion == null || Math.abs(oldExhaustion.floatValue() - exhaustionLevel) >= 0.01f) {
            EXHAUSTION.put(player.method_5667(), Float.valueOf(exhaustionLevel));
            class_2540 buf = PacketByteBufs.create().method_52997(0).method_52941(exhaustionLevel);
            ServerPlayNetworking.send((class_3222)player, (class_8710)new NetworkPayload(PacketByteBufs.duplicate((ByteBuf)buf)));
        }
        float saturationLevel = foodStats.method_7589();
        Float oldSaturation = SATURATION.get(player.method_5667());
        if (oldSaturation == null || Math.abs(oldSaturation.floatValue() - saturationLevel) >= 0.01f) {
            SATURATION.put(player.method_5667(), Float.valueOf(saturationLevel));
            class_2540 buf = PacketByteBufs.create().method_52997(1).method_52941(saturationLevel);
            ServerPlayNetworking.send((class_3222)player, (class_8710)new NetworkPayload(PacketByteBufs.duplicate((ByteBuf)buf)));
        }
        if (!initialized) {
            initialized = true;
            AsteorBar.compatibility.init();
        }
        if (AsteorBar.compatibility.toughAsNails) {
            IThirst thirst = ThirstHelper.getThirst((class_1657)player);
            boolean send = false;
            float hydration = thirst.getHydration();
            Float oldHydration = TOUGH_AS_NAILS_HYDRATION.get(player.method_5667());
            if (oldHydration == null || Math.abs(oldHydration.floatValue() - hydration) >= 0.01f) {
                TOUGH_AS_NAILS_HYDRATION.put(player.method_5667(), Float.valueOf(hydration));
                send = true;
            }
            float exhaustion = thirst.getExhaustion();
            Float oldToughAsNailsExhaustion = TOUGH_AS_NAILS_EXHAUSTION.get(player.method_5667());
            if (oldToughAsNailsExhaustion == null || Math.abs(oldToughAsNailsExhaustion.floatValue() - exhaustion) >= 0.01f) {
                TOUGH_AS_NAILS_EXHAUSTION.put(player.method_5667(), Float.valueOf(exhaustion));
                send = true;
            }
            if (send) {
                class_2540 buf = PacketByteBufs.create().method_52997(64).method_52941(hydration).method_52941(exhaustion);
                ServerPlayNetworking.send((class_3222)player, (class_8710)new NetworkPayload(PacketByteBufs.duplicate((ByteBuf)buf)));
            }
        }
    }

    public static class_2596<class_8705> createAbsorptionPacket(int entityId, float absorption) {
        class_2540 buf = PacketByteBufs.create().method_52997(2).method_53002(entityId).method_52941(absorption);
        return ServerPlayNetworking.createS2CPacket((class_8710)new NetworkPayload(PacketByteBufs.duplicate((ByteBuf)buf)));
    }

    public record NetworkPayload(class_2540 buf) implements class_8710
    {
        public static final class_9139<class_2540, NetworkPayload> PAYLOAD_CODEC = class_8710.method_56484(NetworkPayload::write, NetworkPayload::read);
        public static final class_8710.class_9154<NetworkPayload> ID = new class_8710.class_9154(CHANNEL);

        @NotNull
        public class_8710.class_9154<? extends class_8710> method_56479() {
            return ID;
        }

        public static NetworkPayload read(class_2540 friendlyByteBuf) {
            return new NetworkPayload(PacketByteBufs.create().method_52975((ByteBuf)friendlyByteBuf));
        }

        public void write(class_2540 friendlyByteBuf) {
            friendlyByteBuf.method_52975((ByteBuf)this.buf);
        }
    }
}

