/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.astronomy.dimension.world.data;

import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class FrozenStormSaveData
extends WorldSavedData {
    private boolean isStorm;
    public float prevStormStrength;
    public float stormStrength = 0.0f;
    public int tickStorm = 0;
    public int tickClearWeather = 120000;

    public FrozenStormSaveData(String name) {
        super(name);
    }

    public static FrozenStormSaveData get(World world, String name) {
        name = name + "_frozenstorm";
        MapStorage storage = world.getPerWorldStorage();
        FrozenStormSaveData instance = (FrozenStormSaveData)storage.func_75742_a(FrozenStormSaveData.class, name);
        if (instance == null) {
            instance = new FrozenStormSaveData(name);
            storage.func_75745_a(name, (WorldSavedData)instance);
        }
        return instance;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.isStorm = nbt.func_74767_n("isFrozenStorm");
        this.tickStorm = nbt.func_74762_e("tickFrozenStorm");
        this.tickClearWeather = nbt.func_74762_e("tickClearWeather");
        this.prevStormStrength = nbt.func_74760_g("prevStormStrength");
        this.stormStrength = nbt.func_74760_g("stormStrength");
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74757_a("isFrozenStorm", this.isStorm);
        compound.func_74768_a("tickFrozenStorm", this.tickStorm);
        compound.func_74768_a("tickClearWeather", this.tickClearWeather);
        compound.func_74776_a("prevStormStrength", this.prevStormStrength);
        compound.func_74776_a("stormStrength", this.stormStrength);
        return compound;
    }

    public float getStormStrength(float delta) {
        return this.prevStormStrength + (this.stormStrength - this.prevStormStrength) * delta;
    }

    public void setStormStrength(float delta) {
        this.stormStrength = delta;
    }

    public boolean isFrozenStorm() {
        return this.isStorm;
    }

    public void setFrozenStorm(boolean status) {
        this.isStorm = status;
    }

    public static void calculateWeather(FrozenStormSaveData data, Random rand) {
        int stormDust;
        data.prevStormStrength = data.stormStrength;
        if (!data.isFrozenStorm()) {
            int clearWeather;
            if ((clearWeather = data.tickClearWeather--) >= 0) {
                if (data.stormStrength > 0.0f) {
                    data.stormStrength = (float)((double)data.stormStrength - 0.01);
                }
                if (clearWeather <= 0) {
                    data.setFrozenStorm(true);
                    data.tickStorm = rand.nextInt(6000) + 12000;
                }
            }
        } else if ((stormDust = data.tickStorm--) >= 0) {
            data.stormStrength = (float)((double)data.stormStrength + 0.01);
            if (stormDust <= 0) {
                data.setFrozenStorm(false);
                data.tickClearWeather = rand.nextInt(168000) + 12000;
            }
        }
        data.stormStrength = MathHelper.func_76131_a((float)data.stormStrength, (float)0.0f, (float)1.0f);
        data.func_76185_a();
    }
}

