/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.event;

import asmodeuscore.api.dimension.IAdvancedSpace;
import asmodeuscore.api.space.IExBody;
import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.BodiesRegistry;
import asmodeuscore.core.astronomy.dimension.world.worldengine.WE_WorldProviderSpace;
import asmodeuscore.core.astronomy.gui.overlay.OverlayDetectors;
import asmodeuscore.core.astronomy.gui.screen.NewGuiCelestialSelection;
import asmodeuscore.core.astronomy.sky.CloudProviderBase;
import asmodeuscore.core.astronomy.sky.CustomCloudRender;
import asmodeuscore.core.astronomy.sky.galacticraft.SkyProviderAsteroids;
import asmodeuscore.core.astronomy.sky.galacticraft.SkyProviderMoon;
import asmodeuscore.core.astronomy.sky.galacticraft.SkyProviderOverworld;
import asmodeuscore.core.configs.AsmodeusConfig;
import asmodeuscore.core.event.PressureEvent;
import asmodeuscore.core.handler.ColorBlockHandler;
import asmodeuscore.core.utils.ACAttributePlayer;
import asmodeuscore.core.utils.ACCompatibilityManager;
import asmodeuscore.core.utils.Utils;
import asmodeuscore.core.utils.worldengine.WE_ChunkProvider;
import asmodeuscore.core.utils.worldengine.WE_PerlinNoise;
import asmodeuscore.core.utils.worldengine.WE_WorldProvider;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldProviderSpace;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderMoon;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStatsClient;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.venus.dimension.WorldProviderVenus;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AsmodeusClientEvent {
    public Minecraft mc = FMLClientHandler.instance().getClient();
    public static boolean inOxygenBlock = false;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenEvent(GuiOpenEvent event) {
        if (ACCompatibilityManager.isGalacticraftLoaded() && event.getGui() instanceof GuiCelestialSelection && AsmodeusConfig.enableNewGalaxyMap) {
            GameSettings cfr_ignored_0 = this.mc.field_71474_y;
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.galaxyMap)) {
                event.setGui((GuiScreen)new NewGuiCelestialSelection(true, null, false, null));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent e) {
        WorldClient world = this.mc.field_71441_e;
        if (world != null) {
            IRenderHandler clouds;
            if (world.field_73011_w.getCloudRenderer() instanceof CloudProviderBase && !this.mc.func_147113_T()) {
                clouds = (CloudProviderBase)world.field_73011_w.getCloudRenderer();
                clouds.cloudTicksPrev = clouds.cloudTicks;
                clouds.cloudTicks = (long)((float)clouds.cloudTicks + clouds.getCloudMovementSpeed((World)world));
            }
            if (world.field_73011_w.getCloudRenderer() instanceof CustomCloudRender && !this.mc.func_147113_T()) {
                clouds = (CustomCloudRender)world.field_73011_w.getCloudRenderer();
                clouds.cloudTicksPrev = clouds.cloudTicks;
                clouds.cloudTicks = (long)((float)clouds.cloudTicks + clouds.getCloudMovementSpeed(world));
            }
            if (world.field_73011_w.getDimension() == 0 && AsmodeusConfig.enableSkyOverworld && !(world.field_73011_w.getSkyRenderer() instanceof SkyProviderOverworld)) {
                world.field_73011_w.setSkyRenderer((IRenderHandler)new SkyProviderOverworld());
            }
            if (world.field_73011_w instanceof WorldProviderMoon && AsmodeusConfig.enableSkyMoon && !(world.field_73011_w.getSkyRenderer() instanceof SkyProviderMoon)) {
                world.field_73011_w.setSkyRenderer((IRenderHandler)new SkyProviderMoon());
            }
            if (world.field_73011_w instanceof WorldProviderAsteroids && AsmodeusConfig.enableSkyAsteroids && !(world.field_73011_w.getSkyRenderer() instanceof SkyProviderAsteroids)) {
                world.field_73011_w.setSkyRenderer((IRenderHandler)new SkyProviderAsteroids());
            }
            if (world.field_73011_w instanceof WorldProviderVenus && AsmodeusConfig.enableCloudsVenus && !(world.field_73011_w.getCloudRenderer() instanceof CustomCloudRender)) {
                float[] f = new float[]{1.0f, 4.0f, 8.0f};
                world.field_73011_w.setCloudRenderer((IRenderHandler)new CustomCloudRender(f){

                    @Override
                    public ResourceLocation getCloudTexture() {
                        return this.default_clouds;
                    }

                    @Override
                    public Vec3d getCloudColor(float renderPartialTicks) {
                        return new Vec3d(81.0, 61.0, 0.0);
                    }

                    @Override
                    public float getCloudMovementSpeed(WorldClient world) {
                        return 3.0f;
                    }
                });
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!ACCompatibilityManager.isGalacticraftLoaded()) {
            return;
        }
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        EntityPlayerSP playerBaseClient = PlayerUtil.getPlayerBaseClientFromPlayer((EntityPlayer)player, (boolean)false);
        float level = 0.0f;
        if (event.phase == TickEvent.Phase.END && player != null) {
            if (player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && OxygenUtil.shouldDisplayTankGui((GuiScreen)minecraft.field_71462_r) && !playerBaseClient.func_175149_v() && !minecraft.field_71474_y.field_74330_P) {
                IGalacticraftWorldProvider provider = (IGalacticraftWorldProvider)player.field_70170_p.field_73011_w;
                BodiesData data = BodiesRegistry.getData(provider.getCelestialBody());
                GCPlayerStatsClient stats = GCPlayerStatsClient.get((Entity)player);
                if (provider.getCelestialBody() instanceof IExBody && !minecraft.field_71439_g.func_184812_l_()) {
                    level = ((IExBody)provider.getCelestialBody()).getAtmosphericPressure();
                    if (level != 0.0f) {
                        OverlayDetectors.renderPressureIndicator(level, this.getInvalidLevel(1, level), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
                    }
                    if (((IExBody)provider.getCelestialBody()).isSolarRadiation()) {
                        OverlayDetectors.renderRadiationIndicator((int)player.func_110148_a(ACAttributePlayer.RADIATION_LVL).func_111126_e(), this.getInvalidLevel(2, level), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
                    }
                    if (((IExBody)provider.getCelestialBody()).getWaterPressure() > 0.0f && Utils.inWater((EntityPlayer)player)) {
                        float i = 0.0f;
                        int blocks = 0;
                        while (player.field_70170_p.func_180495_p(player.func_180425_c().func_177981_b(blocks)).func_185904_a() != Material.field_151579_a) {
                            i = (float)((double)i + 0.1 * (double)((IExBody)provider.getCelestialBody()).getWaterPressure());
                            ++blocks;
                        }
                        OverlayDetectors.renderWaterPressureIndicator(i, this.getInvalidLevel(3, i), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
                    }
                } else {
                    if (data != null) {
                        level = data.getPressure();
                    }
                    if (level != 0.0f) {
                        OverlayDetectors.renderPressureIndicator(level, this.getInvalidLevel(1, level), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
                    }
                    if (data != null && data.isSolarRadiation()) {
                        OverlayDetectors.renderRadiationIndicator((int)player.func_110148_a(ACAttributePlayer.RADIATION_LVL).func_111126_e(), this.getInvalidLevel(2, level), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
                    }
                }
                float mod = provider.getThermalLevelModifier();
                if (player.field_70170_p.field_73011_w instanceof IAdvancedSpace) {
                    mod = ((IAdvancedSpace)provider).getThermalLevelModifier((EntityPlayer)player);
                }
                if (mod > 0.0f) {
                    mod += 1.0f;
                }
                float temp = mod * (float)BodiesRegistry.getDefaultDergrees;
                OverlayDetectors.renderInfoPanel(temp, this.getInvalidLevel(2, level), !ConfigManagerCore.oxygenIndicatorLeft, !ConfigManagerCore.oxygenIndicatorBottom);
            }
            if (AsmodeusConfig.enableDebug && minecraft.field_71415_G) {
                this.renderDebugInfo(minecraft);
            }
        }
    }

    private boolean getInvalidLevel(int mode, float level) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        EntityPlayerSP player = minecraft.field_71439_g;
        PressureEvent event = new PressureEvent((EntityLivingBase)player, level);
        if (event.isCanceled()) {
            return false;
        }
        return mode == 1 ? level > 25.0f && !Utils.getAtmoArmor((EntityPlayer)player) : (mode == 2 ? player.func_110148_a(ACAttributePlayer.RADIATION_LVL).func_111126_e() > 45.0 : mode == 3 && level > 40.0f && !Utils.getAtmoArmor((EntityPlayer)player));
    }

    private void renderDebugInfo(Minecraft mc) {
        List<String> list = AsmodeusClientEvent.getDebugList();
        int size = 3;
        GameSettings cfr_ignored_0 = mc.field_71474_y;
        if (GameSettings.func_100015_a((KeyBinding)mc.field_71474_y.field_74311_E)) {
            size = list.size();
        }
        int yOffset = 0;
        if (mc.field_71474_y.field_74330_P) {
            ScaledResolution screen = new ScaledResolution(mc);
            yOffset = screen.func_78328_b() / 2 - 50;
        }
        for (int i = 0; i < size; ++i) {
            String s = list.get(i);
            if (Strings.isNullOrEmpty((String)s)) continue;
            int j = mc.field_71466_p.field_78288_b;
            int k = mc.field_71466_p.func_78256_a(s);
            int i1 = 2 + j * i;
            Gui.func_73734_a((int)1, (int)(i1 - 1 + yOffset), (int)(2 + k + 1), (int)(i1 + j - 1 + yOffset), (int)-1873784752);
            mc.field_71466_p.func_78276_b(s, 2, i1 + yOffset, 0xE0E0E0);
        }
    }

    public static List<String> getDebugList() {
        WE_ChunkProvider chunk;
        Minecraft mc = Minecraft.func_71410_x();
        String body = mc.field_71439_g.func_130014_f_().field_73011_w instanceof IGalacticraftWorldProvider ? ((IGalacticraftWorldProvider)mc.field_71439_g.func_130014_f_().field_73011_w).getCelestialBody().getLocalizedName() : "Unnamed";
        String current_item = mc.field_71439_g.field_71071_by.func_70448_g().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150350_a) ? Item.field_150901_e.func_177774_c((Object)mc.field_71439_g.field_71071_by.func_70448_g().func_77973_b()) + ":" + mc.field_71439_g.field_71071_by.func_70448_g().func_77952_i() : "None";
        float temp = mc.field_71439_g.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider ? ((IGalacticraftWorldProvider)mc.field_71439_g.field_70170_p.field_73011_w).getThermalLevelModifier() : 1.0f;
        long t1 = mc.field_71439_g.field_70170_p.field_73011_w instanceof WorldProviderSpace ? ((WorldProviderSpace)mc.field_71439_g.field_70170_p.field_73011_w).getDayLength() : 24000L;
        long time = mc.field_71439_g.field_70170_p.func_72820_D() % (t1 > 0L ? t1 : 1L);
        Chunk get_chunk = mc.field_71439_g.func_130014_f_().func_175726_f(mc.field_71439_g.func_180425_c());
        boolean isWE = mc.field_71439_g.func_130014_f_().field_73011_w instanceof WE_WorldProvider;
        double count = 0.0;
        World world = ColorBlockHandler.world;
        if (isWE && mc.field_71439_g.func_130014_f_().field_73011_w != null && world.field_73011_w instanceof WE_WorldProvider && (chunk = ((WE_WorldProvider)world.field_73011_w).chunk_provider) != null) {
            double scaleX = chunk.biomemapScaleX;
            double persistance = chunk.biomemapPersistence;
            count = WE_PerlinNoise.PerlinNoise2D(mc.field_71439_g.func_130014_f_().func_72905_C() * 11L ^ 6L, (double)mc.field_71439_g.func_130014_f_().func_175726_f((BlockPos)mc.field_71439_g.func_180425_c()).field_76635_g / scaleX, (double)mc.field_71439_g.func_130014_f_().func_175726_f((BlockPos)mc.field_71439_g.func_180425_c()).field_76647_h / scaleX, persistance, chunk.biomemapNumberOfOctaves) * chunk.biomemapScaleY;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("AsmodeusCore 1.0.5 Debug MODE | FPS: " + mc.func_175610_ah());
        list.add("");
        list.add("Celestial Body: " + EnumColor.BRIGHT_GREEN + body);
        list.add("");
        list.add("Current item: " + EnumColor.ORANGE + current_item);
        list.add(String.format("Player pos: x=%s y=%s z=%s", mc.field_71439_g.func_180425_c().func_177958_n(), mc.field_71439_g.func_180425_c().func_177956_o(), mc.field_71439_g.func_180425_c().func_177952_p()));
        list.add("Chunk pos: x=" + get_chunk.field_76635_g + " z=" + get_chunk.field_76647_h);
        list.add("");
        list.add("World Data:");
        list.add(String.format("Dimension: %s (ID: %s)", mc.field_71439_g.field_70170_p.field_73011_w.func_186058_p().func_186065_b(), mc.field_71439_g.field_70170_p.field_73011_w.func_186058_p().func_186068_a()));
        list.add("Temperature (F): " + temp);
        list.add("Vanilla Biome: " + mc.field_71439_g.field_70170_p.getBiomeForCoordsBody(mc.field_71439_g.func_180425_c()).func_185359_l());
        list.add("Current Time: " + time + " | Day Length: " + (mc.field_71439_g.field_70170_p.field_73011_w instanceof WorldProviderSpace ? Long.valueOf(((WorldProviderSpace)mc.field_71439_g.field_70170_p.field_73011_w).getDayLength()) : (mc.field_71439_g.field_70170_p.field_73011_w instanceof WE_WorldProviderSpace ? Long.valueOf(((WE_WorldProviderSpace)mc.field_71439_g.field_70170_p.field_73011_w).getDayLength()) : "24000")) + " | Total Time: " + mc.field_71439_g.field_70170_p.func_72820_D());
        list.add("Moon Phase: " + mc.field_71439_g.field_70170_p.func_72853_d());
        list.add("Is Advance Space Provider: " + (mc.field_71439_g.func_130014_f_().field_73011_w instanceof IAdvancedSpace ? "Yes" : "No"));
        if (isWE) {
            list.add("[WE] Biome Perlin Count: " + count);
        }
        return list;
    }
}

