/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.event;

import asmodeuscore.AsmodeusCore;
import asmodeuscore.api.dimension.IProviderWeather;
import asmodeuscore.api.entity.ICustomEngine;
import asmodeuscore.api.item.IItemPressurized;
import asmodeuscore.api.item.IItemRadiation;
import asmodeuscore.api.space.IExBody;
import asmodeuscore.core.astronomy.BodiesData;
import asmodeuscore.core.astronomy.BodiesRegistry;
import asmodeuscore.core.astronomy.WeatherData;
import asmodeuscore.core.astronomy.dimension.world.data.DustStormSaveData;
import asmodeuscore.core.astronomy.dimension.world.data.FrozenStormSaveData;
import asmodeuscore.core.astronomy.dimension.world.data.MeteoricRainSaveData;
import asmodeuscore.core.configs.AsmodeusConfig;
import asmodeuscore.core.event.PressureEvent;
import asmodeuscore.core.event.RadiationEvent;
import asmodeuscore.core.handler.LightningStormHandler;
import asmodeuscore.core.handler.capabilities.ACCapabilityProviderStats;
import asmodeuscore.core.handler.capabilities.ACCapabilityStatsHandler;
import asmodeuscore.core.handler.capabilities.ACStatsCapability;
import asmodeuscore.core.handler.capabilities.IStatsCapability;
import asmodeuscore.core.network.packet.ACPacketSimple;
import asmodeuscore.core.registers.potions.ACPotions;
import asmodeuscore.core.utils.ACAttributePlayer;
import asmodeuscore.core.utils.ACCompatibilityManager;
import asmodeuscore.core.utils.ACDamageSource;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.server.permission.PermissionAPI;

public class AsmodeusEvent {
    private int engine_id = 0;

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing e) {
        if (e.getEntity() instanceof EntityPlayer) {
            ((EntityPlayer)e.getEntity()).func_110140_aT().func_111150_b(ACAttributePlayer.RADIATION_LVL);
        }
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerMP) {
            event.addCapability(ACCapabilityStatsHandler.AC_PLAYER_PROPERTIES, (ICapabilityProvider)new ACCapabilityProviderStats((EntityPlayerMP)event.getObject()));
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("asmodeuscore")) {
            ConfigManager.sync((String)"asmodeuscore", (Config.Type)Config.Type.INSTANCE);
            AsmodeusConfig.config.save();
            AsmodeusConfig.syncConfig(true);
        }
    }

    @SubscribeEvent
    public void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            System.out.println("Test event");
            AsmodeusCore.packetPipeline.sendTo(new ACPacketSimple(ACPacketSimple.ACEnumSimplePacket.C_UPDATE_WORLD, GCCoreUtil.getDimensionID((World)event.player.func_130014_f_()), new Object[0]), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        if (!event.getWorld().field_72995_K && event.getEntity() instanceof EntityPlayerMP) {
            AsmodeusCore.packetPipeline.sendTo(new ACPacketSimple(ACPacketSimple.ACEnumSimplePacket.C_UPDATE_WORLD, GCCoreUtil.getDimensionID((World)event.getEntity().func_130014_f_()), new Object[0]), (EntityPlayerMP)event.getEntity());
            System.out.println("Test event 2");
        }
    }

    @SubscribeEvent
    public void onPlayerChangeDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player instanceof EntityPlayerMP) {
            AsmodeusCore.packetPipeline.sendTo(new ACPacketSimple(ACPacketSimple.ACEnumSimplePacket.C_UPDATE_WORLD, GCCoreUtil.getDimensionID((World)event.player.field_70170_p), new Object[0]), (EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onUnloadWorld(WorldEvent.Unload e) {
        if (e.getWorld().field_73011_w instanceof IProviderWeather) {
            e.getWorld().getPerWorldStorage().func_75744_a();
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        IStatsCapability oldStats = ACStatsCapability.get((Entity)event.getOriginal());
        IStatsCapability newStats = ACStatsCapability.get((Entity)event.getEntityPlayer());
        newStats.copyFrom(oldStats, !event.isWasDeath() || event.getOriginal().field_70170_p.func_82736_K().func_82766_b("keepInventory"));
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        World world = living.field_70170_p;
        this.doStormEffectForEntity(world, living);
        if (living instanceof EntityPlayerMP) {
            if (!ACCompatibilityManager.isGalacticraftLoaded()) {
                return;
            }
            EntityPlayerMP player = (EntityPlayerMP)living;
            GCPlayerStats GCPlayer = GCPlayerStats.get((Entity)player);
            IStatsCapability GSPlayer = ACStatsCapability.get((Entity)player);
            LightningStormHandler.spawnLightning(player);
            if (GCPlayer.isUsingPlanetSelectionGui() && AsmodeusConfig.enableNewGalaxyMap) {
                this.sendPlanetList(player, GCPlayer, GSPlayer);
            }
            if (player.field_71134_c.func_180239_c()) {
                this.doPressureForEntity(world, (EntityLivingBase)player);
                this.doRadiatoinForEntity(world, (EntityLivingBase)player);
                this.doWaterPressureForEntity(world, (EntityLivingBase)player);
            }
            if (player.func_184187_bx() instanceof ICustomEngine) {
                ICustomEngine rocket = (ICustomEngine)player.func_184187_bx();
                this.engine_id = rocket.getEngine().getID();
            }
            if (player.field_70173_aa % 100 == 0 && world.field_73011_w instanceof IGalacticraftWorldProvider) {
                float thermal = ((IGalacticraftWorldProvider)world.field_73011_w).getThermalLevelModifier();
                float warn_temp = 2.0f;
                float cool_temp = -1.2f;
                boolean thermal_check = thermal > 2.0f || thermal < -1.2f;
                AsmodeusCore.packetPipeline.sendTo(new ACPacketSimple(ACPacketSimple.ACEnumSimplePacket.C_UPDATE_OXYGEN_STATUS, world, new Object[]{OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player, (boolean)thermal_check)}), player);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        boolean flag;
        World w = e.world;
        if (!w.field_72995_K && (flag = w.func_82736_K().func_82766_b("doWeatherCycle")) && w.field_73011_w instanceof IGalacticraftWorldProvider && w.field_73011_w instanceof IProviderWeather) {
            IProviderWeather weaher = (IProviderWeather)w.field_73011_w;
            IGalacticraftWorldProvider gcprovider = (IGalacticraftWorldProvider)w.field_73011_w;
            String name = gcprovider.getCelestialBody().getName();
            try {
                if (weaher.getWeather().getWeatherType() == WeatherData.WeatherType.DUST_STORM) {
                    DustStormSaveData storm_data = DustStormSaveData.get(w, name);
                    DustStormSaveData.calculateWeather(storm_data, w.field_73012_v);
                }
                if (weaher.getWeather().getWeatherType() == WeatherData.WeatherType.METEORIC_RAIN) {
                    MeteoricRainSaveData rain_data = MeteoricRainSaveData.get(w, name);
                    MeteoricRainSaveData.calculateWeather(rain_data, w.field_73012_v);
                    MeteoricRainSaveData.spawnMeteor(rain_data);
                }
                if (weaher.getWeather().getWeatherType() == WeatherData.WeatherType.FROZEN_STORM) {
                    FrozenStormSaveData frozenstorm_data = FrozenStormSaveData.get(w, name);
                    FrozenStormSaveData.calculateWeather(frozenstorm_data, w.field_73012_v);
                }
            }
            catch (AbstractMethodError | NullPointerException throwable) {
                // empty catch block
            }
        }
    }

    private void doStormEffectForEntity(World world, EntityLivingBase living) {
        if (!world.field_72995_K && world.func_82737_E() % 20L == 0L && world.field_73011_w instanceof IProviderWeather && world.field_73011_w instanceof IGalacticraftWorldProvider) {
            IGalacticraftWorldProvider gcprovider = (IGalacticraftWorldProvider)world.field_73011_w;
            String name = gcprovider.getCelestialBody().getName();
            DustStormSaveData msd = DustStormSaveData.get(world, name);
            FrozenStormSaveData msd_frozen = FrozenStormSaveData.get(world, name);
            if (living.func_70662_br()) {
                return;
            }
            if (living instanceof EntityPlayerMP) {
                EntityPlayerMP player = (EntityPlayerMP)living;
                AsmodeusCore.packetPipeline.sendTo(new ACPacketSimple(ACPacketSimple.ACEnumSimplePacket.C_UPDATE_STORM_USER, world, new Object[]{name, msd.isDustStorm(), msd.tickDustStorm, msd.tickClearWeather, Float.valueOf(msd.prevStormStrength), Float.valueOf(msd.stormStrength), 0}), player);
                AsmodeusCore.packetPipeline.sendTo(new ACPacketSimple(ACPacketSimple.ACEnumSimplePacket.C_UPDATE_STORM_USER, world, new Object[]{name, msd_frozen.isFrozenStorm(), msd_frozen.tickStorm, msd_frozen.tickClearWeather, Float.valueOf(msd_frozen.prevStormStrength), Float.valueOf(msd_frozen.stormStrength), 1}), player);
            }
            if (msd.isDustStorm()) {
                boolean flag = true;
                for (int y = 256; y > living.func_180425_c().func_177956_o(); --y) {
                    if (world.func_175623_d(new BlockPos(living.func_180425_c().func_177958_n(), y, living.func_180425_c().func_177952_p()))) continue;
                    flag = false;
                    break;
                }
                if (AsmodeusConfig.enableWeatherDamage && flag) {
                    living.func_70097_a(DamageSource.field_76367_g, 0.5f * AsmodeusConfig.stormDamageRate);
                }
            }
        }
    }

    private void doWaterPressureForEntity(World world, EntityLivingBase living) {
        IGalacticraftWorldProvider provider;
        EntityPlayerMP player = (EntityPlayerMP)living;
        if (player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && !player.field_71075_bZ.field_75098_d && (provider = (IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).getCelestialBody() instanceof IExBody) {
            float i = 0.0f;
            int blocks = 0;
            while (player.field_70170_p.func_180495_p(player.func_180425_c().func_177981_b(blocks)).func_185904_a() != Material.field_151579_a) {
                i = (float)((double)i + 0.1 * (double)((IExBody)provider.getCelestialBody()).getWaterPressure());
                ++blocks;
            }
            PressureEvent.WaterPressure event = new PressureEvent.WaterPressure(living, i);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
    }

    private void doPressureForEntity(World world, EntityLivingBase living) {
        EntityPlayerMP player = (EntityPlayerMP)living;
        if (player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && !player.field_71075_bZ.field_75098_d) {
            BodiesData data;
            IGalacticraftWorldProvider provider = (IGalacticraftWorldProvider)player.field_70170_p.field_73011_w;
            float level = 0.0f;
            if (provider.getCelestialBody() instanceof IExBody) {
                level = ((IExBody)provider.getCelestialBody()).getAtmosphericPressure();
            }
            if ((data = BodiesRegistry.getData(provider.getCelestialBody())) != null) {
                level = data.getPressure();
            }
            PressureEvent event = new PressureEvent(living, level);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                if (!AsmodeusEvent.getPressureArmor(player) && player.field_70173_aa % 50 == 0) {
                    if (level > 10.0f) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200));
                    }
                    if (level > 35.0f) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200));
                    }
                    if (level > 25.0f) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 280, 4));
                    }
                    if (level > 45.0f) {
                        player.func_70097_a(ACDamageSource.pressure, 2.5f * AsmodeusConfig.atmospherePressureDamageRate);
                    }
                }
            }
        }
    }

    private void doRadiatoinForEntity(World world, EntityLivingBase living) {
        EntityPlayerMP player = (EntityPlayerMP)living;
        IAttributeInstance lvl = player.func_110148_a(ACAttributePlayer.RADIATION_LVL);
        if (player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && !player.field_71075_bZ.field_75098_d) {
            IGalacticraftWorldProvider provider = (IGalacticraftWorldProvider)player.field_70170_p.field_73011_w;
            float getModify = 1.0f;
            RadiationEvent eventR = new RadiationEvent((Entity)living, (int)lvl.func_111126_e(), 20);
            MinecraftForge.EVENT_BUS.post((Event)eventR);
            boolean isRad = false;
            BodiesData data = BodiesRegistry.getData(provider.getCelestialBody());
            if (data != null) {
                isRad = data.isSolarRadiation();
            }
            if (provider.getCelestialBody() instanceof IExBody) {
                isRad = ((IExBody)provider.getCelestialBody()).isSolarRadiation();
            }
            if (isRad) {
                if (!AsmodeusEvent.getRadiationArmor(player, getModify) && !eventR.isCanceled() && player.field_70173_aa % eventR.getRadiationSpeed() == 0) {
                    if (lvl.func_111126_e() < 58.0 && player.func_130014_f_().func_72935_r() && player.func_130014_f_().func_175710_j(player.func_180425_c())) {
                        lvl.func_111128_a(lvl.func_111126_e() + 1.0);
                    } else if (lvl.func_111126_e() > 45.0) {
                        lvl.func_111128_a(lvl.func_111126_e() - 1.0);
                    }
                    if (lvl.func_111126_e() > 54.0 && living instanceof EntityPlayerMP && living.field_70163_u <= 1000.0 && player.field_70173_aa % 20 == 0 && lvl.func_111126_e() > 48.0) {
                        player.func_70690_d(new PotionEffect((Potion)ACPotions.radiation, 100));
                    }
                } else if (AsmodeusEvent.getRadiationArmor(player, getModify)) {
                    player.func_184589_d((Potion)ACPotions.radiation);
                }
            } else if (player.field_70173_aa % 600 == 0 && lvl.func_111126_e() > 0.0) {
                lvl.func_111128_a(lvl.func_111126_e() - 1.0);
            }
        }
    }

    public static boolean getPressureArmor(EntityPlayerMP player) {
        for (int i = 0; i < 4; ++i) {
            if (!((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_190926_b() && ((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_77973_b() instanceof IItemPressurized) continue;
            return false;
        }
        return true;
    }

    public static boolean getRadiationArmor(EntityPlayerMP player, float dimModify) {
        for (int i = 0; i < 4; ++i) {
            if (!((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_190926_b() && ((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_77973_b() instanceof IItemRadiation && ((IItemRadiation)((ItemStack)player.field_71071_by.field_70460_b.get(i)).func_77973_b()).getSolarRadiationProtectModify() >= dimModify) continue;
            return false;
        }
        return true;
    }

    protected void sendPlanetList(EntityPlayerMP player, GCPlayerStats playerStats, IStatsCapability acstats) {
        HashMap map = player.field_70173_aa % 50 == 0 ? WorldUtil.getArrayOfPossibleDimensions((int)playerStats.getSpaceshipTier(), (EntityPlayerMP)player) : WorldUtil.getArrayOfPossibleDimensionsAgain((int)playerStats.getSpaceshipTier(), (EntityPlayerMP)player);
        String temp = "";
        int count = 0;
        for (Map.Entry entry : map.entrySet()) {
            temp = temp.concat((String)entry.getKey() + (count < map.entrySet().size() - 1 ? "?" : ""));
            ++count;
        }
        if (!temp.equals(playerStats.getSavedPlanetList()) || player.field_70173_aa % 1 == 0) {
            boolean canCreateStations = PermissionAPI.hasPermission((EntityPlayer)player, (String)"galacticraft.station.create");
            AsmodeusCore.packetPipeline.sendTo(new ACPacketSimple(ACPacketSimple.ACEnumSimplePacket.C_UPDATE_DIMENSION_LIST, GCCoreUtil.getDimensionID((World)player.field_70170_p), player.func_146103_bH().getName(), temp, canCreateStations, playerStats.getSpaceshipTier(), this.engine_id, playerStats.getFuelLevel(), acstats.isSecondPassenger()), player);
            playerStats.setSavedPlanetList(temp);
        }
    }
}

