/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.utils.worldengine2.util;

import asmodeuscore.core.utils.worldengine2.util.ISmartMathFunction;

public class WE_RegionBuffer<ValueType> {
    public SubRegion sr00;
    public SubRegion sr10;
    public SubRegion sr01;
    public SubRegion sr11;
    public long currentX;
    public long currentZ;
    public long currentX0;
    public long currentZ0;
    public long currentX1;
    public long currentZ1;
    public long size;
    public ISmartMathFunction<ValueType> f;

    public WE_RegionBuffer(int allSize, ISmartMathFunction<ValueType> methode) {
        this.size = (long)allSize / 4L;
        this.sr00 = new SubRegion();
        this.sr10 = new SubRegion();
        this.sr01 = new SubRegion();
        this.sr11 = new SubRegion();
        this.currentX = 0L;
        this.currentZ = 0L;
        this.recalcCoords(true, true);
        this.f = methode;
    }

    public ValueType get(long x, long z) {
        if (x > this.currentX0 && z > this.currentZ0 && x <= this.currentX1 && z <= this.currentZ1) {
            int inSubReg_X = (int)((x - 1L) % this.size);
            int inSubReg_Z = (int)((z - 1L) % this.size);
            if (inSubReg_X < 0) {
                inSubReg_X += (int)this.size;
            }
            if (inSubReg_Z < 0) {
                inSubReg_Z += (int)this.size;
            }
            if (x <= this.currentX) {
                if (z <= this.currentZ) {
                    return this.sr00.returnData(inSubReg_X, inSubReg_Z, x, z);
                }
                return this.sr01.returnData(inSubReg_X, inSubReg_Z, x, z);
            }
            if (z <= this.currentZ) {
                return this.sr10.returnData(inSubReg_X, inSubReg_Z, x, z);
            }
            return this.sr11.returnData(inSubReg_X, inSubReg_Z, x, z);
        }
        long checkX1 = this.currentX0 - this.size;
        long checkX2 = this.currentX0 + this.size / 2L;
        long checkX3 = this.currentX1 - this.size / 2L;
        long checkX4 = this.currentX1 + this.size;
        long checkZ1 = this.currentZ0 - this.size;
        long checkZ2 = this.currentZ0 + this.size / 2L;
        long checkZ3 = this.currentZ1 - this.size / 2L;
        long checkZ4 = this.currentZ1 + this.size;
        if (x > checkX1 && z > checkZ1 && x <= checkX2 && z <= checkZ2) {
            this.sr11 = this.sr00;
            this.sr00 = new SubRegion();
            this.sr01 = new SubRegion();
            this.sr10 = new SubRegion();
            this.currentX = this.currentX0;
            this.currentZ = this.currentZ0;
            this.recalcCoords(true, true);
        } else if (x > checkX1 && z > checkZ3 && x <= checkX2 && z <= checkZ4) {
            this.sr10 = this.sr01;
            this.sr01 = new SubRegion();
            this.sr00 = new SubRegion();
            this.sr11 = new SubRegion();
            this.currentX = this.currentX0;
            this.currentZ = this.currentZ1;
            this.recalcCoords(true, true);
        } else if (x > checkX3 && z > checkZ1 && x <= checkX4 && z <= checkZ2) {
            this.sr01 = this.sr10;
            this.sr10 = new SubRegion();
            this.sr00 = new SubRegion();
            this.sr11 = new SubRegion();
            this.currentX = this.currentX1;
            this.currentZ = this.currentZ0;
            this.recalcCoords(true, true);
        } else if (x > checkX3 && z > checkZ3 && x <= checkX4 && z <= checkZ4) {
            this.sr00 = this.sr11;
            this.sr11 = new SubRegion();
            this.sr01 = new SubRegion();
            this.sr10 = new SubRegion();
            this.currentX = this.currentX1;
            this.currentZ = this.currentZ1;
            this.recalcCoords(true, true);
        } else if (x > checkX2 && z > checkZ1 && x <= checkX3 && z <= checkZ2) {
            this.sr01 = this.sr00;
            this.sr11 = this.sr10;
            this.sr00 = new SubRegion();
            this.sr10 = new SubRegion();
            this.currentZ = this.currentZ0;
            this.recalcCoords(false, true);
        } else if (x > checkX2 && z > checkZ3 && x <= checkX3 && z <= checkZ4) {
            this.sr00 = this.sr01;
            this.sr10 = this.sr11;
            this.sr01 = new SubRegion();
            this.sr11 = new SubRegion();
            this.currentZ = this.currentZ1;
            this.recalcCoords(false, true);
        } else if (x > checkX1 && z > checkZ2 && x <= checkX2 && z <= checkZ3) {
            this.sr10 = this.sr00;
            this.sr11 = this.sr01;
            this.sr00 = new SubRegion();
            this.sr01 = new SubRegion();
            this.currentX = this.currentX0;
            this.recalcCoords(true, false);
        } else if (x > checkX3 && z > checkZ2 && x <= checkX4 && z <= checkZ3) {
            this.sr00 = this.sr10;
            this.sr01 = this.sr11;
            this.sr10 = new SubRegion();
            this.sr11 = new SubRegion();
            this.currentX = this.currentX1;
            this.recalcCoords(true, false);
        } else {
            this.sr00 = new SubRegion();
            this.sr10 = new SubRegion();
            this.sr01 = new SubRegion();
            this.sr11 = new SubRegion();
            long preX1 = x > 0L ? (x - 1L) / this.size * this.size : x / this.size * this.size - this.size;
            long preZ1 = z > 0L ? (z - 1L) / this.size * this.size : z / this.size * this.size - this.size;
            long preX2 = preX1 + this.size;
            long preZ2 = preZ1 + this.size;
            long interX = preX1 + this.size / 2L;
            long interZ = preZ1 + this.size / 2L;
            if (x > preX1 && z > preZ1 && x <= interX && z <= interZ) {
                this.currentX = preX1;
                this.currentZ = preZ1;
            } else if (x > preX1 && z > interZ && x <= interX && z <= preZ2) {
                this.currentX = preX1;
                this.currentZ = preZ2;
            } else if (x > interX && z > preZ1 && x <= preX2 && z <= interZ) {
                this.currentX = preX2;
                this.currentZ = preZ1;
            } else if (x > interX && z > interZ && x <= preX2 && z <= preZ2) {
                this.currentX = preX2;
                this.currentZ = preZ2;
            }
            this.recalcCoords(true, true);
        }
        return this.get(x, z);
    }

    public void recalcCoords(boolean doX, boolean doZ) {
        if (doX) {
            this.currentX0 = this.currentX - this.size;
            this.currentX1 = this.currentX + this.size;
        }
        if (doZ) {
            this.currentZ0 = this.currentZ - this.size;
            this.currentZ1 = this.currentZ + this.size;
        }
    }

    public class SubRegion {
        public Object[][] array;
        public boolean[][] isValue;

        public SubRegion() {
            this.array = new Object[(int)WE_RegionBuffer.this.size][(int)WE_RegionBuffer.this.size];
            this.isValue = new boolean[(int)WE_RegionBuffer.this.size][(int)WE_RegionBuffer.this.size];
        }

        public ValueType returnData(int inSubReg_X, int inSubReg_Z, long x, long z) {
            if (!this.isValue[inSubReg_X][inSubReg_Z]) {
                this.isValue[inSubReg_X][inSubReg_Z] = true;
                this.array[inSubReg_X][inSubReg_Z] = WE_RegionBuffer.this.f.g(x, z);
            }
            return this.array[inSubReg_X][inSubReg_Z];
        }
    }
}

