/*
 * Decompiled with CFR 0.152.
 */
package com.f0cus.pokesize;

import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.cobblemon.mod.common.util.PlayerExtensionsKt;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u000f\u0010\u0006\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0003J\u001d\u0010\n\u001a\u00020\u00042\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\u0012\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J5\u0010\u0018\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00108\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001d\u001a\u00020\u001c8\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001f\u0010 R \u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00160!8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"Lcom/f0cus/pokesize/Pokesize;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "", "onInitialize", "registerCommands", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2168;", "dispatcher", "registerPokeSizeCommand", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "Lcom/mojang/brigadier/context/CommandContext;", "context", "", "slot", "", "sizeKey", "executePokeSizeSelf", "(Lcom/mojang/brigadier/context/CommandContext;ILjava/lang/String;)I", "Lnet/minecraft/class_3222;", "targetPlayer", "", "scale", "executePokeSizeAdmin", "(Lcom/mojang/brigadier/context/CommandContext;Lnet/minecraft/class_3222;IF)I", "MOD_ID", "Ljava/lang/String;", "Lorg/slf4j/Logger;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "", "sizePresets", "Ljava/util/Map;", "PokeSize"})
@SourceDebugExtension(value={"SMAP\nPokesize.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pokesize.kt\ncom/f0cus/pokesize/Pokesize\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,149:1\n1869#2,2:150\n*S KotlinDebug\n*F\n+ 1 Pokesize.kt\ncom/f0cus/pokesize/Pokesize\n*L\n76#1:150,2\n*E\n"})
public final class Pokesize
implements ModInitializer {
    @NotNull
    public static final Pokesize INSTANCE = new Pokesize();
    @NotNull
    public static final String MOD_ID = "pokesize";
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Map<String, Float> sizePresets;

    private Pokesize() {
    }

    @NotNull
    public final Logger getLogger() {
        return logger;
    }

    public void onInitialize() {
        logger.info("Initializing PokeSize...");
        this.registerCommands();
    }

    private final void registerCommands() {
        CommandRegistrationCallback.EVENT.register(Pokesize::registerCommands$lambda$0);
    }

    private final void registerPokeSizeCommand(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)MOD_ID).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)((ArgumentType)class_2186.method_9305())).requires(Pokesize::registerPokeSizeCommand$lambda$0)).then(class_2170.method_9244((String)"slot", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)6))).then(class_2170.method_9244((String)"scale", (ArgumentType)((ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)10.0f))).executes(Pokesize::registerPokeSizeCommand$lambda$1))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"slot", (ArgumentType)((ArgumentType)IntegerArgumentType.integer((int)1, (int)6))).requires(Pokesize::registerPokeSizeCommand$lambda$2)).then(class_2170.method_9244((String)"size", (ArgumentType)((ArgumentType)StringArgumentType.string())).suggests(Pokesize::registerPokeSizeCommand$lambda$3).executes(Pokesize::registerPokeSizeCommand$lambda$4))));
    }

    private final int executePokeSizeSelf(CommandContext<class_2168> context, int slot, String sizeKey) {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String string = sizeKey.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        Float scale = sizePresets.get(string);
        if (scale == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Size preset '" + sizeKey + "' not found.")).method_27692(class_124.field_1061));
            return 0;
        }
        Intrinsics.checkNotNull((Object)player);
        PlayerPartyStore party = PlayerExtensionsKt.party((class_3222)player);
        Pokemon pokemon = party.get(slot - 1);
        if (pokemon == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You don't have a Pok\u00e9mon in that slot.").method_27692(class_124.field_1061));
            return 0;
        }
        pokemon.setScaleModifier(scale.floatValue());
        party.set(slot - 1, pokemon);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Your " + pokemon.getSpecies().getName() + "'s size has been set to " + sizeKey + " (" + scale + "x).")).method_27692(class_124.field_1060));
        return 1;
    }

    private final int executePokeSizeAdmin(CommandContext<class_2168> context, class_3222 targetPlayer, int slot, float scale) {
        PlayerPartyStore party = PlayerExtensionsKt.party((class_3222)targetPlayer);
        Pokemon pokemon = party.get(slot - 1);
        if (pokemon == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"The player does not have a Pok\u00e9mon in that slot."));
            return 0;
        }
        pokemon.setScaleModifier(scale);
        party.set(slot - 1, pokemon);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43470((String)("Set " + targetPlayer.method_5477().getString() + "'s " + pokemon.getSpecies().getName() + " size to " + scale + "x.")));
        targetPlayer.method_43496((class_2561)class_2561.method_43470((String)("An admin has set your " + pokemon.getSpecies().getName() + "'s size to " + scale + "x.")).method_27692(class_124.field_1075));
        return 1;
    }

    private static final void registerCommands$lambda$0(CommandDispatcher dispatcher, class_7157 class_71572, class_2170.class_5364 class_53642) {
        Intrinsics.checkNotNull((Object)dispatcher);
        INSTANCE.registerPokeSizeCommand((CommandDispatcher<class_2168>)dispatcher);
    }

    private static final boolean registerPokeSizeCommand$lambda$0(class_2168 source) {
        return Permissions.check((class_2172)((class_2172)source), (String)"pokesize.admin", (int)2);
    }

    private static final int registerPokeSizeCommand$lambda$1(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        class_3222 class_32222 = class_2186.method_9315((CommandContext)context, (String)"player");
        Intrinsics.checkNotNullExpressionValue((Object)class_32222, (String)"getPlayer(...)");
        return INSTANCE.executePokeSizeAdmin((CommandContext<class_2168>)context, class_32222, IntegerArgumentType.getInteger((CommandContext)context, (String)"slot"), FloatArgumentType.getFloat((CommandContext)context, (String)"scale"));
    }

    private static final boolean registerPokeSizeCommand$lambda$2(class_2168 source) {
        return Permissions.check((class_2172)((class_2172)source), (String)"pokesize.user", (int)0);
    }

    private static final CompletableFuture registerPokeSizeCommand$lambda$3(CommandContext commandContext, SuggestionsBuilder builder) {
        Iterable $this$forEach$iv = sizePresets.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            builder.suggest(it);
        }
        return builder.buildFuture();
    }

    private static final int registerPokeSizeCommand$lambda$4(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        int n = IntegerArgumentType.getInteger((CommandContext)context, (String)"slot");
        String string = StringArgumentType.getString((CommandContext)context, (String)"size");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        return INSTANCE.executePokeSizeSelf((CommandContext<class_2168>)context, n, string);
    }

    static {
        Logger logger = LoggerFactory.getLogger((String)MOD_ID);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        Pokesize.logger = logger;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"tiny", (Object)Float.valueOf(0.5f)), TuplesKt.to((Object)"small", (Object)Float.valueOf(0.8f)), TuplesKt.to((Object)"normal", (Object)Float.valueOf(1.0f)), TuplesKt.to((Object)"large", (Object)Float.valueOf(1.5f)), TuplesKt.to((Object)"giant", (Object)Float.valueOf(2.5f))};
        sizePresets = MapsKt.mapOf((Pair[])pairArray);
    }
}

