/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.commons.kyori.serialization;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.reflect.InvocationTargetException;
import xyz.enotik.libs.kyori.adventure.text.Component;
import xyz.enotik.libs.kyori.adventure.text.serializer.ComponentSerializer;

public enum Serializers {
    LEGACY_AMPERSAND("xyz.enotik.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer", "legacyAmpersand"),
    LEGACY_SECTION("xyz.enotik.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer", "legacySection"),
    MINIMESSAGE("xyz.enotik.libs.kyori.adventure.text.minimessage.MiniMessage", "miniMessage"),
    GSON("xyz.enotik.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer", "gson"),
    GSON_COLOR_DOWNSAMPLING("xyz.enotik.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer", "colorDownsamplingGson"),
    PLAIN("xyz.enotik.libs.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer", "plainText");

    @Nullable
    private final ComponentSerializer<Component, Component, String> serializer;

    private Serializers(String className, String methodName) {
        this.serializer = this.findSerializer(className, methodName);
    }

    @Nullable
    private ComponentSerializer<Component, Component, String> findSerializer(String className, String methodName) {
        try {
            return (ComponentSerializer)Class.forName(className).getDeclaredMethod(methodName, new Class[0]).invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    @Nullable
    public ComponentSerializer<Component, Component, String> getSerializer() {
        return this.serializer;
    }
}

