/*
 * Decompiled with CFR 0.152.
 */
package xyz.enotik.advancedehidetags;

import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import xyz.enotik.advancedehidetags.Config;
import xyz.enotik.advancedehidetags.Data;
import xyz.enotik.advancedehidetags.Messages;
import xyz.enotik.advancedehidetags.commands.MainCommand;
import xyz.enotik.advancedehidetags.listeners.ClickListener;
import xyz.enotik.advancedehidetags.listeners.JoinListener;
import xyz.enotik.advancedehidetags.utils.ETeam;
import xyz.enotik.advancedehidetags.utils.logger.ELogger;
import xyz.enotik.libs.bstats.bukkit.Metrics;
import xyz.enotik.libs.kyori.adventure.platform.bukkit.BukkitAudiences;

public final class Core
extends JavaPlugin {
    private static Core instance;
    private ETeam team;
    private BukkitAudiences adventure;

    public static Core getInstance() {
        return instance;
    }

    @NotNull
    public BukkitAudiences adventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return this.adventure;
    }

    public void onLoad() {
    }

    public void onEnable() {
        instance = this;
        new Config(this);
        new Messages(this);
        int thisId = 20179;
        Metrics metrics = new Metrics(this, thisId);
        Data.LOGGER = new ELogger(instance);
        Data.LOGGER.debug_level = Data.DEBUG;
        this.adventure = BukkitAudiences.create((Plugin)this);
        this.team = new ETeam("A-eHideTags");
        new JoinListener(this);
        new ClickListener(this);
        new MainCommand(this);
        Collection onlinePlayers = Bukkit.getOnlinePlayers();
        if (!onlinePlayers.isEmpty()) {
            onlinePlayers.forEach(this.team::addPlayer);
        }
    }

    public void onDisable() {
        if (this.adventure != null) {
            this.adventure.close();
            this.adventure = null;
        }
        if (this.team != null) {
            this.team.unregister();
        }
    }

    public ETeam getTeam() {
        return this.team;
    }
}

