/*
 * Decompiled with CFR 0.152.
 */
package xyz.enotik.advancedehidetags.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.enotik.advancedehidetags.Core;
import xyz.enotik.advancedehidetags.Data;
import xyz.enotik.advancedehidetags.commands.HelpSubCommand;
import xyz.enotik.advancedehidetags.commands.ReloadSubCommand;
import xyz.enotik.advancedehidetags.commands.TestSubCommand;
import xyz.enotik.advancedehidetags.utils.Formatter;
import xyz.enotik.libs.kyori.adventure.audience.Audience;

public class MainCommand
implements TabCompleter,
CommandExecutor {
    private Core plugin;
    private String cmdname = "aeht";

    public MainCommand(Core plugin) {
        this.plugin = plugin;
        PluginCommand command = plugin.getCommand(this.cmdname);
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command cmd, @NotNull String commandLabel, @Nullable String[] args) {
        Audience audience = Core.getInstance().adventure().sender(sender);
        if (!sender.hasPermission(this.cmdname + ".command")) {
            audience.sendMessage(Formatter.defColor(Data.MESSAGE.PREFIX + Data.MESSAGE.ERROR.PERMISSION));
            return true;
        }
        if (args.length == 0) {
            audience.sendMessage(Formatter.defColor(" <white>| <gold>Advanced-eHideTags<br> <white>| <green>Author: " + this.plugin.getDescription().getAuthors() + "<br> <white>| <green>Version: " + this.plugin.getDescription().getVersion()));
            return true;
        }
        if (args.length > 1) {
            audience.sendMessage(Formatter.defColor(Data.MESSAGE.PREFIX + Data.MESSAGE.ERROR.USAGE));
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                return new ReloadSubCommand().execute(sender, commandLabel, args);
            }
            case "help": {
                return new HelpSubCommand().execute(sender, commandLabel, args);
            }
            case "test": {
                return new TestSubCommand().execute(sender, commandLabel, args);
            }
        }
        audience.sendMessage(Formatter.defColor(Data.MESSAGE.PREFIX + Data.MESSAGE.ERROR.USAGE));
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender commandSender, Command command, @NotNull String alias, @NotNull String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (commandSender.hasPermission(this.cmdname + ".reload")) {
            completions.add("reload");
        }
        if (commandSender.hasPermission(this.cmdname + ".help")) {
            completions.add("help");
        }
        if (commandSender.hasPermission(this.cmdname + ".test")) {
            completions.add("test");
        }
        Collections.sort(completions);
        return completions;
    }
}

