/*
 * Decompiled with CFR 0.152.
 */
package xyz.enotik.advancedehidetags.dependencies;

import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import xyz.enotik.advancedehidetags.Data;
import xyz.enotik.advancedehidetags.utils.logger.DebugLevel;

public class PlaceholderAPIBuilder {
    private Type type;
    private String parseString;
    private Player firstPlayer;
    private Player secondPlayer;

    public PlaceholderAPIBuilder() {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") == null && !Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            Data.LOGGER.debug(DebugLevel.SIMPLE, "Cannot find PlaceholderAPI");
        }
    }

    public void firstPlayer(@NotNull Player player) {
        this.firstPlayer = player;
    }

    public void secondPlayer(@NotNull Player player) {
        this.secondPlayer = player;
    }

    public void parseString(@NotNull String string) {
        this.parseString = string;
    }

    public void type(@NotNull Type type) {
        this.type = type;
    }

    public String build() {
        switch (this.type.name()) {
            case "ALL": {
                return this.setPlaceholders(this.firstPlayer, this.setBracketPlaceholders(this.firstPlayer, this.setRelationalPlaceholders(this.firstPlayer, this.secondPlayer, this.parseString)));
            }
            case "DEFAULT": {
                return this.setPlaceholders(this.firstPlayer, this.parseString);
            }
            case "BRACKETS": {
                return this.setBracketPlaceholders(this.firstPlayer, this.parseString);
            }
            case "RELATIONAL": {
                return this.setRelationalPlaceholders(this.firstPlayer, this.secondPlayer, this.parseString);
            }
        }
        return this.parseString;
    }

    private String setPlaceholders(Player player, String string) {
        try {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)string);
        }
        catch (Exception e) {
            return string;
        }
    }

    private String setBracketPlaceholders(Player player, String string) {
        try {
            return PlaceholderAPI.setBracketPlaceholders((Player)player, (String)string);
        }
        catch (Exception e) {
            return string;
        }
    }

    private String setRelationalPlaceholders(Player firstPlayer, Player secondPlayer, String string) {
        try {
            return PlaceholderAPI.setRelationalPlaceholders((Player)firstPlayer, (Player)secondPlayer, (String)string);
        }
        catch (Exception e) {
            return string;
        }
    }

    public static enum Type {
        RELATIONAL,
        BRACKETS,
        DEFAULT,
        ALL;

    }
}

