/*
 * Decompiled with CFR 0.152.
 */
package xyz.enotik.advancedehidetags.listeners;

import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractAtEntityEvent;
import org.bukkit.plugin.Plugin;
import xyz.enotik.advancedehidetags.Core;
import xyz.enotik.advancedehidetags.Data;
import xyz.enotik.advancedehidetags.dependencies.PlaceholderAPIBuilder;
import xyz.enotik.advancedehidetags.utils.Formatter;
import xyz.enotik.advancedehidetags.utils.logger.DebugLevel;
import xyz.enotik.libs.kyori.adventure.audience.Audience;
import xyz.enotik.libs.kyori.adventure.text.Component;

public class ClickListener
implements Listener {
    private Core plugin;
    private PlaceholderAPIBuilder pb = new PlaceholderAPIBuilder();

    public ClickListener(Core plugin) {
        Data.LOGGER.debug(DebugLevel.SIMPLE, "Trying to register ClickListener listener");
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onClick(PlayerInteractAtEntityEvent event) {
        Data.LOGGER.debug(DebugLevel.ADVANCED, "Executed PlayerInteractAtEntityEvent event");
        Entity clickEntity = event.getRightClicked();
        Player player = event.getPlayer();
        Audience audience = this.plugin.adventure().player(player);
        if (clickEntity instanceof Player && !clickEntity.hasMetadata("NPC") && Data.ACTIONBAR.ENABLE.booleanValue() && (Data.ACTIONBAR.SNEAK.PLAYER.booleanValue() || !player.isSneaking())) {
            this.pb.firstPlayer((Player)clickEntity);
            this.pb.secondPlayer(player);
            this.pb.parseString(Data.ACTIONBAR.MESSAGE);
            this.pb.type(PlaceholderAPIBuilder.Type.ALL);
            String placeholderParsed = this.pb.build();
            String out = Formatter.replacePlaceholders(placeholderParsed, (Player)clickEntity);
            audience.sendActionBar(Data.FORMAT.colorize(out));
        }
        if (clickEntity instanceof Tameable && ((Tameable)clickEntity).isTamed() && Data.ACTIONBAR.USE_TAME.booleanValue() && (Data.ACTIONBAR.SNEAK.TAME.booleanValue() || !player.isSneaking()) && clickEntity.getCustomName() != null) {
            audience.sendActionBar(Component.text(clickEntity.getCustomName()));
        }
    }
}

