/*
 * Decompiled with CFR 0.152.
 */
package xyz.enotik.advancedehidetags.utils;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.File;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Nullable;

public class CustomTOML {
    private String path = "plugins" + File.separatorChar;
    private final CommentedFileConfig cf;

    public CustomTOML(String name, JavaPlugin jp) {
        this.path = "plugins/" + jp.getName();
        File folder = new File(this.path);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        File tomlfile = new File(this.path + File.separatorChar + name + ".toml");
        this.cf = (CommentedFileConfig)CommentedFileConfig.builder(tomlfile).build();
        this.cf.load();
    }

    @Nullable
    public <T> T getField(String path) {
        CommentedFileConfig cfg = this.getConfig();
        Object o = cfg.get(path);
        if (o != null) {
            return o;
        }
        cfg.set(path, (Object)"undefined");
        this.save();
        return null;
    }

    public boolean setField(String path, Object o) {
        this.getConfig().set(path, o);
        this.getConfig().contains("");
        return this.save();
    }

    public boolean contains(String path) {
        return this.getConfig().contains(path);
    }

    @Nullable
    public <T> T getField(String path, T whenNotFound) {
        CommentedFileConfig cfg = this.getConfig();
        Object o = cfg.get(path);
        if (o != null) {
            try {
                return o;
            }
            catch (Exception e) {
                return null;
            }
        }
        cfg.set(path, whenNotFound);
        this.save();
        return whenNotFound;
    }

    @Nullable
    public <T> T getField(String path, T whenNotFound, String comment) {
        CommentedFileConfig cfg = this.getConfig();
        Object o = cfg.get(path);
        if (o != null) {
            try {
                return o;
            }
            catch (Exception e) {
                return null;
            }
        }
        cfg.set(path, whenNotFound);
        cfg.setComment(path, comment);
        this.save();
        return whenNotFound;
    }

    private CommentedFileConfig getConfig() {
        return this.cf;
    }

    private boolean save() {
        try {
            this.cf.save();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

