/*
 * Decompiled with CFR 0.152.
 */
package com.hrajtostudio.goldenpan.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7923;

public class ModLootHelper {
    private static final Random RANDOM = new Random();
    private static final Map<String, List<LootEntry>> LOOT_TABLES = new HashMap<String, List<LootEntry>>();

    public static void giveRandomLoot(class_3218 world, class_1657 player, String material) {
        List<LootEntry> entries;
        if (LOOT_TABLES.isEmpty()) {
            ModLootHelper.loadLootTables();
        }
        if ((entries = LOOT_TABLES.get(material)) == null) {
            System.err.println("[GoldenPan] \ud83d\udee0\ufe0f Loot table for material '" + material + "' not found!");
            return;
        }
        double roll = RANDOM.nextDouble();
        double cum = 0.0;
        for (LootEntry e : entries) {
            if (!(roll < (cum += e.chance))) continue;
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(new class_2960(e.item));
            if (item != null) {
                player.method_5775(new class_1799((class_1935)item));
            }
            return;
        }
    }

    private static void loadLootTables() {
        Gson gson = new Gson();
        Type entryList = new TypeToken<List<LootEntry>>(){}.getType();
        LOOT_TABLES.clear();
        try {
            for (String mat : Arrays.asList("sand", "gravel", "red_sand", "mud")) {
                String path = "data/goldenpan/loot/" + mat + ".json";
                InputStream stream = ModLootHelper.class.getClassLoader().getResourceAsStream(path);
                if (stream == null) continue;
                List list = (List)gson.fromJson((Reader)new InputStreamReader(stream), entryList);
                LOOT_TABLES.put(mat, list);
            }
            System.out.println("[GoldenPan] \u2705 Loaded loot tables: " + String.valueOf(LOOT_TABLES.keySet()));
        }
        catch (Exception ex) {
            System.err.println("[GoldenPan] \u26a0\ufe0f Error loading loot JSON:");
            ex.printStackTrace();
        }
    }

    public static class LootEntry {
        public String item;
        public double chance;
    }
}

