/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.command;

import java.util.Map;
import me.valkeea.fishyaddons.api.HypixelPriceClient;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.tracker.ItemTrackerData;
import me.valkeea.fishyaddons.tracker.TrackerUtils;
import me.valkeea.fishyaddons.util.FishyNotis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;

@Environment(value=EnvType.CLIENT)
public class ProfitTrackerCommand {
    private static final String key = "profitTrackerHud";

    private ProfitTrackerCommand() {
    }

    public static boolean handle(String[] args) {
        String subcommand;
        if (args.length == 0) {
            ProfitTrackerCommand.showUsage();
            return false;
        }
        switch (subcommand = args[0].toLowerCase()) {
            case "toggle": {
                return ProfitTrackerCommand.handleToggle();
            }
            case "on": {
                return ProfitTrackerCommand.handleOn();
            }
            case "off": {
                return ProfitTrackerCommand.handleOff();
            }
            case "clear": {
                return ProfitTrackerCommand.handleClear();
            }
            case "stats": {
                return ProfitTrackerCommand.handleStats();
            }
            case "init": {
                return ProfitTrackerCommand.handleInit();
            }
            case "refresh": {
                return ProfitTrackerCommand.handleRefresh();
            }
            case "status": {
                return ProfitTrackerCommand.handleStatus();
            }
            case "price": {
                return ProfitTrackerCommand.handlePrice(args);
            }
            case "type": {
                return ProfitTrackerCommand.handlePriceType(args);
            }
        }
        ProfitTrackerCommand.showUsage();
        return false;
    }

    private static boolean handleToggle() {
        boolean newState = !FishyConfig.getState(key, false);
        FishyConfig.enable(key, newState);
        String status = newState ? "\u00a7aenabled" : "\u00a7cdisabled";
        TrackerUtils.refresh();
        if (newState && ItemTrackerData.hasJsonFile()) {
            if (ItemTrackerData.loadFromJson()) {
                FishyNotis.send((class_2561)class_2561.method_43470((String)("\u00a73Profit Tracker " + status + " \u00a77(loaded from file)")));
            } else {
                FishyNotis.send((class_2561)class_2561.method_43470((String)("\u00a73Profit Tracker " + status)));
            }
        } else {
            FishyNotis.send((class_2561)class_2561.method_43470((String)("\u00a73Profit Tracker " + status)));
        }
        return true;
    }

    private static boolean handlePriceType(String[] args) {
        String newType;
        String typeArg;
        if (args.length < 2) {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7cUsage: /fa profit type [insta_sell|sell_offer]"));
            return false;
        }
        switch (typeArg = args[1].toLowerCase()) {
            case "insta_sell": {
                newType = "sellPrice";
                break;
            }
            case "sell_offer": {
                newType = "buyPrice";
                break;
            }
            default: {
                FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7cInvalid type! Use 'insta_sell' or 'sell_offer'."));
                return false;
            }
        }
        HypixelPriceClient.setPriceType(newType);
        FishyConfig.setString("priceType", newType);
        ItemTrackerData.clearValueCache();
        ItemTrackerData.refreshPrices();
        FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a7bPrice type set to \u00a73%s", newType)));
        return true;
    }

    private static boolean handleOn() {
        FishyConfig.enable(key, true);
        TrackerUtils.refresh();
        ProfitTrackerCommand.handleInit();
        if (ItemTrackerData.hasJsonFile()) {
            if (ItemTrackerData.loadFromJson()) {
                FishyNotis.send((class_2561)class_2561.method_43470((String)"\u00a73Profit Tracker \u00a7aenabled \u00a77(loaded from file)"));
            } else {
                FishyNotis.send((class_2561)class_2561.method_43470((String)"\u00a73Profit Tracker \u00a7aenabled"));
            }
        } else {
            FishyNotis.send((class_2561)class_2561.method_43470((String)"\u00a73Profit Tracker \u00a7aenabled"));
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77Started background price updates..."));
        }
        return true;
    }

    private static boolean handleOff() {
        FishyConfig.enable(key, false);
        TrackerUtils.refresh();
        FishyNotis.send((class_2561)class_2561.method_43470((String)"\u00a73Profit Tracker \u00a7cdisabled"));
        return true;
    }

    private static boolean handleClear() {
        ItemTrackerData.clearAll();
        FishyNotis.send((class_2561)class_2561.method_43470((String)"\u00a73Profit Tracker data cleared"));
        return true;
    }

    private static boolean handleStats() {
        Map<String, Integer> items = ItemTrackerData.getAllItems();
        if (items.isEmpty()) {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77No items tracked this session"));
            return false;
        }
        long sessionTime = ItemTrackerData.getSessionDurationMinutes();
        int totalItems = ItemTrackerData.getTotalItemCount();
        double totalValue = ItemTrackerData.getTotalSessionValue();
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7b  \u03b1 Profit Tracker Stats \u03b1  "));
        FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a77Session: \u00a73%d minutes", sessionTime)));
        FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a77Total items: \u00a73%d", totalItems)));
        if (totalValue > 0.0) {
            String valueStr = ProfitTrackerCommand.formatCoins(totalValue);
            long lastApiUpdate = ItemTrackerData.getLastApiUpdateTime();
            boolean hasRecentData = lastApiUpdate > 0L && System.currentTimeMillis() - lastApiUpdate < 300000L;
            String apiStatus = hasRecentData ? " \u00a7a(live prices)" : " \u00a7c(estimated)";
            FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a77Value: \u00a7e%s%s", valueStr, apiStatus)));
        }
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77Top items (by value):"));
        HypixelPriceClient priceClient = ItemTrackerData.getPriceClient();
        items.entrySet().stream().map(entry -> {
            String itemName = (String)entry.getKey();
            int quantity = (Integer)entry.getValue();
            double unitPrice = 0.0;
            if (priceClient != null) {
                if (priceClient.hasBazaarData(itemName)) {
                    unitPrice = priceClient.getBazaarBuyPrice(itemName);
                } else if (priceClient.hasAuctionData(itemName)) {
                    unitPrice = priceClient.getCachedAuctionPrice(itemName);
                }
            }
            double itemTotal = unitPrice * (double)quantity;
            return new ItemDisplayData(itemName, quantity, unitPrice, itemTotal);
        }).filter(data -> data.totalValue > 0.0).sorted((a, b) -> Double.compare(b.totalValue, a.totalValue)).limit(5L).forEach(data -> {
            String itemName = ProfitTrackerCommand.capitalizeItemName(data.itemName);
            String unitValueStr = ProfitTrackerCommand.formatCoins(data.unitPrice);
            String totalValueStr = ProfitTrackerCommand.formatCoins(data.totalValue);
            FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("  \u00a7a+%d \u00a7f%s \u00a77(\u00a7e%s\u00a77 each, \u00a7b%s\u00a77 total)", data.quantity, itemName, unitValueStr, totalValueStr)));
        });
        return true;
    }

    private static boolean handleInit() {
        ItemTrackerData.init();
        HypixelPriceClient priceClient = ItemTrackerData.getPriceClient();
        if (priceClient != null) {
            priceClient.clearAuctionCache();
        }
        ItemTrackerData.updateAllAsync();
        FishyNotis.send((class_2561)class_2561.method_43470((String)"\u00a73Initialized price client"));
        return true;
    }

    private static boolean handleRefresh() {
        ItemTrackerData.refreshPrices();
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7bRefreshing prices..."));
        return true;
    }

    private static boolean handleStatus() {
        long minutes;
        long lastBazaar = ItemTrackerData.getLastBazaarUpdateTime();
        long lastAuction = ItemTrackerData.getLastAuctionUpdateTime();
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7b  \u03b1 API Status \u03b1  "));
        if (lastBazaar > 0L) {
            minutes = (System.currentTimeMillis() - lastBazaar) / 60000L;
            FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a77Bazaar: \u00a7a\u2713 \u00a77(%d min ago)", minutes)));
        } else {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77Bazaar: \u00a7c\u2717"));
        }
        if (lastAuction > 0L) {
            minutes = (System.currentTimeMillis() - lastAuction) / 60000L;
            FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a77Auctions: \u00a7a\u2713 \u00a77(%d min ago)", minutes)));
        } else {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77Auctions: \u00a7c\u2717"));
        }
        return true;
    }

    private static boolean handlePrice(String[] args) {
        if (args.length < 2) {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7cUsage: /fa profit price [amount] <item>"));
            return false;
        }
        String fullArgument = args[1];
        String[] splitArgs = fullArgument.split(" ");
        int amount = 1;
        int itemStartIndex = 0;
        if (splitArgs.length > 1) {
            try {
                amount = Integer.parseInt(splitArgs[0]);
                if (amount <= 0) {
                    FishyNotis.send((class_2561)class_2561.method_43470((String)"\u00a7cAmount must be a positive number"));
                    return false;
                }
                itemStartIndex = 1;
                if (splitArgs.length < 2) {
                    FishyNotis.send((class_2561)class_2561.method_43470((String)"\u00a7cUsage: /fa profit price [amount] <item>"));
                    return false;
                }
            }
            catch (NumberFormatException e) {
                amount = 1;
                itemStartIndex = 0;
            }
        }
        StringBuilder itemName = new StringBuilder();
        for (int i = itemStartIndex; i < splitArgs.length; ++i) {
            if (i > itemStartIndex) {
                itemName.append(" ");
            }
            itemName.append(splitArgs[i]);
        }
        String item = itemName.toString();
        int finalAmount = amount;
        if (amount > 1) {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a7bPrice for \u00a73%dx %s", amount, item)));
        } else {
            FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a7bPrice for \u00a73%s", item)));
        }
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a77Searching..."));
        ItemTrackerData.getItemValueAsync(item, (value, source) -> {
            if (value > 0.0) {
                double totalValue = value * (double)finalAmount;
                if (finalAmount > 1) {
                    FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a77[%s] \u00a7e%s \u00a77each", source, ProfitTrackerCommand.formatCoins(value))));
                    FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a77Total: \u00a7e%s", ProfitTrackerCommand.formatCoins(totalValue))));
                } else {
                    FishyNotis.alert((class_2561)class_2561.method_43470((String)String.format("\u00a77[%s] \u00a7e%s", source, ProfitTrackerCommand.formatCoins(value))));
                }
            } else {
                FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7cNo price data found"));
            }
        });
        return true;
    }

    private static String formatCoins(double coins) {
        if (coins >= 1000000.0) {
            return String.format("%.1fm", coins / 1000000.0);
        }
        if (coins >= 1000.0) {
            return String.format("%.1fk", coins / 1000.0);
        }
        return String.format("%.0f", coins);
    }

    protected static void showUsage() {
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a7b  \u03b1 Profit Tracker Commands \u03b1  "));
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a73/fa profit on/off \u00a77- Enable/disable"));
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a73/fa profit toggle \u00a77- Toggle tracker"));
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a73/fa profit clear \u00a77- Clear current data"));
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a73/fa profit show \u00a77- Show session stats"));
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a73/fa profit init \u00a77- Initialize APIs"));
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a73/fa profit refresh \u00a77- Refresh cached prices"));
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a73/fa profit status \u00a77- Check API status"));
        FishyNotis.alert((class_2561)class_2561.method_43470((String)"\u00a73/fa profit price [amount] <item> \u00a77- Check price"));
        FishyNotis.send((class_2561)class_2561.method_43470((String)"\u00a7bYou can save the current session using HUD buttons!."));
    }

    private static String capitalizeItemName(String itemName) {
        if (itemName == null || itemName.isEmpty()) {
            return itemName;
        }
        String[] words = itemName.split(" ");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < words.length; ++i) {
            String word;
            if (i > 0) {
                result.append(" ");
            }
            if ((word = words[i]).isEmpty()) continue;
            result.append(Character.toUpperCase(word.charAt(0)));
            if (word.length() <= 1) continue;
            result.append(word.substring(1));
        }
        return result.toString();
    }

    @Environment(value=EnvType.CLIENT)
    private static class ItemDisplayData {
        final String itemName;
        final int quantity;
        final double unitPrice;
        final double totalValue;

        ItemDisplayData(String itemName, int quantity, double unitPrice, double totalValue) {
            this.itemName = itemName;
            this.quantity = quantity;
            this.unitPrice = unitPrice;
            this.totalValue = totalValue;
        }
    }
}

