/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import me.valkeea.fishyaddons.handler.ChatReplacement;
import me.valkeea.fishyaddons.handler.CommandAlias;
import me.valkeea.fishyaddons.handler.KeyShortcut;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class FishyConfig {
    private static final File CONFIG_FILE;
    private static final File BACKUP_DIR;
    private static final File BACKUP_FILE;
    private static final Gson GSON;
    public static final ConfigSection<String> commandAliases;
    public static final ConfigSection<String> chatReplacements;
    public static final ConfigSection<String> keybinds;
    public static final SimpleConfigSection<Object> settings;
    public static final SimpleConfigSection<String> modKeys;
    public static final SimpleConfigSection<Object> hud;
    private static boolean firstLoad;
    private static boolean recreatedConfig;
    private static boolean restoredConfig;
    private static boolean configChanged;
    private static float customRed;
    private static float customGreen;
    private static float customBlue;
    public static final ConfigSection<AlertData> chatAlerts;

    private FishyConfig() {
    }

    public static int getHudX(String hudKey, int defaultX) {
        int n;
        Object value = hud.getValues().getOrDefault(hudKey + "X", defaultX);
        if (value instanceof Number) {
            Number n2 = (Number)value;
            n = n2.intValue();
        } else {
            n = defaultX;
        }
        return n;
    }

    public static int getHudY(String hudKey, int defaultY) {
        int n;
        Object value = hud.getValues().getOrDefault(hudKey + "Y", defaultY);
        if (value instanceof Number) {
            Number n2 = (Number)value;
            n = n2.intValue();
        } else {
            n = defaultY;
        }
        return n;
    }

    public static void setHudX(String hudKey, int x) {
        if (!hud.getValues().containsKey(hudKey + "X")) {
            hud.set(hudKey + "X", 5);
        }
        hud.set(hudKey + "X", x);
        FishyConfig.save();
    }

    public static void setHudY(String hudKey, int y) {
        if (!hud.getValues().containsKey(hudKey + "Y")) {
            hud.set(hudKey + "Y", 5);
        }
        hud.set(hudKey + "Y", y);
        FishyConfig.save();
    }

    public static int getHudSize(String hudKey, int defaultSize) {
        int n;
        Object value = hud.getValues().getOrDefault(hudKey + "Size", defaultSize);
        if (value instanceof Number) {
            Number n2 = (Number)value;
            n = n2.intValue();
        } else {
            n = defaultSize;
        }
        return n;
    }

    public static void setHudSize(String hudKey, int size) {
        hud.set(hudKey + "Size", size);
        FishyConfig.save();
    }

    public static int getHudColor(String hudKey, int defaultColor) {
        int n;
        Object value = hud.getValues().getOrDefault(hudKey + "Color", defaultColor);
        if (value instanceof Number) {
            Number n2 = (Number)value;
            n = n2.intValue();
        } else {
            n = defaultColor;
        }
        return n;
    }

    public static void setHudColor(String hudKey, int color) {
        hud.set(hudKey + "Color", color);
        FishyConfig.save();
    }

    public static boolean getHudOutline(String hudKey, boolean outline) {
        boolean bl;
        Object value = hud.getValues().getOrDefault(hudKey + "Outline", outline);
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            bl = b;
        } else {
            bl = outline;
        }
        return bl;
    }

    public static void setHudOutline(String hudKey, boolean outline) {
        hud.set(hudKey + "Outline", outline);
        FishyConfig.save();
    }

    public static boolean getHudBg(String hudKey, boolean bg) {
        boolean bl;
        Object value = hud.getValues().getOrDefault(hudKey + "Bg", bg);
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            bl = b;
        } else {
            bl = bg;
        }
        return bl;
    }

    public static void setHudBg(String hudKey, boolean bg) {
        hud.set(hudKey + "Bg", bg);
        FishyConfig.save();
    }

    public static boolean isFirstLoad() {
        return firstLoad;
    }

    public static boolean isRecreated() {
        return recreatedConfig;
    }

    public static boolean isRestored() {
        return restoredConfig;
    }

    public static void resetFlags() {
        recreatedConfig = false;
        restoredConfig = false;
        firstLoad = false;
    }

    public static void init() {
        CONFIG_FILE.getParentFile().mkdirs();
        BACKUP_DIR.mkdirs();
        FishyConfig.load();
        if (firstLoad) {
            commandAliases.set("/m7", "/joininstance MASTER_CATACOMBS_FLOOR_SEVEN");
            keybinds.set("MOUSE3", "/pets");
            chatReplacements.set(":cat:", "\u15e2\u160f\u14d7");
            chatReplacements.set(":hi:", "\u0d9e");
            chatReplacements.set("heiiii", "Any string will be replaced one to one");
            settings.set("fishyLava", false);
            settings.set("renderCoordsColor", -5653771);
            settings.set("customParticleColorIndex", 1);
            settings.set("xpColor", 13685247);
            settings.set("hdFont", false);
            settings.set("fishyGui", false);
            settings.set("skipPerspective", false);
            settings.set("cleanHype", false);
            settings.set("mutePhantom", false);
            settings.set("renderCoords", true);
            settings.set("copyChat", true);
            settings.set("ccNoti", true);
            settings.set("customParticleMode", "preset");
            settings.set("beaconAlarm", true);
            settings.set("pingHud", false);
            settings.set("timerHud", true);
            settings.set("petHud", false);
            settings.set("petXpCheck", true);
            settings.set("tabTicks", true);
            settings.set("trackSack", false);
            settings.set("dmgScale", Float.valueOf(0.15f));
            settings.set("scaleCritParticles", false);
            settings.set("invSearch", false);
            settings.set("renderCoords", true);
            settings.set("hideHotspot", false);
            settings.set("hotspotDistance", Float.valueOf(7.0f));
            settings.set("priceType", "sellPrice");
            settings.set("bookDropAlert", true);
            hud.set("pingHudX", 5);
            hud.set("pingHudY", 12);
            hud.set("pingHudSize", 12);
            hud.set("pingHudColor", 1.5649516E7);
            hud.set("timerHudX", 5);
            hud.set("timerHudY", 28);
            hud.set("timerHudSize", 12);
            hud.set("timerHudColor", 1.3228737E7);
            hud.set("titleHudX", 600);
            hud.set("titleHudY", 120);
            hud.set("titleHudSize", 55);
            hud.set("petHudX", 601);
            hud.set("petHudY", 486);
            hud.set("petHudSize", 12);
            hud.set("petHudColor", 1.5649516E7);
            hud.set("trackerHudX", 5);
            hud.set("trackerHudY", 44);
            hud.set("trackerHudSize", 12);
            hud.set("trackerHudColor", 1.5649516E7);
            hud.set("searchX", 400);
            hud.set("searchY", 70);
            hud.set("searchSize", 14);
            modKeys.set("lockKey", "GLFW_KEY_SEMICOLON");
            FishyConfig.save();
        }
    }

    public static void markConfigChanged() {
        configChanged = true;
    }

    public static void saveConfigIfNeeded() {
        if (configChanged) {
            FishyConfig.save();
            configChanged = false;
        }
    }

    public static synchronized void load() {
        if (!CONFIG_FILE.exists()) {
            System.err.println("[FishyConfig] Config file does not exist. Checking for backup...");
            FishyConfig.loadOrRestore();
            firstLoad = true;
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (json == null || !FishyConfig.validate(json)) {
                System.err.println("[FishyConfig] Invalid config detected. Attempting restore...");
                FishyConfig.loadOrRestore();
                return;
            }
            commandAliases.loadFromJson(json);
            chatReplacements.loadFromJson(json);
            keybinds.loadFromJson(json);
            settings.loadFromJson(json);
            modKeys.loadFromJson(json);
            hud.loadFromJson(json);
            chatAlerts.loadFromJson(json);
            if (json.has("customRed")) {
                customRed = json.get("customRed").getAsFloat();
            }
            if (json.has("customGreen")) {
                customGreen = json.get("customGreen").getAsFloat();
            }
            if (json.has("customBlue")) {
                customBlue = json.get("customBlue").getAsFloat();
            }
        }
        catch (JsonIOException | JsonSyntaxException e) {
            System.err.println("[FishyConfig] Malformed JSON: " + e.getMessage());
            FishyConfig.loadOrRestore();
        }
        catch (IOException e) {
            System.err.println("[FishyConfig] Failed to read config: " + e.getMessage());
            FishyConfig.loadOrRestore();
        }
    }

    public static synchronized void save() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            JsonObject json = new JsonObject();
            commandAliases.saveToJson(json);
            chatReplacements.saveToJson(json);
            keybinds.saveToJson(json);
            settings.saveToJson(json);
            modKeys.saveToJson(json);
            hud.saveToJson(json);
            chatAlerts.saveToJson(json);
            json.addProperty("customRed", (Number)Float.valueOf(customRed));
            json.addProperty("customGreen", (Number)Float.valueOf(customGreen));
            json.addProperty("customBlue", (Number)Float.valueOf(customBlue));
            GSON.toJson((JsonElement)json, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("[FishyConfig] Failed to save config: " + e.getMessage());
        }
    }

    public static void saveBackup() {
        try {
            if (CONFIG_FILE.exists()) {
                Files.copy(CONFIG_FILE.toPath(), BACKUP_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            System.err.println("[FishyConfig] Failed to create backup: " + e.getMessage());
        }
    }

    private static boolean validate(JsonObject json) {
        return json.has("commandAliases") && json.has("toggledCommands") && json.has("chatReplacements") && json.has("toggledChatReplacements") && json.has("keybinds") && json.has("toggledKeybinds") && json.has("settings") && json.has("modKeys");
    }

    private static void loadOrRestore() {
        if (BACKUP_FILE.exists()) {
            System.err.println("[FishyConfig] Restoring from backup...");
            try {
                Files.copy(BACKUP_FILE.toPath(), CONFIG_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
                FishyConfig.load();
                restoredConfig = true;
                return;
            }
            catch (IOException e) {
                System.err.println("[FishyConfig] Backup restore failed: " + e.getMessage());
            }
        }
        System.err.println("[FishyConfig] No backup found. Creating default config...");
        FishyConfig.save();
        recreatedConfig = true;
    }

    public static Map<String, String> getCommandAliases() {
        return commandAliases.getValues();
    }

    public static void setCommandAlias(String alias, String command) {
        commandAliases.set(alias, command);
    }

    public static void removeCommandAlias(String alias) {
        commandAliases.remove(alias);
    }

    public static boolean isCommandToggled(String alias) {
        return commandAliases.isToggled(alias);
    }

    public static void toggleCommand(String alias, boolean enabled) {
        commandAliases.toggle(alias, enabled);
    }

    public static Map<String, String> getChatReplacements() {
        return chatReplacements.getValues();
    }

    public static void setChatReplacement(String key, String value) {
        chatReplacements.set(key, value);
    }

    public static void removeChatReplacement(String key) {
        chatReplacements.remove(key);
    }

    public static boolean isChatReplacementToggled(String key) {
        return chatReplacements.isToggled(key);
    }

    public static void toggleChatReplacement(String key, boolean enabled) {
        chatReplacements.toggle(key, enabled);
    }

    public static Map<String, String> getKeybinds() {
        return keybinds.getValues();
    }

    public static void setKeybind(String key, String value) {
        keybinds.set(key, value);
    }

    public static void removeKeybind(String key) {
        keybinds.remove(key);
    }

    public static boolean isKeybindToggled(String key) {
        return keybinds.isToggled(key);
    }

    public static void toggleKeybind(String key, boolean enabled) {
        keybinds.toggle(key, enabled);
    }

    public static String getLockKey() {
        return modKeys.getValues().getOrDefault("lockKey", "GLFW_KEY_L");
    }

    public static void setLockKey(String key) {
        modKeys.set("lockKey", key);
        FishyConfig.save();
    }

    public static int getCustomParticleColorIndex() {
        int n;
        Object value = settings.getValues().get("customParticleColorIndex");
        if (value instanceof Number) {
            Number number = (Number)value;
            n = number.intValue();
        } else {
            n = 1;
        }
        return n;
    }

    public static void setCustomParticleColorIndex(int index) {
        settings.set("customParticleColorIndex", index);
        FishyConfig.save();
    }

    public static float[] getCustomParticleRGB() {
        return new float[]{customRed, customGreen, customBlue};
    }

    public static void setCustomParticleRGB(float r, float g, float b) {
        customRed = r;
        customGreen = g;
        customBlue = b;
        FishyConfig.save();
    }

    public static String getParticleColorMode() {
        String string;
        Object value = settings.getValues().getOrDefault("customParticleMode", "preset");
        return value instanceof String ? (string = (String)value) : "preset";
    }

    public static void setParticleColorMode(String mode) {
        settings.set("customParticleMode", mode);
        FishyConfig.save();
    }

    public static boolean getState(String key, boolean def) {
        boolean bl;
        Object v = settings.getValues().getOrDefault(key, def);
        if (v instanceof Boolean) {
            Boolean b = (Boolean)v;
            bl = b;
        } else {
            bl = def;
        }
        return bl;
    }

    public static void enable(String key, boolean enabled) {
        settings.set(key, enabled);
        FishyConfig.save();
    }

    public static void disable(String key) {
        settings.set(key, false);
        FishyConfig.save();
    }

    public static void toggle(String key, boolean def) {
        boolean current = FishyConfig.getState(key, def);
        FishyConfig.enable(key, !current);
    }

    public static int getInt(String key) {
        int n;
        Object v = settings.getValues().get(key);
        if (v instanceof Number) {
            Number n2 = (Number)v;
            n = n2.intValue();
        } else {
            n = 0;
        }
        return n;
    }

    public static void setInt(String key, int value) {
        settings.set(key, value);
        FishyConfig.save();
    }

    public static String getString(String key, String def) {
        String str;
        Object v = settings.getValues().getOrDefault(key, def);
        return v instanceof String ? (str = (String)v) : def;
    }

    public static void setString(String key, String value) {
        settings.set(key, value);
        FishyConfig.save();
    }

    public static float getFloat(String key, float def) {
        float f;
        Object v = settings.getValues().getOrDefault(key, Float.valueOf(def));
        if (v instanceof Number) {
            Number n = (Number)v;
            f = n.floatValue();
        } else {
            f = def;
        }
        return f;
    }

    public static void setFloat(String key, float value) {
        settings.set(key, Float.valueOf(value));
        FishyConfig.save();
    }

    public static Map<String, AlertData> getChatAlerts() {
        return chatAlerts.getValues();
    }

    public static void setChatAlert(String key, AlertData data) {
        chatAlerts.set(key, data);
    }

    public static void removeChatAlert(String key) {
        chatAlerts.remove(key);
    }

    public static boolean isChatAlertToggled(String key) {
        AlertData data = chatAlerts.getValues().get(key);
        if (data != null) {
            return data.toggled;
        }
        return chatAlerts.isToggled(key);
    }

    public static boolean isTitleActive(String key) {
        AlertData data = chatAlerts.getValues().get(key);
        return data != null && data.onscreen != null && !data.onscreen.isBlank();
    }

    public static void toggleChatAlert(String key, boolean enabled) {
        AlertData data = chatAlerts.getValues().get(key);
        if (data != null) {
            data.toggled = enabled;
            chatAlerts.set(key, data);
        } else {
            chatAlerts.toggle(key, enabled);
        }
        FishyConfig.save();
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        commandAliases = new ConfigSection("commandAliases", "toggledCommands", new TypeToken<Map<String, String>>(){}.getType(), new TypeToken<Map<String, Boolean>>(){}.getType(), v -> {
            FishyConfig.save();
            CommandAlias.refreshCache();
        });
        chatReplacements = new ConfigSection("chatReplacements", "toggledChatReplacements", new TypeToken<Map<String, String>>(){}.getType(), new TypeToken<Map<String, Boolean>>(){}.getType(), v -> {
            FishyConfig.save();
            ChatReplacement.refreshCache();
        });
        keybinds = new ConfigSection("keybinds", "toggledKeybinds", new TypeToken<Map<String, String>>(){}.getType(), new TypeToken<Map<String, Boolean>>(){}.getType(), v -> {
            FishyConfig.save();
            KeyShortcut.refreshCache();
        });
        settings = new SimpleConfigSection("settings", new TypeToken<Map<String, Object>>(){}.getType(), v -> FishyConfig.save());
        modKeys = new SimpleConfigSection("modKeys", new TypeToken<Map<String, String>>(){}.getType(), v -> FishyConfig.save());
        hud = new SimpleConfigSection("hud", new TypeToken<Map<String, Object>>(){}.getType(), v -> FishyConfig.save());
        File root = new File(class_310.method_1551().field_1697, "config/fishyaddons");
        CONFIG_FILE = new File(root, "fishyaddons.json");
        BACKUP_DIR = new File(root, "backup");
        BACKUP_FILE = new File(BACKUP_DIR, "fishyaddons.json");
        firstLoad = false;
        recreatedConfig = false;
        restoredConfig = false;
        configChanged = false;
        customRed = 1.0f;
        customGreen = 0.0f;
        customBlue = 0.0f;
        chatAlerts = new ConfigSection("chatAlerts", "toggledChatAlerts", new TypeToken<Map<String, AlertData>>(){}.getType(), new TypeToken<Map<String, Boolean>>(){}.getType(), v -> FishyConfig.save());
    }

    @Environment(value=EnvType.CLIENT)
    public static class SimpleConfigSection<V> {
        private final Map<String, V> values = new LinkedHashMap<String, V>();
        private final String valuesKey;
        private final Type valueType;
        private final Consumer<Void> onChange;

        public SimpleConfigSection(String valuesKey, Type valueType, Consumer<Void> onChange) {
            this.valuesKey = valuesKey;
            this.valueType = valueType;
            this.onChange = onChange;
        }

        public Map<String, V> getValues() {
            return this.values;
        }

        public void set(String key, V value) {
            if (key == null || key.isEmpty()) {
                return;
            }
            this.values.put(key, value);
            if (this.onChange != null) {
                this.onChange.accept(null);
            }
        }

        public void remove(String key) {
            if (key == null || key.isEmpty()) {
                return;
            }
            this.values.remove(key);
            if (this.onChange != null) {
                this.onChange.accept(null);
            }
        }

        public void loadFromJson(JsonObject json) {
            if (json.has(this.valuesKey)) {
                Map loaded = (Map)GSON.fromJson(json.get(this.valuesKey), this.valueType);
                this.values.clear();
                this.values.putAll(loaded);
            }
        }

        public void saveToJson(JsonObject json) {
            json.add(this.valuesKey, GSON.toJsonTree(this.values));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ConfigSection<V> {
        private final Map<String, V> values = new LinkedHashMap<String, V>();
        private final Map<String, Boolean> toggled = new LinkedHashMap<String, Boolean>();
        private final String valuesKey;
        private final String toggledKey;
        private final Type valueType;
        private final Type toggledType;
        private final Consumer<Void> onChange;

        public ConfigSection(String valuesKey, String toggledKey, Type valueType, Type toggledType, Consumer<Void> onChange) {
            this.valuesKey = valuesKey;
            this.toggledKey = toggledKey;
            this.valueType = valueType;
            this.toggledType = toggledType;
            this.onChange = onChange;
        }

        public Map<String, V> getValues() {
            return this.values;
        }

        public Map<String, Boolean> getToggled() {
            return this.toggled;
        }

        public void set(String key, V value) {
            if (key == null || key.isEmpty()) {
                return;
            }
            this.values.put(key, value);
            this.toggled.putIfAbsent(key, true);
            if (this.onChange != null) {
                this.onChange.accept(null);
            }
        }

        public void remove(String key) {
            if (key == null || key.isEmpty()) {
                return;
            }
            this.values.remove(key);
            this.toggled.remove(key);
            if (this.onChange != null) {
                this.onChange.accept(null);
            }
        }

        public boolean isToggled(String key) {
            return this.toggled.getOrDefault(key, true);
        }

        public void toggle(String key, boolean enabled) {
            if (key == null || key.isEmpty()) {
                return;
            }
            if (enabled) {
                for (String k : this.toggled.keySet()) {
                    if (k.equals(key) || !k.equalsIgnoreCase(key)) continue;
                    this.toggled.put(k, false);
                }
            }
            this.toggled.put(key, enabled);
            if (this.onChange != null) {
                this.onChange.accept(null);
            }
        }

        public void loadFromJson(JsonObject json) {
            Map loaded;
            if (json.has(this.valuesKey)) {
                loaded = (Map)GSON.fromJson(json.get(this.valuesKey), this.valueType);
                this.values.clear();
                this.values.putAll(loaded);
            }
            if (json.has(this.toggledKey)) {
                loaded = (Map)GSON.fromJson(json.get(this.toggledKey), this.toggledType);
                this.toggled.clear();
                this.toggled.putAll(loaded);
            }
            this.toggled.keySet().removeIf(k -> !this.values.containsKey(k));
        }

        public void saveToJson(JsonObject json) {
            json.add(this.valuesKey, GSON.toJsonTree(this.values));
            json.add(this.toggledKey, GSON.toJsonTree(this.toggled));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class AlertData {
        public String msg;
        public String onscreen;
        public int color;
        public String soundId;
        public float volume;
        public boolean toggled;

        public AlertData() {
            this("", "", -1, "", 1.0f, true);
        }

        public AlertData(String msg, String onscreen, int color, String soundId, float volume, boolean toggled) {
            this.msg = msg;
            this.onscreen = onscreen;
            this.color = color;
            this.soundId = soundId;
            if (volume < 0.0f) {
                volume = 0.0f;
            }
            if (volume > 5.0f) {
                volume = 5.0f;
            }
            this.volume = volume;
            this.toggled = toggled;
        }
    }
}

