/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.valkeea.fishyaddons.safeguard.BlacklistManager;
import me.valkeea.fishyaddons.util.TextFormatUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class ItemConfig {
    private static final File CONFIG_FILE;
    private static final File BACKUP_DIR;
    private static final File BACKUP_FILE;
    private static final Gson GSON;
    private static boolean isSellProtectionEnabled;
    private static boolean isTooltipEnabled;
    private static boolean isProtectTriggerEnabled;
    private static boolean isProtectNotiEnabled;
    private static boolean isLockTriggerEnabled;
    private static final Map<String, String> protectedUUIDs;
    private static final Set<Integer> lockedSlots;
    private static final Map<Integer, Integer> boundSlots;
    private static boolean configChanged;
    private static boolean initialized;
    private static boolean recreatedConfig;
    private static boolean restoredConfig;
    private static final String LOCKED_SLOTS_KEY = "lockedSlots";
    private static final String BOUND_SLOTS_KEY = "boundSlots";
    private static final String UUIDS_KEY = "protectedUUIDs";
    private static final String SELL_PROT_KEY = "sellProtectionEnabled";
    private static final String TOOLTIP_KEY = "tooltipEnabled";
    private static final String PROT_TRIGGER_KEY = "protectTriggerEnabled";
    private static final String PROT_NOTI_KEY = "protectNotiEnabled";
    private static final String LOCK_TRIGGER_KEY = "lockTriggerEnabled";
    private static final String BLACKLIST_KEY = "blacklist";

    private ItemConfig() {
    }

    public static boolean isRecreated() {
        return recreatedConfig;
    }

    public static boolean isRestored() {
        return restoredConfig;
    }

    public static void resetFlags() {
        recreatedConfig = false;
        restoredConfig = false;
    }

    public static synchronized void init() {
        CONFIG_FILE.getParentFile().mkdirs();
        BACKUP_DIR.mkdirs();
        if (!initialized) {
            ItemConfig.load();
            initialized = true;
        }
    }

    public static synchronized void addUUID(String uuid, class_2561 displayName) {
        String serialized = TextFormatUtil.serialize(displayName);
        if (!protectedUUIDs.containsKey(uuid) || !Objects.equals(protectedUUIDs.get(uuid), serialized)) {
            protectedUUIDs.put(uuid, serialized);
            configChanged = true;
            ItemConfig.saveConfigIfNeeded();
        }
    }

    public static synchronized void removeUUID(String uuid) {
        if (protectedUUIDs.remove(uuid) != null) {
            configChanged = true;
            ItemConfig.saveConfigIfNeeded();
        }
    }

    public static synchronized void clearAll() {
        protectedUUIDs.clear();
        configChanged = true;
        ItemConfig.saveConfigIfNeeded();
    }

    public static synchronized boolean isProtected(String uuid) {
        return protectedUUIDs.containsKey(uuid);
    }

    public static synchronized class_2561 getDisplayName(String uuid) {
        return TextFormatUtil.deserialize(protectedUUIDs.get(uuid));
    }

    public static synchronized Map<String, String> getProtectedUUIDs() {
        return new HashMap<String, String>(protectedUUIDs);
    }

    public static boolean isSellProtectionEnabled() {
        return isSellProtectionEnabled;
    }

    public static void setSellProtectionEnabled(boolean enabled) {
        isSellProtectionEnabled = enabled;
        ItemConfig.save();
    }

    public static boolean isProtectTriggerEnabled() {
        return isProtectTriggerEnabled;
    }

    public static void setProtectTriggerEnabled(boolean enabled) {
        isProtectTriggerEnabled = enabled;
        ItemConfig.markConfigChanged();
    }

    public static boolean isProtectNotiEnabled() {
        return isProtectNotiEnabled;
    }

    public static void setProtectNotiEnabled(boolean enabled) {
        isProtectNotiEnabled = enabled;
        ItemConfig.markConfigChanged();
    }

    public static boolean isTooltipEnabled() {
        return isTooltipEnabled;
    }

    public static void setTooltipEnabled(boolean enabled) {
        isTooltipEnabled = enabled;
        ItemConfig.markConfigChanged();
    }

    public static boolean isLockTriggerEnabled() {
        return isLockTriggerEnabled;
    }

    public static void setLockTriggerEnabled(boolean enabled) {
        isLockTriggerEnabled = enabled;
        ItemConfig.markConfigChanged();
    }

    public static synchronized boolean isSlotLocked(int slot) {
        return lockedSlots.contains(slot);
    }

    public static synchronized void toggleSlotLock(int slot) {
        if (lockedSlots.contains(slot)) {
            lockedSlots.remove(slot);
        } else {
            lockedSlots.add(slot);
        }
        ItemConfig.markConfigChanged();
    }

    public static synchronized boolean areSlotsBound(int slotA, int slotB) {
        return boundSlots.get(slotA) != null && boundSlots.get(slotA) == slotB;
    }

    public static synchronized boolean isSlotBound(int slot) {
        return boundSlots.containsKey(slot);
    }

    public static synchronized int getBoundSlot(int slot) {
        return boundSlots.getOrDefault(slot, -1);
    }

    public static synchronized void bindSlots(int slotA, int slotB) {
        boundSlots.put(slotA, slotB);
        boundSlots.put(slotB, slotA);
        ItemConfig.markConfigChanged();
    }

    public static synchronized void unbindSlots(int slotA, int slotB) {
        boundSlots.remove(slotA);
        boundSlots.remove(slotB);
        ItemConfig.markConfigChanged();
    }

    public static synchronized void load() {
        if (!CONFIG_FILE.exists()) {
            System.err.println("[ItemConfig] Config file does not exist. Creating a new one...");
            ItemConfig.loadOrRestore();
            return;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(CONFIG_FILE), StandardCharsets.UTF_8);){
            Object bound;
            Object locked;
            Type configType = new TypeToken<Map<String, Object>>(){}.getType();
            Map config = (Map)GSON.fromJson((Reader)reader, configType);
            if (config == null || !ItemConfig.validate(config)) {
                System.err.println("[ItemConfig] Invalid config detected. Attempting to restore from backup...");
                ItemConfig.loadOrRestore();
                return;
            }
            if (config.containsKey(SELL_PROT_KEY)) {
                isSellProtectionEnabled = (Boolean)config.get(SELL_PROT_KEY);
            }
            if (config.containsKey(TOOLTIP_KEY)) {
                isTooltipEnabled = (Boolean)config.get(TOOLTIP_KEY);
            }
            if (config.containsKey(PROT_TRIGGER_KEY)) {
                isProtectTriggerEnabled = (Boolean)config.get(PROT_TRIGGER_KEY);
            }
            if (config.containsKey(PROT_NOTI_KEY)) {
                isProtectNotiEnabled = (Boolean)config.get(PROT_NOTI_KEY);
            }
            if (config.containsKey(UUIDS_KEY)) {
                Object uuidsObj = config.get(UUIDS_KEY);
                protectedUUIDs.clear();
                if (uuidsObj instanceof Map) {
                    Iterator<Object> uuidMap = (Map)uuidsObj;
                    for (Map.Entry entry : uuidMap.entrySet()) {
                        if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                        protectedUUIDs.put((String)entry.getKey(), (String)entry.getValue());
                    }
                } else if (uuidsObj instanceof List) {
                    for (Object e : (List)uuidsObj) {
                        if (!(e instanceof String)) continue;
                        String string = (String)e;
                        protectedUUIDs.put(string, "");
                    }
                }
            }
            if (config.containsKey(LOCK_TRIGGER_KEY)) {
                isLockTriggerEnabled = (Boolean)config.get(LOCK_TRIGGER_KEY);
            }
            if (config.containsKey(LOCKED_SLOTS_KEY) && (locked = config.get(LOCKED_SLOTS_KEY)) instanceof List) {
                lockedSlots.clear();
                for (Object e : (List)locked) {
                    if (!(e instanceof Number)) continue;
                    Number number = (Number)e;
                    lockedSlots.add(number.intValue());
                }
            }
            if (config.containsKey(BOUND_SLOTS_KEY) && (bound = config.get(BOUND_SLOTS_KEY)) instanceof Map) {
                boundSlots.clear();
                for (Map.Entry entry : ((Map)bound).entrySet()) {
                    int from = Integer.parseInt(entry.getKey().toString());
                    int to = ((Number)entry.getValue()).intValue();
                    boundSlots.put(from, to);
                    boundSlots.put(to, from);
                }
            }
            if (config.containsKey(BLACKLIST_KEY)) {
                Object blacklistObject = config.get(BLACKLIST_KEY);
                if (blacklistObject instanceof List) {
                    List rawList = (List)blacklistObject;
                    ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                    for (Object o : rawList) {
                        if (!(o instanceof Map)) continue;
                        Map entry = (Map)o;
                        arrayList.add(entry);
                    }
                    BlacklistManager.loadUserBlacklistFromJson(arrayList);
                } else {
                    System.err.println("[ItemConfig] Blacklist is not a valid list.");
                }
            }
        }
        catch (JsonSyntaxException | MalformedJsonException e) {
            System.err.println("[ItemConfig] Malformed JSON detected: " + e.getMessage());
            ItemConfig.loadOrRestore();
        }
        catch (IOException e) {
            System.err.println("[ItemConfig] Failed to load configuration: " + e.getMessage());
            ItemConfig.loadOrRestore();
        }
    }

    public static synchronized void save() {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put(UUIDS_KEY, new HashMap<String, String>(protectedUUIDs));
        config.put(SELL_PROT_KEY, isSellProtectionEnabled);
        config.put(TOOLTIP_KEY, isTooltipEnabled);
        config.put(PROT_TRIGGER_KEY, isProtectTriggerEnabled);
        config.put(PROT_NOTI_KEY, isProtectNotiEnabled);
        config.put(LOCK_TRIGGER_KEY, isLockTriggerEnabled);
        config.put(LOCKED_SLOTS_KEY, new ArrayList<Integer>(lockedSlots));
        HashMap<Integer, Integer> boundCopy = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, Integer> e : boundSlots.entrySet()) {
            if (e.getKey() >= e.getValue()) continue;
            boundCopy.put(e.getKey(), e.getValue());
        }
        config.put(BOUND_SLOTS_KEY, boundCopy);
        List<Map<String, Object>> serializedBlacklist = BlacklistManager.getUserBlacklistAsJson();
        config.put(BLACKLIST_KEY, serializedBlacklist);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(CONFIG_FILE), StandardCharsets.UTF_8);){
            GSON.toJson(config, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("[ItemConfig] Failed to save config: " + e.getMessage());
        }
    }

    public static void saveBackup() {
        try {
            if (CONFIG_FILE.exists()) {
                Files.copy(CONFIG_FILE.toPath(), BACKUP_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
                System.out.println("[ItemConfig] Backup saved successfully.");
            }
        }
        catch (IOException e) {
            System.err.println("[ItemConfig] Failed to save backup: " + e.getMessage());
        }
    }

    private static void loadOrRestore() {
        if (BACKUP_FILE.exists()) {
            System.err.println("[ItemConfig] Restoring from backup...");
            try {
                Files.copy(BACKUP_FILE.toPath(), CONFIG_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
                ItemConfig.load();
                restoredConfig = true;
                return;
            }
            catch (IOException e) {
                System.err.println("[ItemConfig] Failed to restore from backup: " + e.getMessage());
            }
        }
        System.err.println("[ItemConfig] Creating a new config file...");
        try {
            CONFIG_FILE.createNewFile();
            ItemConfig.save();
            recreatedConfig = true;
        }
        catch (IOException e) {
            System.err.println("[ItemConfig] Failed to create new config file: " + e.getMessage());
        }
    }

    private static boolean validate(Map<String, Object> config) {
        if (config == null || config.isEmpty()) {
            return false;
        }
        if (!(config.containsKey(UUIDS_KEY) && config.containsKey(SELL_PROT_KEY) && config.containsKey(TOOLTIP_KEY) && config.containsKey(PROT_TRIGGER_KEY) && config.containsKey(PROT_NOTI_KEY) && config.containsKey(LOCKED_SLOTS_KEY) && config.containsKey(LOCK_TRIGGER_KEY) && config.containsKey(BOUND_SLOTS_KEY))) {
            return false;
        }
        return config.get(UUIDS_KEY) instanceof Map && config.get(SELL_PROT_KEY) instanceof Boolean && config.get(TOOLTIP_KEY) instanceof Boolean && config.get(PROT_TRIGGER_KEY) instanceof Boolean && config.get(PROT_NOTI_KEY) instanceof Boolean && config.get(LOCK_TRIGGER_KEY) instanceof Boolean && config.get(BOUND_SLOTS_KEY) instanceof Map && config.get(LOCKED_SLOTS_KEY) instanceof List;
    }

    private static void markConfigChanged() {
        configChanged = true;
        ItemConfig.saveConfigIfNeeded();
    }

    public static void saveConfigIfNeeded() {
        if (configChanged) {
            ItemConfig.save();
            configChanged = false;
        }
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        isSellProtectionEnabled = true;
        isTooltipEnabled = true;
        isProtectTriggerEnabled = true;
        isProtectNotiEnabled = true;
        isLockTriggerEnabled = true;
        protectedUUIDs = new HashMap<String, String>();
        lockedSlots = new HashSet<Integer>();
        boundSlots = new HashMap<Integer, Integer>();
        configChanged = false;
        initialized = false;
        recreatedConfig = false;
        restoredConfig = false;
        File root = new File(class_310.method_1551().field_1697, "config/fishyaddons");
        CONFIG_FILE = new File(root, "fishyitems.json");
        BACKUP_DIR = new File(root, "backup");
        BACKUP_FILE = new File(BACKUP_DIR, "fishyitems.json");
    }
}

