/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.valkeea.fishyaddons.util.FishyNotis;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class TextureConfig {
    private static final File CONFIG_FILE = new File("config/fishyaddons/fishyzones.json");
    private static final File BACKUP_DIR = new File("config/fishyaddons/backup");
    private static final File BACKUP_FILE = new File(BACKUP_DIR, "fishyzones.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Type CONFIG_TYPE = new TypeToken<Map<String, Object>>(){}.getType();
    private static final Set<String> enabledIslands = new HashSet<String>();
    private static boolean retexStatus = true;
    private static boolean allToggled = true;
    private static boolean recreatedConfig = false;
    private static boolean restoredConfig = false;

    public static boolean isRecreated() {
        return recreatedConfig;
    }

    public static boolean isRestored() {
        return restoredConfig;
    }

    public static void resetFlags() {
        recreatedConfig = false;
        restoredConfig = false;
    }

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            System.err.println("[TextureConfig] Config file does not exist. Creating a new one...");
            TextureConfig.loadOrRestore();
            return;
        }
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(CONFIG_FILE), StandardCharsets.UTF_8);){
            Map config = (Map)GSON.fromJson((Reader)reader, CONFIG_TYPE);
            if (config == null || !TextureConfig.validate(config)) {
                System.err.println("[TextureConfig] Invalid config detected. Attempting to restore from backup...");
                TextureConfig.loadOrRestore();
                return;
            }
            List islands = (List)config.get("enabledIslands");
            enabledIslands.clear();
            if (islands != null) {
                enabledIslands.addAll(islands);
                enabledIslands.remove("default");
            }
            retexStatus = config.getOrDefault("retexStatus", true);
        }
        catch (JsonSyntaxException | MalformedJsonException e) {
            System.err.println("[TextureConfig] Malformed JSON detected: " + e.getMessage());
            TextureConfig.loadOrRestore();
        }
        catch (IOException e) {
            System.err.println("[TextureConfig] Failed to load configuration: " + e.getMessage());
            TextureConfig.loadOrRestore();
        }
    }

    public static void save() {
        HashMap<String, Serializable> config = new HashMap<String, Serializable>();
        ArrayList<String> islandsToSave = new ArrayList<String>(enabledIslands);
        islandsToSave.remove("default");
        config.put("enabledIslands", islandsToSave);
        config.put("retexStatus", Boolean.valueOf(retexStatus));
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(CONFIG_FILE), StandardCharsets.UTF_8);){
            GSON.toJson(config, CONFIG_TYPE, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("[FishyAddons] Failed to save texture config:");
            e.printStackTrace();
        }
    }

    public static void saveBackup() {
        try {
            if (CONFIG_FILE.exists()) {
                Files.copy(CONFIG_FILE.toPath(), BACKUP_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            System.err.println("[ConfigHandler] Failed to save backup: " + e.getMessage());
        }
    }

    private static boolean validate(Map<String, Object> config) {
        return config.containsKey("enabledIslands") && config.containsKey("retexStatus");
    }

    private static void loadOrRestore() {
        if (BACKUP_FILE.exists()) {
            System.err.println("[TextureConfig] Restoring from backup...");
            try {
                Files.copy(BACKUP_FILE.toPath(), CONFIG_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
                TextureConfig.load();
                restoredConfig = true;
                return;
            }
            catch (IOException e) {
                System.err.println("[TextureConfig] Failed to restore from backup: " + e.getMessage());
            }
        }
        System.err.println("[TextureConfig] No valid backup found. Creating a new default configuration...");
        enabledIslands.clear();
        retexStatus = true;
        TextureConfig.save();
        recreatedConfig = true;
    }

    public static void toggleIslandTexture(String island, boolean enabled) {
        if (enabled) {
            enabledIslands.add(island);
            FishyNotis.send("Enabled retexturing for " + island + ". Use f3 + t or swap servers for instant effects.");
        } else {
            enabledIslands.remove(island);
            FishyNotis.send("Disabled retexturing for " + island + ". Use f3 + t or swap servers for instant effects.");
        }
        TextureConfig.save();
    }

    public static boolean isIslandTextureEnabled(String island) {
        return enabledIslands.contains(island);
    }

    public static Set<String> getEnabledIslands() {
        return Collections.unmodifiableSet(enabledIslands);
    }

    public static void setAllToggled(boolean enabled) {
        allToggled = enabled;
        TextureConfig.save();
    }

    public static boolean isRetexStatus() {
        return retexStatus;
    }

    public static boolean isAllToggled() {
        return allToggled;
    }
}

