/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.List;
import java.util.Objects;
import me.valkeea.fishyaddons.config.FishyConfig;
import me.valkeea.fishyaddons.gui.ColorPickerScreen;
import me.valkeea.fishyaddons.gui.FaButton;
import me.valkeea.fishyaddons.gui.FaTextField;
import me.valkeea.fishyaddons.gui.SoundSearchMenu;
import me.valkeea.fishyaddons.handler.ChatAlert;
import me.valkeea.fishyaddons.util.SoundUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class AlertEditScreen
extends class_437 {
    private final class_437 parent;
    private final String alertKey;
    private final FishyConfig.AlertData initialData;
    private SoundSearchMenu searchMenu;
    private class_342 msgField;
    private class_342 alertTextField;
    private class_342 soundIdField;
    private class_342 volumeField;
    private int alertColor = -1;

    public AlertEditScreen(String key, FishyConfig.AlertData data, class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Edit Alert"));
        this.parent = parent;
        this.alertKey = key;
        this.initialData = data != null ? data : new FishyConfig.AlertData("", "", -1, "", 1.0f, true);
        this.alertColor = this.initialData.color;
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2 - 10;
        this.msgField = new FaTextField(this.field_22793, centerX - 300, centerY, 100, 20, (class_2561)class_2561.method_43470((String)"Chat message"));
        this.msgField.method_1852(this.initialData.msg != null ? this.initialData.msg : "");
        this.method_37063((class_364)this.msgField);
        this.alertTextField = new FaTextField(this.field_22793, centerX - 190, centerY, 120, 20, (class_2561)class_2561.method_43470((String)"On-screen Alert"));
        this.alertTextField.method_1852(this.initialData.onscreen != null ? this.initialData.onscreen : "");
        this.method_37063((class_364)this.alertTextField);
        this.method_37063((class_364)new FaButton(centerX - 70, centerY, 50, 20, (class_2561)class_2561.method_43470((String)"Color").method_27694(style -> style.method_36139(this.alertColor)), btn -> {
            float[] rgb = ColorPickerScreen.intToRGB(this.alertColor);
            this.field_22787.method_1507((class_437)new ColorPickerScreen(this, rgb, selected -> {
                this.alertColor = ColorPickerScreen.rgbToInt(selected);
                btn.method_25355((class_2561)class_2561.method_43470((String)"Color").method_27694(s -> s.method_36139(this.alertColor)));
                this.field_22787.method_1507((class_437)this);
            }));
        }));
        this.soundIdField = new FaTextField(this.field_22793, centerX - 10, centerY, 200, 20, (class_2561)class_2561.method_43470((String)"SoundEvent ID"));
        this.soundIdField.method_1852(this.initialData.soundId != null ? this.initialData.soundId : "");
        this.method_37063((class_364)this.soundIdField);
        List<String> soundIds = class_7923.field_41172.method_10220().map(arg_0 -> ((class_2378)class_7923.field_41172).method_10221(arg_0)).filter(Objects::nonNull).map(class_2960::toString).sorted().toList();
        int x = this.soundIdField.method_46426();
        int y = this.soundIdField.method_46427();
        int width = this.soundIdField.method_25368() + 50;
        int entryHeight = 18;
        this.searchMenu = new SoundSearchMenu(soundIds, x, y, width, entryHeight, soundId -> {
            this.soundIdField.method_1852(soundId);
            this.searchMenu.setVisible(false);
        }, soundId -> SoundUtil.playDynamicSound(soundId, 1.0f, 1.0f), this, this.soundIdField);
        this.soundIdField.method_1863(query -> this.searchMenu.setVisible(this.soundIdField.method_25370() && !query.isEmpty()));
        this.soundIdField.method_25365(true);
        this.searchMenu.setVisible(!this.soundIdField.method_1882().isEmpty());
        this.volumeField = new FaTextField(this.field_22793, centerX + 190, centerY, 50, 20, (class_2561)class_2561.method_43470((String)"Volume"));
        this.volumeField.method_1852(String.valueOf(this.initialData.volume));
        this.method_37063((class_364)this.volumeField);
        this.method_37063((class_364)new FaButton(centerX - 60, this.soundIdField.method_46427() + 80, 80, 20, (class_2561)class_2561.method_43470((String)"Done").method_27694(style -> style.method_36139(14863081)), btn -> {
            float volume = 1.0f;
            try {
                String input = this.volumeField.method_1882().trim();
                if (!input.isEmpty()) {
                    volume = Float.parseFloat(input);
                    if (volume < 0.0f) {
                        volume = 0.0f;
                    }
                    if (volume > 5.0f) {
                        volume = 5.0f;
                    }
                }
            }
            catch (NumberFormatException input) {
                // empty catch block
            }
            FishyConfig.AlertData newData = new FishyConfig.AlertData(this.msgField.method_1882(), this.alertTextField.method_1882(), this.alertColor, this.soundIdField.method_1882(), volume, true);
            FishyConfig.setChatAlert(this.alertKey, newData);
            ChatAlert.refresh();
            this.field_22787.method_1507(this.parent);
        }));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.searchMenu != null) {
            this.searchMenu.setVisible(this.soundIdField.method_25370() && !this.soundIdField.method_1882().isEmpty());
            if (this.searchMenu.isVisible()) {
                this.searchMenu.render(context, this, mouseX, mouseY, delta);
            }
        }
        int centerX = this.field_22789 / 2;
        int y = this.field_22790 / 2 - 10;
        context.method_51433(this.field_22793, "Chat Message", centerX - 300, y - 12, -8355712, false);
        context.method_51433(this.field_22793, "On-screen Title", centerX - 190, y - 12, -8355712, false);
        context.method_51433(this.field_22793, "Color", centerX - 70, y - 12, -8355712, false);
        context.method_51433(this.field_22793, "SoundEvent ID", centerX - 10, y - 12, -8355712, false);
        context.method_51433(this.field_22793, "Volume", centerX + 190, y - 12, -8355712, false);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.soundIdField.method_25370() && (this.msgField.method_25405(mouseX, mouseY) || this.alertTextField.method_25405(mouseX, mouseY) || this.volumeField.method_25405(mouseX, mouseY))) {
            this.soundIdField.method_25365(false);
        }
        if (this.searchMenu != null && this.searchMenu.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.searchMenu != null && this.soundIdField.method_25370() && this.searchMenu.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.searchMenu != null && this.searchMenu.mouseScrolled(mouseX, mouseY, verticalAmount)) {
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public boolean method_25421() {
        return false;
    }
}

