/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.util.function.Consumer;
import me.valkeea.fishyaddons.gui.FaButton;
import me.valkeea.fishyaddons.gui.FaTextField;
import me.valkeea.fishyaddons.gui.ThemedSlider;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class ColorPickerScreen
extends class_437 {
    private float red = 1.0f;
    private float green = 0.0f;
    private float blue = 0.0f;
    private Consumer<float[]> onColorSelected;
    private class_437 parent;
    private FaTextField hexField;

    public ColorPickerScreen(class_437 parent, float[] initialColor, Consumer<float[]> onColorSelected) {
        super((class_2561)class_2561.method_43470((String)"Color Picker"));
        this.parent = parent;
        this.onColorSelected = onColorSelected;
        if (initialColor != null && initialColor.length == 3) {
            this.red = initialColor[0];
            this.green = initialColor[1];
            this.blue = initialColor[2];
        }
    }

    protected void method_25426() {
        int sliderWidth = 150;
        int sliderHeight = 20;
        int x = (this.field_22789 - sliderWidth) / 2;
        int y = this.field_22790 / 4;
        Runnable updateHexField = () -> {
            if (this.hexField != null) {
                this.hexField.method_1852(String.format("#%02X%02X%02X", (int)(this.red * 255.0f), (int)(this.green * 255.0f), (int)(this.blue * 255.0f)));
            }
        };
        this.method_37063((class_364)new Slider(x, y, sliderWidth, sliderHeight, "Red", this.red, value -> {
            this.red = value.floatValue();
            updateHexField.run();
        }));
        this.method_37063((class_364)new Slider(x, y + 25, sliderWidth, sliderHeight, "Green", this.green, value -> {
            this.green = value.floatValue();
            updateHexField.run();
        }));
        this.method_37063((class_364)new Slider(x, y + 50, sliderWidth, sliderHeight, "Blue", this.blue, value -> {
            this.blue = value.floatValue();
            updateHexField.run();
        }));
        class_327 tr = this.field_22793;
        this.hexField = new FaTextField(tr, x, y + 75, sliderWidth, 20, (class_2561)class_2561.method_43470((String)"Hex (e.g. #FF00FF)"));
        this.hexField.method_1880(9);
        this.hexField.method_1852(String.format("#%02X%02X%02X", (int)(this.red * 255.0f), (int)(this.green * 255.0f), (int)(this.blue * 255.0f)));
        this.method_37063((class_364)this.hexField);
        this.method_37063((class_364)new FaButton(x, y + 110, 70, 20, (class_2561)class_2561.method_43470((String)"Cancel").method_10862(class_2583.field_24360.method_36139(0xFF8080)), btn -> this.field_22787.method_1507(this.parent)));
        this.method_37063((class_364)new FaButton(x + 80, y + 110, 70, 20, (class_2561)class_2561.method_43470((String)"Confirm").method_10862(class_2583.field_24360.method_36139(0xCCFFCC)), btn -> {
            String hex = this.hexField.method_1882().trim();
            float[] rgb = new float[]{this.red, this.green, this.blue};
            if (hex.matches("^#?[0-9a-fA-F]{6}$")) {
                try {
                    int color = Integer.parseInt(hex.replace("#", ""), 16);
                    rgb[0] = (float)(color >> 16 & 0xFF) / 255.0f;
                    rgb[1] = (float)(color >> 8 & 0xFF) / 255.0f;
                    rgb[2] = (float)(color & 0xFF) / 255.0f;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.onColorSelected.accept(rgb);
            this.field_22787.method_1507(this.parent);
        }));
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
        int previewSize = 40;
        int px = (this.field_22789 - previewSize) / 2;
        int py = this.field_22790 / 2 + 40;
        context.method_25294(px, py, px + previewSize, py + previewSize, 0xFF000000 | (int)(this.red * 255.0f) << 16 | (int)(this.green * 255.0f) << 8 | (int)(this.blue * 255.0f));
        context.method_49601(px, py, previewSize, previewSize, -1);
    }

    public static float[] intToRGB(int color) {
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        return new float[]{r, g, b};
    }

    public static int rgbToInt(float[] rgb) {
        int r = (int)(rgb[0] * 255.0f) & 0xFF;
        int g = (int)(rgb[1] * 255.0f) & 0xFF;
        int b = (int)(rgb[2] * 255.0f) & 0xFF;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    @Environment(value=EnvType.CLIENT)
    private static class Slider
    extends ThemedSlider {
        private final String labelBase;
        private final Consumer<Float> onChanged;

        public Slider(int x, int y, int width, int height, String label, float value, Consumer<Float> onChanged) {
            super(x, y, width, height, (class_2561)class_2561.method_43470((String)label), value);
            this.labelBase = label;
            this.onChanged = onChanged;
            this.method_25346();
        }

        protected void method_25346() {
            int displayVal = (int)(this.field_22753 * 255.0);
            this.method_25355((class_2561)class_2561.method_43470((String)(this.labelBase + ": " + displayVal)));
        }

        protected void method_25344() {
            this.onChanged.accept(Float.valueOf((float)this.field_22753));
        }
    }
}

