/*
 * Decompiled with CFR 0.152.
 */
package me.valkeea.fishyaddons.gui;

import java.awt.Rectangle;
import java.util.List;
import me.valkeea.fishyaddons.gui.ColorPickerScreen;
import me.valkeea.fishyaddons.gui.FaButton;
import me.valkeea.fishyaddons.gui.FishyPopup;
import me.valkeea.fishyaddons.gui.GuiUtil;
import me.valkeea.fishyaddons.gui.TabbedListScreen;
import me.valkeea.fishyaddons.hud.ElementRegistry;
import me.valkeea.fishyaddons.hud.HudElement;
import me.valkeea.fishyaddons.hud.TitleDisplay;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class HudEditScreen
extends class_437 {
    private HudElement dragging = null;
    private HudElement selectedElement = null;
    private int dragOffsetX;
    private int dragOffsetY;
    private FaButton outlineBtn;
    private FaButton bgBtn;

    public HudEditScreen() {
        super((class_2561)class_2561.method_43470((String)"Edit HUD Elements"));
    }

    protected void method_25426() {
        this.method_37063((class_364)new FaButton(this.field_22789 / 2 - 40, this.field_22790 - 40, 80, 20, (class_2561)class_2561.method_43470((String)"Exit"), btn -> {
            for (HudElement element : ElementRegistry.getElements()) {
                element.setEditingMode(false);
            }
            class_310.method_1551().method_1507(null);
        }));
        this.method_37063((class_364)new FaButton(this.field_22789 / 2 - 40, this.field_22790 - 60, 80, 20, (class_2561)class_2561.method_43470((String)"Color"), btn -> {
            HudElement element = this.selectedElement;
            if (element == null) {
                List<HudElement> elements = ElementRegistry.getElements();
                if (elements.isEmpty()) {
                    return;
                }
                element = elements.get(0);
            }
            if (element instanceof TitleDisplay) {
                this.field_22787.method_1507(new class_437((class_2561)class_2561.method_43470((String)"Alert Color")){
                    FishyPopup popup;

                    protected void method_25426() {
                        this.popup = new FishyPopup((class_2561)class_2561.method_43470((String)"Alert color is set in the alert editor!"), (class_2561)class_2561.method_43470((String)"GO"), () -> this.field_22787.method_1507((class_437)new TabbedListScreen(this.field_22787.field_1755, TabbedListScreen.Tab.ALERT)), (class_2561)class_2561.method_43470((String)"Back"), () -> this.field_22787.method_1507((class_437)HudEditScreen.this));
                        this.popup.init(this.field_22789, this.field_22790);
                    }

                    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
                        this.method_25420(context, mouseX, mouseY, delta);
                        super.method_25394(context, mouseX, mouseY, delta);
                        this.popup.render(context, this.field_22793, mouseX, mouseY, delta);
                    }

                    public boolean method_25402(double mouseX, double mouseY, int button) {
                        return this.popup.mouseClicked(mouseX, mouseY, button) || super.method_25402(mouseX, mouseY, button);
                    }
                });
                return;
            }
            HudElement finalElement = element;
            int color = finalElement.getHudColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            class_310.method_1551().method_1507((class_437)new ColorPickerScreen(this, new float[]{red, green, blue}, rgb -> {
                int newColor = (int)(rgb[0] * 255.0f) << 16 | (int)(rgb[1] * 255.0f) << 8 | (int)(rgb[2] * 255.0f);
                finalElement.setHudColor(newColor);
                finalElement.invalidateCache();
            }));
        }));
        this.outlineBtn = new FaButton(this.field_22789 / 2 - 40, this.field_22790 - 80, 80, 20, GuiUtil.onOffLabel("Outline", this.selectedElement != null && this.selectedElement.getHudOutline()), btn -> {
            HudElement element = this.selectedElement;
            if (element != null) {
                boolean outlined = element.getHudOutline();
                element.setHudOutline(!outlined);
                element.invalidateCache();
                btn.method_25355(GuiUtil.onOffLabel("Outline", !outlined));
            }
        });
        this.method_37063((class_364)this.outlineBtn);
        this.bgBtn = new FaButton(this.field_22789 / 2 - 40, this.field_22790 - 100, 80, 20, GuiUtil.onOffLabel("BG", this.selectedElement != null && this.selectedElement.getHudBg()), btn -> {
            HudElement element = this.selectedElement;
            if (element != null) {
                boolean bg = element.getHudBg();
                element.setHudBg(!bg);
                element.invalidateCache();
                btn.method_25355(GuiUtil.onOffLabel("BG", !bg));
            }
        });
        this.method_37063((class_364)this.bgBtn);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        class_310 mc = class_310.method_1551();
        for (HudElement element : ElementRegistry.getElements()) {
            Rectangle bounds = element.getBounds(mc);
            if (!bounds.contains(mouseX, mouseY)) continue;
            this.dragging = element;
            this.selectedElement = element;
            this.dragOffsetX = (int)mouseX - bounds.x;
            this.dragOffsetY = (int)mouseY - bounds.y;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.dragging != null) {
            this.dragging.setHudPosition((int)mouseX - this.dragOffsetX, (int)mouseY - this.dragOffsetY);
            this.dragging.invalidateCache();
            this.dragging = null;
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging != null) {
            this.dragging.setHudPosition((int)mouseX - this.dragOffsetX, (int)mouseY - this.dragOffsetY);
            this.dragging.invalidateCache();
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context, mouseX, mouseY, delta);
        for (HudElement element : ElementRegistry.getElements()) {
            element.setEditingMode(true);
            element.render(context, mouseX, mouseY);
        }
        if (this.selectedElement != null) {
            int hudX = this.selectedElement.getHudX();
            int hudY = this.selectedElement.getHudY();
            int size = this.selectedElement.getHudSize();
            float scale = (float)size / 12.0f;
            int width = (int)(80.0f * scale);
            int height = size + 4;
            if (this.selectedElement instanceof TitleDisplay) {
                int textWidth = this.field_22793.method_1727("Alert Title");
                int scaledTextWidth = (int)((float)textWidth * scale);
                int boxWidth = Math.max(80, scaledTextWidth + 8);
                int scaledBoxWidth = (int)((float)boxWidth * scale);
                GuiUtil.drawBox(context, hudX - scaledBoxWidth / 2 - 2, hudY - 2, scaledBoxWidth + 4, (int)((float)size + 4.0f * scale), Integer.MIN_VALUE);
            } else {
                GuiUtil.drawBox(context, hudX, hudY, width, height, Integer.MIN_VALUE);
            }
        }
        if (this.outlineBtn != null) {
            this.outlineBtn.method_25355(GuiUtil.onOffLabel("Outline", this.selectedElement != null && this.selectedElement.getHudOutline()));
        }
        if (this.bgBtn != null) {
            this.bgBtn.method_25355(GuiUtil.onOffLabel("BG", this.selectedElement != null && this.selectedElement.getHudBg()));
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25432() {
        for (HudElement element : ElementRegistry.getElements()) {
            element.setEditingMode(false);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        double amount = verticalAmount;
        if (this.selectedElement != null) {
            int currentSize = this.selectedElement.getHudSize();
            int newSize = currentSize + (int)amount;
            if (newSize < 8) {
                newSize = 8;
            }
            if (newSize > 80) {
                newSize = 80;
            }
            this.selectedElement.setHudSize(newSize);
            this.selectedElement.invalidateCache();
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }
}

